/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.math.BigDecimal;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class DecimalValueListener
extends ScalarListener {
    public DecimalValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_STRING: {
                try {
                    this.addValueToListenerMap(this.writer.schema().name(), new BigDecimal(tokenizer.textValue()));
                    this.writer.setDecimal(new BigDecimal(tokenizer.textValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.loader.dataConversionError(this.schema(), "DECIMAL", tokenizer.textValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setDecimal(BigDecimal.ZERO);
    }
}

