/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class DoubleListener
extends ScalarListener {
    public DoubleListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        double value;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_TRUE: {
                value = 1.0;
                break;
            }
            case VALUE_FALSE: {
                value = 0.0;
                break;
            }
            case VALUE_NUMBER_INT: {
                value = tokenizer.longValue();
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = tokenizer.doubleValue();
                break;
            }
            case VALUE_STRING: {
                this.parseString(tokenizer.stringValue());
                return;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), tokenizer.textValue());
        this.writer.setDouble(value);
    }

    private void parseString(String value) {
        if ((value = value.trim()).isEmpty()) {
            this.setNull();
        } else {
            try {
                this.addValueToListenerMap(this.writer.schema().name(), value);
                this.writer.setDouble(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                throw this.loader.dataConversionError(this.schema(), "string", value);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setDouble(0.0);
    }
}

