/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.parser.ValueListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.exec.vector.accessor.UnsupportedConversionError;

public abstract class ScalarListener
implements ValueListener {
    protected final JsonLoaderImpl loader;
    protected final ScalarWriter writer;
    protected final boolean isArray;

    public ScalarListener(JsonLoaderImpl loader, ScalarWriter writer) {
        this.loader = loader;
        this.writer = writer;
        this.isArray = writer.schema().isArray();
    }

    public ColumnMetadata schema() {
        return this.writer.schema();
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        throw this.typeConversionError(token.name());
    }

    @Override
    public void onText(String value) {
        throw this.typeConversionError("text");
    }

    protected void setNull() {
        try {
            if (this.isArray) {
                this.setArrayNull();
            } else {
                this.writer.setNull();
            }
        }
        catch (UnsupportedConversionError e) {
            throw this.loader.buildError(this.schema(), UserException.dataReadError().message("Null value encountered in JSON input where Drill does not allow nulls.", new Object[0]));
        }
    }

    protected void setArrayNull() {
        throw this.loader.nullDisallowedError(this.schema());
    }

    protected UserException typeConversionError(String jsonType) {
        return this.loader.typeConversionError(this.schema(), jsonType);
    }

    protected void addValueToListenerMap(String key, String value) {
        Map<String, Object> listenerColumnMap = this.loader.listenerColumnMap();
        if (listenerColumnMap == null || listenerColumnMap.isEmpty()) {
            return;
        }
        if (listenerColumnMap.containsKey(key) && StringUtils.isNotEmpty((CharSequence)value)) {
            listenerColumnMap.put(key, value);
        }
    }

    protected void addValueToListenerMap(String key, Object value) {
        Map<String, Object> listenerColumnMap = this.loader.listenerColumnMap();
        if (listenerColumnMap == null || listenerColumnMap.isEmpty()) {
            return;
        }
        if (listenerColumnMap.containsKey(key) && value != null) {
            listenerColumnMap.put(key, value);
        }
    }
}

