/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class StrictBigIntValueListener
extends ScalarListener {
    public StrictBigIntValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.writer.setLong(tokenizer.longValue());
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    this.writer.setLong(Long.parseLong(tokenizer.stringValue()));
                    this.addValueToListenerMap(this.writer.schema().name(), Long.parseLong(tokenizer.stringValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.loader.dataConversionError(this.schema(), "string", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setLong(0L);
    }
}

