/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class StrictDoubleValueListener
extends ScalarListener {
    public StrictDoubleValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        double value;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_NUMBER_INT: {
                value = tokenizer.longValue();
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = tokenizer.doubleValue();
                break;
            }
            case VALUE_STRING: {
                try {
                    value = Double.parseDouble(tokenizer.stringValue());
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.loader.dataConversionError(this.schema(), "string", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), value);
        this.writer.setDouble(value);
    }

    @Override
    protected void setArrayNull() {
        this.writer.setDouble(0.0);
    }
}

