/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class StrictIntValueListener
extends ScalarListener {
    public StrictIntValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                this.writer.setInt((int)tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    this.writer.setInt(Integer.parseInt(tokenizer.stringValue()));
                    this.addValueToListenerMap(this.writer.schema().name(), Integer.parseInt(tokenizer.stringValue()));
                    break;
                }
                catch (NumberFormatException e) {
                    throw this.loader.dataConversionError(this.schema(), "string", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setInt(0);
    }
}

