/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class TimeValueListener
extends ScalarListener {
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ISO_TIME;

    public TimeValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                this.writer.setInt((int)tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    LocalTime localTime = LocalTime.parse(tokenizer.stringValue(), TIME_FORMAT);
                    this.addValueToListenerMap(this.writer.schema().name(), localTime);
                    this.writer.setTime(localTime);
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "string", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }
}

