/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class UtcDateValueListener
extends ScalarListener {
    public UtcDateValueListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                break;
            }
            case VALUE_NUMBER_INT: {
                this.addValueToListenerMap(this.writer.schema().name(), tokenizer.longValue());
                this.writer.setLong(tokenizer.longValue());
                break;
            }
            case VALUE_STRING: {
                try {
                    LocalDate localDate = LocalDate.parse(tokenizer.stringValue(), DateUtility.isoFormatDate);
                    ZonedDateTime utc = localDate.atStartOfDay(ZoneOffset.UTC);
                    this.addValueToListenerMap(this.writer.schema().name(), utc.toEpochSecond() * 1000L);
                    this.writer.setLong(utc.toEpochSecond() * 1000L);
                    break;
                }
                catch (Exception e) {
                    throw this.loader.dataConversionError(this.schema(), "date", tokenizer.stringValue());
                }
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
    }
}

