/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.json.values;

import com.fasterxml.jackson.core.JsonToken;
import org.apache.drill.exec.store.easy.json.loader.JsonLoaderImpl;
import org.apache.drill.exec.store.easy.json.parser.TokenIterator;
import org.apache.drill.exec.store.easy.json.values.ScalarListener;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class VarCharListener
extends ScalarListener {
    private final boolean classicArrayNulls;

    public VarCharListener(JsonLoaderImpl loader, ScalarWriter writer) {
        super(loader, writer);
        this.classicArrayNulls = this.isArray ? loader.options().classicArrayNulls : false;
    }

    @Override
    public void onValue(JsonToken token, TokenIterator tokenizer) {
        String value;
        switch (token) {
            case VALUE_NULL: {
                this.setNull();
                return;
            }
            case VALUE_TRUE: {
                value = Boolean.TRUE.toString();
                break;
            }
            case VALUE_FALSE: {
                value = Boolean.FALSE.toString();
                break;
            }
            case VALUE_NUMBER_INT: {
                value = Long.toString(tokenizer.longValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = Double.toString(tokenizer.doubleValue());
                break;
            }
            case VALUE_STRING: {
                value = tokenizer.stringValue();
                break;
            }
            default: {
                throw tokenizer.invalidValue(token);
            }
        }
        this.addValueToListenerMap(this.writer.schema().name(), value);
        this.writer.setString(value);
    }

    @Override
    public void onText(String value) {
        if (value == null) {
            this.setNull();
        } else {
            this.writer.setString(value);
        }
    }

    @Override
    protected void setArrayNull() {
        this.writer.setString(this.classicArrayNulls ? "null" : "");
    }
}

