/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.sequencefile;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileDescrip;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.easy.sequencefile.SequenceFileFormatConfig;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.exec.vector.accessor.ScalarWriter;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.SequenceFileAsBinaryInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileBatchReader
implements ManagedReader {
    private static final Logger logger = LoggerFactory.getLogger(SequenceFileBatchReader.class);
    private final FileDescrip file;
    private final String opUserName;
    private final String queryUserName;
    public static final String KEY_SCHEMA = "binary_key";
    public static final String VALUE_SCHEMA = "binary_value";
    private final BytesWritable key = new BytesWritable();
    private final BytesWritable value = new BytesWritable();
    private final RowSetLoader loader;
    private final ScalarWriter keyWriter;
    private final ScalarWriter valueWriter;
    private RecordReader<BytesWritable, BytesWritable> reader;
    private final CustomErrorContext errorContext;
    private final Stopwatch watch;

    public SequenceFileBatchReader(SequenceFileFormatConfig config, EasySubScan scan, FileSchemaNegotiator negotiator) {
        this.errorContext = negotiator.parentErrorContext();
        this.file = negotiator.file();
        this.opUserName = scan.getUserName();
        this.queryUserName = negotiator.context().getFragmentContext().getQueryUserName();
        negotiator.tableSchema(this.defineMetadata(), true);
        logger.trace("The config is {}, root is {}, columns has {}", new Object[]{config, scan.getSelectionRoot(), scan.getColumns()});
        try {
            this.processReader(negotiator);
        }
        catch (ExecutionSetupException e) {
            throw UserException.dataReadError(e).message("Failure in initial sequencefile reader", new Object[0]).addContext(e.getMessage()).addContext(this.errorContext).build(logger);
        }
        ResultSetLoader setLoader = negotiator.build();
        this.loader = setLoader.writer();
        this.keyWriter = this.loader.scalar(KEY_SCHEMA);
        this.valueWriter = this.loader.scalar(VALUE_SCHEMA);
        this.watch = Stopwatch.createStarted();
    }

    private TupleMetadata defineMetadata() {
        SchemaBuilder builder = new SchemaBuilder();
        builder.addNullable(KEY_SCHEMA, TypeProtos.MinorType.VARBINARY);
        builder.addNullable(VALUE_SCHEMA, TypeProtos.MinorType.VARBINARY);
        return builder.buildSchema();
    }

    private void processReader(FileSchemaNegotiator negotiator) throws ExecutionSetupException {
        SequenceFileAsBinaryInputFormat inputFormat = new SequenceFileAsBinaryInputFormat();
        JobConf jobConf = new JobConf(this.file.fileSystem().getConf());
        jobConf.setInputFormat(inputFormat.getClass());
        this.reader = this.getRecordReader((InputFormat<BytesWritable, BytesWritable>)inputFormat, jobConf);
    }

    private RecordReader<BytesWritable, BytesWritable> getRecordReader(final InputFormat<BytesWritable, BytesWritable> inputFormat, final JobConf jobConf) throws ExecutionSetupException {
        try {
            UserGroupInformation ugi = ImpersonationUtil.createProxyUgi(this.opUserName, this.queryUserName);
            return (RecordReader)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<RecordReader<BytesWritable, BytesWritable>>(){

                @Override
                public RecordReader<BytesWritable, BytesWritable> run() throws Exception {
                    return inputFormat.getRecordReader((InputSplit)SequenceFileBatchReader.this.file.split(), jobConf, Reporter.NULL);
                }
            });
        }
        catch (IOException | InterruptedException e) {
            throw UserException.dataReadError(e).message("Error in creating sequencefile reader for file: %s, start: %d, length: %d", this.file.split().getPath(), this.file.split().getStart(), this.file.split().getLength()).addContext(e.getMessage()).addContext(this.errorContext).build(logger);
        }
    }

    @Override
    public boolean next() {
        try {
            while (!this.loader.isFull()) {
                if (this.reader.next((Object)this.key, (Object)this.value)) {
                    this.loader.start();
                    this.keyWriter.setBytes(this.key.getBytes(), this.key.getLength());
                    this.valueWriter.setBytes(this.value.getBytes(), this.value.getLength());
                    this.loader.save();
                    continue;
                }
                logger.debug("Reader fetch {} records in {} ms", (Object)this.loader.rowCount(), (Object)this.watch.elapsed(TimeUnit.MILLISECONDS));
                this.watch.stop();
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).message("An error occurred while reading the next key/value pair", new Object[0]).addContext(e.getMessage()).addContext(this.errorContext).build(logger);
        }
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).message("Error closing sequencefile reader: " + e.getMessage(), new Object[0]).addContext(this.errorContext).build(logger);
        }
    }
}

