/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.sequencefile;

import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.easy.sequencefile.SequenceFileBatchReader;
import org.apache.drill.exec.store.easy.sequencefile.SequenceFileFormatConfig;
import org.apache.hadoop.conf.Configuration;

public class SequenceFileFormatPlugin
extends EasyFormatPlugin<SequenceFileFormatConfig> {
    public static final String OPERATOR_TYPE = "SEQUENCE_SUB_SCAN";

    public SequenceFileFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, SequenceFileFormatConfig formatConfig) {
        super(name, SequenceFileFormatPlugin.easyConfig(fsConf, formatConfig), context, storageConfig, formatConfig);
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, SequenceFileFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(false).blockSplittable(true).compressible(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).readerOperatorType(OPERATOR_TYPE).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V2).supportsLimitPushdown(true).supportsProjectPushdown(true).defaultName("sequencefile").build();
    }

    @Override
    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        builder.nullType(Types.optional(TypeProtos.MinorType.VARCHAR));
        builder.readerFactory(new SequenceFileReaderFactory((SequenceFileFormatConfig)this.formatConfig, scan));
    }

    private static class SequenceFileReaderFactory
    extends FileReaderFactory {
        private final SequenceFileFormatConfig config;
        private final EasySubScan scan;

        public SequenceFileReaderFactory(SequenceFileFormatConfig config, EasySubScan scan) {
            this.config = config;
            this.scan = scan;
        }

        @Override
        public ManagedReader newReader(FileSchemaNegotiator negotiator) throws ManagedReader.EarlyEofException {
            return new SequenceFileBatchReader(this.config, this.scan, negotiator);
        }
    }
}

