/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableList;

@JsonTypeName(value="text")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class TextFormatConfig
implements FormatPluginConfig {
    public final List<String> extensions;
    public final String lineDelimiter;
    public final char fieldDelimiter;
    public final char quote;
    public final char escape;
    public final char comment;
    public final boolean skipFirstLine;
    public final boolean extractHeader;

    @JsonCreator
    public TextFormatConfig(@JsonProperty(value="extensions") List<String> extensions, @JsonProperty(value="lineDelimiter") String lineDelimiter, @JsonAlias(value={"delimiter"}) @JsonProperty(value="fieldDelimiter") String fieldDelimiter, @JsonProperty(value="quote") String quote, @JsonProperty(value="escape") String escape, @JsonProperty(value="comment") String comment, @JsonProperty(value="skipFirstLine") Boolean skipFirstLine, @JsonProperty(value="extractHeader") Boolean extractHeader) {
        this.extensions = extensions == null ? ImmutableList.of() : ImmutableList.copyOf(extensions);
        this.lineDelimiter = Strings.isNullOrEmpty(lineDelimiter) ? "\n" : lineDelimiter;
        this.fieldDelimiter = (char)(Strings.isNullOrEmpty(fieldDelimiter) ? 44 : (int)fieldDelimiter.charAt(0));
        this.quote = (char)(Strings.isNullOrEmpty(quote) ? 34 : (int)quote.charAt(0));
        this.escape = (char)(Strings.isNullOrEmpty(escape) ? 34 : (int)escape.charAt(0));
        this.comment = (char)(Strings.isNullOrEmpty(comment) ? 35 : (int)comment.charAt(0));
        this.skipFirstLine = skipFirstLine == null ? false : skipFirstLine;
        this.extractHeader = extractHeader == null ? false : extractHeader;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public char getQuote() {
        return this.quote;
    }

    public char getEscape() {
        return this.escape;
    }

    public char getComment() {
        return this.comment;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    @JsonProperty(value="extractHeader")
    public boolean isHeaderExtractionEnabled() {
        return this.extractHeader;
    }

    @JsonProperty(value="fieldDelimiter")
    public String firldDeliterString() {
        return Character.toString(this.fieldDelimiter);
    }

    public int hashCode() {
        return Objects.hash(this.extensions, this.lineDelimiter, Character.valueOf(this.fieldDelimiter), Character.valueOf(this.quote), Character.valueOf(this.escape), Character.valueOf(this.comment), this.skipFirstLine, this.extractHeader);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextFormatConfig other = (TextFormatConfig)obj;
        return Objects.equals(this.extensions, other.extensions) && Objects.equals(this.lineDelimiter, other.lineDelimiter) && Objects.equals(Character.valueOf(this.fieldDelimiter), Character.valueOf(other.fieldDelimiter)) && Objects.equals(Character.valueOf(this.quote), Character.valueOf(other.quote)) && Objects.equals(Character.valueOf(this.escape), Character.valueOf(other.escape)) && Objects.equals(Character.valueOf(this.comment), Character.valueOf(other.comment)) && Objects.equals(this.skipFirstLine, other.skipFirstLine) && Objects.equals(this.extractHeader, other.extractHeader);
    }

    public String toString() {
        return new PlanStringBuilder(this).field("extensions", this.extensions).field("skipFirstLine", this.skipFirstLine).field("extractHeader", this.extractHeader).escapedField("fieldDelimiter", this.fieldDelimiter).escapedField("lineDelimiter", this.lineDelimiter).escapedField("quote", this.quote).escapedField("escape", this.escape).escapedField("comment", this.comment).toString();
    }
}

