/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.common.exceptions.ChildErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileReaderFactory;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileScanLifecycleBuilder;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.metadata.Propertied;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.easy.EasyFormatPlugin;
import org.apache.drill.exec.store.dfs.easy.EasyGroupScan;
import org.apache.drill.exec.store.dfs.easy.EasySubScan;
import org.apache.drill.exec.store.dfs.easy.EasyWriter;
import org.apache.drill.exec.store.easy.text.TextFormatConfig;
import org.apache.drill.exec.store.easy.text.reader.CompliantTextBatchReader;
import org.apache.drill.exec.store.easy.text.reader.TextParsingSettings;
import org.apache.drill.exec.store.easy.text.writer.TextRecordWriter;
import org.apache.drill.exec.store.schedule.CompleteFileWork;
import org.apache.hadoop.conf.Configuration;

public class TextFormatPlugin
extends EasyFormatPlugin<TextFormatConfig> {
    static final String PLUGIN_NAME = "text";
    public static final int MAXIMUM_NUMBER_COLUMNS = 65536;
    public static final int MAX_CHARS_PER_COLUMN = 65535;
    public static final char NULL_CHAR = '\u0000';
    public static final String TEXT_PREFIX = Propertied.pluginPrefix("text");
    public static final String HAS_HEADERS_PROP = TEXT_PREFIX + "extractHeader";
    public static final String SKIP_FIRST_LINE_PROP = TEXT_PREFIX + "skipFirstLine";
    public static final String DELIMITER_PROP = TEXT_PREFIX + "fieldDelimiter";
    public static final String COMMENT_CHAR_PROP = TEXT_PREFIX + "comment";
    public static final String QUOTE_PROP = TEXT_PREFIX + "quote";
    public static final String QUOTE_ESCAPE_PROP = TEXT_PREFIX + "escape";
    public static final String LINE_DELIM_PROP = TEXT_PREFIX + "lineDelimiter";
    public static final String TRIM_WHITESPACE_PROP = TEXT_PREFIX + "trim";
    public static final String PARSE_UNESCAPED_QUOTES_PROP = TEXT_PREFIX + "parseQuotes";
    public static final String WRITER_OPERATOR_TYPE = "TEXT_WRITER";

    public TextFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig config, TextFormatConfig formatPluginConfig) {
        super(name, TextFormatPlugin.easyConfig(fsConf, formatPluginConfig), context, config, formatPluginConfig);
    }

    private static EasyFormatPlugin.EasyFormatConfig easyConfig(Configuration fsConf, TextFormatConfig pluginConfig) {
        return EasyFormatPlugin.EasyFormatConfig.builder().readable(true).writable(true).blockSplittable(true).compressible(true).supportsProjectPushdown(true).extensions(pluginConfig.getExtensions()).fsConf(fsConf).defaultName(PLUGIN_NAME).writerOperatorType(WRITER_OPERATOR_TYPE).scanVersion(EasyFormatPlugin.ScanFrameworkVersion.EVF_V2).supportsLimitPushdown(true).build();
    }

    @Override
    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, MetadataProviderManager metadataProviderManager) throws IOException {
        return new EasyGroupScan(userName, selection, this, columns, selection.selectionRoot, metadataProviderManager);
    }

    @Override
    public AbstractGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, OptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        return new EasyGroupScan(userName, selection, this, columns, selection.selectionRoot, options == null ? 1 : (int)options.getLong("exec.storage.min_width"), metadataProviderManager);
    }

    @Override
    protected void configureScan(FileScanLifecycleBuilder builder, EasySubScan scan) {
        TextParsingSettings settings = new TextParsingSettings((TextFormatConfig)this.getConfig(), scan.getSchema());
        builder.readerFactory(new TextReaderFactory(settings));
        builder.nullType(Types.required(TypeProtos.MinorType.VARCHAR));
        builder.errorContext(new ChildErrorContext(builder.errorContext()){

            @Override
            public void addContext(UserException.Builder builder) {
                super.addContext(builder);
                builder.addContext("Extract headers", Boolean.toString(((TextFormatConfig)TextFormatPlugin.this.getConfig()).isHeaderExtractionEnabled()));
                builder.addContext("Skip first line", Boolean.toString(((TextFormatConfig)TextFormatPlugin.this.getConfig()).isSkipFirstLine()));
            }
        });
    }

    @Override
    public RecordWriter getRecordWriter(FragmentContext context, EasyWriter writer) throws IOException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("location", writer.getLocation());
        TextFormatConfig config = (TextFormatConfig)this.getConfig();
        List<String> extensions = config.getExtensions();
        options.put("extension", extensions == null || extensions.isEmpty() ? null : extensions.get(0));
        ExecProtos.FragmentHandle handle = context.getHandle();
        String fragmentId = String.format("%d_%d", handle.getMajorFragmentId(), handle.getMinorFragmentId());
        options.put("prefix", fragmentId);
        options.put("addHeader", Boolean.toString(context.getOptions().getBoolean("store.text.writer.add_header")));
        options.put("forceQuotes", Boolean.toString(context.getOptions().getBoolean("store.text.writer.force_quotes")));
        options.put("lineSeparator", config.getLineDelimiter());
        options.put("fieldDelimiter", String.valueOf(config.getFieldDelimiter()));
        options.put("quote", String.valueOf(config.getQuote()));
        options.put("escape", String.valueOf(config.getEscape()));
        TextRecordWriter recordWriter = new TextRecordWriter(context.getAllocator(), writer.getStorageStrategy(), writer.getFormatPlugin().getFsConf());
        recordWriter.init(options);
        return recordWriter;
    }

    @Override
    protected ScanStats getScanStats(PlannerSettings settings, EasyGroupScan scan) {
        long data = 0L;
        for (CompleteFileWork work : scan.getWorkIterable()) {
            data += work.getTotalBytes();
        }
        double estimatedRowSize = settings.getOptions().getOption(ExecConstants.TEXT_ESTIMATED_ROW_SIZE);
        double estRowCount = (double)data / estimatedRowSize;
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, (long)estRowCount, 1.0, data);
    }

    private static class TextReaderFactory
    extends FileReaderFactory {
        private final TextParsingSettings settings;

        public TextReaderFactory(TextParsingSettings settings) {
            this.settings = settings;
        }

        @Override
        public ManagedReader newReader(FileSchemaNegotiator negotiator) throws ManagedReader.EarlyEofException {
            return new CompliantTextBatchReader(negotiator, this.settings);
        }
    }
}

