/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.store.easy.text.reader.TextOutput;
import org.apache.drill.exec.vector.accessor.ValueWriter;

public abstract class BaseFieldOutput
implements TextOutput {
    private static final int BUFFER_LEN = 1024;
    protected int currentFieldIndex = -1;
    protected int currentDataPointer;
    private boolean fieldOpen = true;
    protected int fieldWriteCount;
    protected byte[] fieldBytes;
    protected final RowSetLoader writer;
    private final boolean[] projectionMask;
    protected final int maxField;
    protected boolean fieldProjected;

    public BaseFieldOutput(RowSetLoader writer, int maxField, boolean[] projectionMask) {
        this.writer = writer;
        this.projectionMask = projectionMask;
        if (projectionMask == null) {
            this.maxField = maxField;
        } else {
            int end;
            for (end = projectionMask.length - 1; end >= 0 && !projectionMask[end]; --end) {
            }
            this.maxField = end;
        }
        if (maxField >= 0) {
            this.fieldBytes = new byte[1024];
        }
    }

    @Override
    public void startRecord() {
        this.currentFieldIndex = -1;
        this.fieldOpen = false;
        this.writer.start();
    }

    @Override
    public void startField(int index) {
        assert (index == this.currentFieldIndex + 1);
        this.currentFieldIndex = index;
        this.currentDataPointer = 0;
        this.fieldWriteCount = 0;
        this.fieldOpen = true;
        this.fieldProjected = this.projectionMask == null ? this.currentFieldIndex <= this.maxField : (this.currentFieldIndex >= this.projectionMask.length ? false : this.projectionMask[this.currentFieldIndex]);
    }

    @Override
    public void append(byte data) {
        if (!this.fieldProjected) {
            return;
        }
        if (this.currentDataPointer >= 1023) {
            this.writeToVector();
        }
        this.fieldBytes[this.currentDataPointer++] = data;
    }

    protected void writeToVector() {
        if (!this.fieldProjected) {
            return;
        }
        ValueWriter colWriter = this.columnWriter();
        if (this.fieldWriteCount == 0) {
            colWriter.setBytes(this.fieldBytes, this.currentDataPointer);
        } else {
            colWriter.appendBytes(this.fieldBytes, this.currentDataPointer);
        }
        this.fieldWriteCount += this.currentDataPointer;
        this.currentDataPointer = 0;
    }

    protected abstract ValueWriter columnWriter();

    @Override
    public boolean endField() {
        this.fieldOpen = false;
        return this.currentFieldIndex < this.maxField;
    }

    @Override
    public boolean endEmptyField() {
        return this.endField();
    }

    @Override
    public void finishRecord() {
        if (this.fieldOpen) {
            this.endField();
        }
        this.writer.save();
    }

    @Override
    public long getRecordCount() {
        return this.writer.rowCount();
    }

    @Override
    public boolean isFull() {
        return this.writer.isFull();
    }
}

