/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import com.univocity.parsers.common.TextParsingException;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.io.InputStream;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.CustomErrorContext;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.physical.impl.scan.v3.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.v3.file.FileSchemaNegotiator;
import org.apache.drill.exec.physical.impl.scan.v3.schema.ProjectedColumn;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.easy.text.reader.ConstrainedFieldOutput;
import org.apache.drill.exec.store.easy.text.reader.FieldVarCharOutput;
import org.apache.drill.exec.store.easy.text.reader.HeaderBuilder;
import org.apache.drill.exec.store.easy.text.reader.RepeatedVarCharOutput;
import org.apache.drill.exec.store.easy.text.reader.TextInput;
import org.apache.drill.exec.store.easy.text.reader.TextOutput;
import org.apache.drill.exec.store.easy.text.reader.TextParsingSettings;
import org.apache.drill.exec.store.easy.text.reader.TextReader;
import org.apache.drill.exec.vector.accessor.ValueWriter;
import org.apache.hadoop.mapred.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompliantTextBatchReader
implements ManagedReader {
    private static final Logger logger = LoggerFactory.getLogger(CompliantTextBatchReader.class);
    public static final String COLUMNS_COL = "columns";
    private static final int MAX_RECORDS_PER_BATCH = 8096;
    private static final int READ_BUFFER = 0x100000;
    private static final int WHITE_SPACE_BUFFER = 65536;
    private final TextParsingSettings settings;
    private final CustomErrorContext errorContext;
    private final TextReader reader;
    private final DrillBuf readBuffer;
    private final DrillBuf whitespaceBuffer;
    private RowSetLoader writer;

    public CompliantTextBatchReader(FileSchemaNegotiator schemaNegotiator, TextParsingSettings settings) throws ManagedReader.EarlyEofException {
        this.settings = settings;
        this.errorContext = schemaNegotiator.parentErrorContext();
        if (settings.getNewLineDelimiter().length == 0) {
            throw UserException.validationError().message("The text format line delimiter cannot be blank.", new Object[0]).addContext(this.errorContext).build(logger);
        }
        OperatorContext context = schemaNegotiator.context();
        this.readBuffer = context.getAllocator().buffer(0x100000);
        this.whitespaceBuffer = context.getAllocator().buffer(65536);
        schemaNegotiator.batchSize(8096);
        try {
            TextOutput output = settings.isHeaderExtractionEnabled() ? this.openWithHeaders(schemaNegotiator) : this.openWithoutHeaders(schemaNegotiator);
            if (output == null) {
                throw new ManagedReader.EarlyEofException();
            }
            this.reader = this.openReader(schemaNegotiator, output);
        }
        catch (IOException e) {
            throw UserException.dataReadError(e).addContext("File open failed").addContext(this.errorContext).build(logger);
        }
    }

    private TextOutput openWithHeaders(FileSchemaNegotiator schemaNegotiator) throws IOException {
        this.validateNoColumnsProjection(schemaNegotiator);
        String[] fieldNames = this.extractHeader(schemaNegotiator);
        if (fieldNames == null) {
            return null;
        }
        if (schemaNegotiator.providedSchema() != null) {
            return this.buildWithSchema(schemaNegotiator, fieldNames);
        }
        return this.buildFromColumnHeaders(schemaNegotiator, fieldNames);
    }

    private FieldVarCharOutput buildWithSchema(FileSchemaNegotiator schemaNegotiator, String[] fieldNames) {
        TupleMetadata readerSchema = this.buildSchemaFromHeaders(fieldNames);
        FixedReceiver.Builder builder = FixedReceiver.builderFor(schemaNegotiator).schemaIsComplete();
        builder.conversionBuilder().blankAs("null");
        FixedReceiver receiver = builder.build(readerSchema);
        this.writer = receiver.rowWriter();
        return new FieldVarCharOutput(receiver);
    }

    private TupleMetadata buildSchemaFromHeaders(String[] fieldNames) {
        TupleSchema readerSchema = new TupleSchema();
        for (String name : fieldNames) {
            readerSchema.addColumn(this.textColumn(name));
        }
        return readerSchema;
    }

    private ColumnMetadata textColumn(String colName) {
        return MetadataUtils.newScalar(colName, TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.REQUIRED);
    }

    private FieldVarCharOutput buildFromColumnHeaders(FileSchemaNegotiator schemaNegotiator, String[] fieldNames) {
        TupleMetadata readerSchema = this.buildSchemaFromHeaders(fieldNames);
        schemaNegotiator.tableSchema(readerSchema, true);
        this.writer = schemaNegotiator.build().writer();
        ValueWriter[] colWriters = new ValueWriter[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            colWriters[i] = this.writer.column(i).scalar();
        }
        return new FieldVarCharOutput(this.writer, colWriters);
    }

    private TextOutput openWithoutHeaders(FileSchemaNegotiator schemaNegotiator) {
        TupleMetadata providedSchema = schemaNegotiator.providedSchema();
        if (providedSchema != null && providedSchema.size() > 0) {
            return this.buildWithSchema(schemaNegotiator);
        }
        return this.buildColumnsArray(schemaNegotiator);
    }

    private FieldVarCharOutput buildWithSchema(FileSchemaNegotiator schemaNegotiator) {
        this.validateNoColumnsProjection(schemaNegotiator);
        TupleSchema readerSchema = new TupleSchema();
        for (ColumnMetadata providedCol : schemaNegotiator.providedSchema()) {
            readerSchema.addColumn(this.textColumn(providedCol.name()));
        }
        FixedReceiver.Builder builder = FixedReceiver.builderFor(schemaNegotiator).schemaIsComplete();
        builder.conversionBuilder().blankAs("null");
        FixedReceiver receiver = builder.build(readerSchema);
        this.writer = receiver.rowWriter();
        return new ConstrainedFieldOutput(receiver);
    }

    private void validateNoColumnsProjection(FileSchemaNegotiator schemaNegotiator) {
        ProjectedColumn colProj = schemaNegotiator.projectionFor(COLUMNS_COL);
        if (colProj != null && colProj.isArray()) {
            throw UserException.validationError().message("Unexpected `columns`[x]; file has headers or schema", new Object[0]).addContext(this.errorContext).build(logger);
        }
    }

    private TextOutput buildColumnsArray(FileSchemaNegotiator schemaNegotiator) {
        ProjectedColumn colProj = schemaNegotiator.projectionFor(COLUMNS_COL);
        this.validateColumnsProjection(colProj);
        schemaNegotiator.tableSchema(CompliantTextBatchReader.columnsSchema(), true);
        this.writer = schemaNegotiator.build().writer();
        return new RepeatedVarCharOutput(this.writer, colProj == null ? null : colProj.indexes());
    }

    private void validateColumnsProjection(ProjectedColumn colProj) {
        int maxIndex;
        if (colProj == null) {
            return;
        }
        if (colProj.isMap()) {
            throw UserException.validationError().message("Column `%s` has map elements, but must be an array", colProj.name()).addContext(this.errorContext).build(logger);
        }
        if (colProj.isArray() && (maxIndex = colProj.maxIndex()) > 65536) {
            throw UserException.validationError().message("`columns`[%d] index out of bounds, max supported size is %d", maxIndex, 65536).addContext("Column:", colProj.name()).addContext("Maximum index:", 65536L).addContext("Actual index:", maxIndex).addContext(this.errorContext).build(logger);
        }
    }

    private TextReader openReader(FileSchemaNegotiator schemaNegotiator, TextOutput output) throws IOException {
        FileSplit split = schemaNegotiator.file().split();
        logger.trace("Opening file {}", (Object)split.getPath());
        InputStream stream = schemaNegotiator.file().open();
        TextInput input = new TextInput(this.settings, stream, this.readBuffer, split.getStart(), split.getStart() + split.getLength());
        TextReader reader = new TextReader(this.settings, input, output, this.whitespaceBuffer);
        reader.start();
        return reader;
    }

    public static TupleMetadata columnsSchema() {
        return new SchemaBuilder().addArray(COLUMNS_COL, TypeProtos.MinorType.VARCHAR).buildSchema();
    }

    private String[] extractHeader(FileSchemaNegotiator schemaNegotiator) throws IOException {
        String[] fieldNames;
        assert (this.settings.isHeaderExtractionEnabled());
        this.settings.setSkipFirstLine(false);
        FileSplit split = schemaNegotiator.file().split();
        logger.trace("Opening file {}", (Object)split.getPath());
        InputStream hStream = schemaNegotiator.file().open();
        HeaderBuilder hOutput = new HeaderBuilder(split.getPath());
        TextInput hInput = new TextInput(this.settings, hStream, this.readBuffer, 0L, split.getLength());
        try (TextReader reader = new TextReader(this.settings, hInput, hOutput, this.whitespaceBuffer);){
            reader.start();
            reader.parseNext();
            fieldNames = hOutput.getHeaders();
        }
        this.settings.setSkipFirstLine(true);
        this.readBuffer.clear();
        this.whitespaceBuffer.clear();
        return fieldNames;
    }

    @Override
    public boolean next() {
        this.reader.resetForNextBatch();
        try {
            boolean more = false;
            while (!this.writer.isFull() && (more = this.reader.parseNext())) {
            }
            this.reader.finishBatch();
            return more;
        }
        catch (TextParsingException | IOException e) {
            if (e.getCause() != null && e.getCause() instanceof UserException) {
                throw (UserException)e.getCause();
            }
            throw UserException.dataReadError(e).addContext("Failure while reading file").addContext("Happened at or shortly before byte position", this.reader.getPos()).addContext(this.errorContext).build(logger);
        }
    }

    @Override
    public void close() {
        this.readBuffer.release();
        this.whitespaceBuffer.release();
        AutoCloseables.closeSilently(this.reader);
    }
}

