/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import org.apache.drill.exec.physical.impl.scan.v3.FixedReceiver;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.text.reader.BaseFieldOutput;
import org.apache.drill.exec.vector.accessor.ValueWriter;

class FieldVarCharOutput
extends BaseFieldOutput {
    protected final ValueWriter[] colWriters;

    FieldVarCharOutput(RowSetLoader writer, ValueWriter[] colWriters) {
        super(writer, 65536, FieldVarCharOutput.makeMask(writer));
        this.colWriters = colWriters;
    }

    FieldVarCharOutput(FixedReceiver receiver) {
        this(receiver.rowWriter(), FieldVarCharOutput.makeWriters(receiver));
    }

    private static ValueWriter[] makeWriters(FixedReceiver receiver) {
        TupleMetadata schema = receiver.rowWriter().tupleSchema();
        ValueWriter[] colWriters = new ValueWriter[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            colWriters[i] = receiver.scalar(i);
        }
        return colWriters;
    }

    private static boolean[] makeMask(RowSetLoader writer) {
        TupleMetadata schema = writer.tupleSchema();
        boolean[] projectionMask = new boolean[schema.size()];
        for (int i = 0; i < schema.size(); ++i) {
            projectionMask[i] = writer.column(i).isProjected();
        }
        return projectionMask;
    }

    @Override
    public boolean endField() {
        this.writeToVector();
        return super.endField();
    }

    @Override
    protected ValueWriter columnWriter() {
        return this.colWriters[this.currentFieldIndex];
    }
}

