/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import java.nio.charset.StandardCharsets;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.easy.text.TextFormatConfig;
import org.apache.drill.exec.store.easy.text.TextFormatPlugin;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class TextParsingSettings {
    private final byte quote;
    private final byte quoteEscape;
    private final byte delimiter;
    private final byte comment;
    private final long maxCharsPerColumn = 65535L;
    private final byte normalizedNewLine = TextParsingSettings.b('\n');
    private final byte[] newLineDelimiter;
    private final String lineSeparatorString;
    private boolean skipFirstLine;
    private final boolean headerExtractionEnabled;
    private final boolean parseUnescapedQuotes;
    private final boolean ignoreLeadingWhitespace;
    private final boolean ignoreTrailingWhitespace;

    public TextParsingSettings(TextFormatConfig config, TupleMetadata providedSchema) {
        boolean extractHeaders = config.isHeaderExtractionEnabled();
        boolean skipFirst = config.isSkipFirstLine();
        boolean ignoreLeadingWhitespace = false;
        boolean ignoreTrailingWhitespace = false;
        boolean parseUnescapedQuotes = true;
        byte delimChar = TextParsingSettings.bSafe(config.getFieldDelimiter(), "fieldDelimiter");
        byte commentChar = TextParsingSettings.bSafe(config.getComment(), "comment");
        byte quoteChar = TextParsingSettings.bSafe(config.getQuote(), "quote");
        byte quoteEscapeChar = TextParsingSettings.bSafe(config.getEscape(), "escape");
        byte[] newlineDelim = config.getLineDelimiter().getBytes(Charsets.UTF_8);
        if (providedSchema != null) {
            skipFirst = !(extractHeaders = providedSchema.booleanProperty(TextFormatPlugin.HAS_HEADERS_PROP, extractHeaders)) & providedSchema.booleanProperty(TextFormatPlugin.SKIP_FIRST_LINE_PROP, this.skipFirstLine);
            skipFirst = !extractHeaders & providedSchema.booleanProperty(TextFormatPlugin.SKIP_FIRST_LINE_PROP, this.skipFirstLine);
            ignoreLeadingWhitespace = providedSchema.booleanProperty(TextFormatPlugin.TRIM_WHITESPACE_PROP, ignoreLeadingWhitespace);
            ignoreTrailingWhitespace = providedSchema.booleanProperty(TextFormatPlugin.TRIM_WHITESPACE_PROP, ignoreTrailingWhitespace);
            parseUnescapedQuotes = providedSchema.booleanProperty(TextFormatPlugin.PARSE_UNESCAPED_QUOTES_PROP, parseUnescapedQuotes);
            delimChar = TextParsingSettings.overrideChar(providedSchema, TextFormatPlugin.DELIMITER_PROP, delimChar);
            quoteChar = TextParsingSettings.overrideChar(providedSchema, TextFormatPlugin.QUOTE_PROP, quoteChar);
            quoteEscapeChar = TextParsingSettings.overrideChar(providedSchema, TextFormatPlugin.QUOTE_ESCAPE_PROP, quoteEscapeChar);
            newlineDelim = TextParsingSettings.newlineDelimBytes(providedSchema, newlineDelim);
            commentChar = TextParsingSettings.commentChar(providedSchema, commentChar);
        }
        this.skipFirstLine = !extractHeaders && skipFirst;
        this.headerExtractionEnabled = extractHeaders;
        this.quote = quoteChar;
        this.quoteEscape = quoteEscapeChar;
        this.newLineDelimiter = newlineDelim;
        this.lineSeparatorString = new String(this.newLineDelimiter);
        this.delimiter = delimChar;
        this.comment = commentChar;
        this.ignoreLeadingWhitespace = ignoreLeadingWhitespace;
        this.ignoreTrailingWhitespace = ignoreTrailingWhitespace;
        this.parseUnescapedQuotes = parseUnescapedQuotes;
    }

    private static byte overrideChar(TupleMetadata providedSchema, String propName, byte configValue) {
        String value = providedSchema.property(propName);
        if (value == null || value.isEmpty()) {
            return configValue;
        }
        return (byte)value.charAt(0);
    }

    private static byte commentChar(TupleMetadata providedSchema, byte configValue) {
        String value = providedSchema.property(TextFormatPlugin.COMMENT_CHAR_PROP);
        if (value == null) {
            return configValue;
        }
        if (value.isEmpty()) {
            return 0;
        }
        return (byte)value.charAt(0);
    }

    private static byte[] newlineDelimBytes(TupleMetadata providedSchema, byte[] configValue) {
        String value = providedSchema.property(TextFormatPlugin.LINE_DELIM_PROP);
        if (value == null || value.isEmpty()) {
            return configValue;
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public byte getComment() {
        return this.comment;
    }

    public boolean isSkipFirstLine() {
        return this.skipFirstLine;
    }

    public void setSkipFirstLine(boolean skipFirstLine) {
        this.skipFirstLine = skipFirstLine;
    }

    private static byte bSafe(char c, String name) {
        if (c > '\u007f') {
            throw new IllegalArgumentException(String.format("Failure validating configuration option %s.  Expected a character between 0 and 127 but value was actually %d.", name, (int)c));
        }
        return (byte)c;
    }

    private static byte b(char c) {
        return (byte)c;
    }

    public byte[] getNewLineDelimiter() {
        return this.newLineDelimiter;
    }

    public byte getQuote() {
        return this.quote;
    }

    public String getLineSeparatorString() {
        return this.lineSeparatorString;
    }

    public byte getQuoteEscape() {
        return this.quoteEscape;
    }

    public byte getDelimiter() {
        return this.delimiter;
    }

    public boolean parseUnescapedQuotes() {
        return this.parseUnescapedQuotes;
    }

    public boolean isHeaderExtractionEnabled() {
        return this.headerExtractionEnabled;
    }

    public long getMaxCharsPerColumn() {
        return 65535L;
    }

    public byte getNormalizedNewLine() {
        return this.normalizedNewLine;
    }

    public boolean ignoreLeadingWhitespace() {
        return this.ignoreLeadingWhitespace;
    }

    public boolean ignoreTrailingWhitespace() {
        return this.ignoreTrailingWhitespace;
    }
}

