/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.easy.text.reader;

import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.TextParsingException;
import io.netty.buffer.DrillBuf;
import java.io.IOException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.easy.text.reader.StreamFinishedPseudoException;
import org.apache.drill.exec.store.easy.text.reader.TextInput;
import org.apache.drill.exec.store.easy.text.reader.TextOutput;
import org.apache.drill.exec.store.easy.text.reader.TextParsingContext;
import org.apache.drill.exec.store.easy.text.reader.TextParsingSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextReader
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TextReader.class);
    private static final byte NULL_BYTE = 0;
    private final TextParsingContext context;
    private final TextParsingSettings settings;
    private final TextInput input;
    private final TextOutput output;
    private final DrillBuf workBuf;
    private byte ch;
    private int fieldIndex;
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private final boolean parseUnescapedQuotes;
    private final byte comment;
    private final byte delimiter;
    private final byte quote;
    private final byte quoteEscape;
    private final byte newLine;

    public TextReader(TextParsingSettings settings, TextInput input, TextOutput output, DrillBuf workBuf) {
        this.context = new TextParsingContext(input, output);
        this.workBuf = workBuf;
        this.settings = settings;
        this.ignoreTrailingWhitespace = settings.ignoreTrailingWhitespace();
        this.ignoreLeadingWhitespace = settings.ignoreLeadingWhitespace();
        this.parseUnescapedQuotes = settings.parseUnescapedQuotes();
        this.delimiter = settings.getDelimiter();
        this.quote = settings.getQuote();
        this.quoteEscape = settings.getQuoteEscape();
        this.newLine = settings.getNormalizedNewLine();
        this.comment = settings.getComment();
        this.input = input;
        this.output = output;
    }

    public TextOutput getOutput() {
        return this.output;
    }

    static boolean isWhite(byte b) {
        return b <= 32 && b > -1;
    }

    public void resetForNextBatch() {
    }

    public long getPos() {
        return this.input.getPos();
    }

    private boolean parseRecord() throws IOException {
        byte newLine = this.newLine;
        TextInput input = this.input;
        input.mark();
        this.fieldIndex = 0;
        if (this.ignoreLeadingWhitespace && TextReader.isWhite(this.ch)) {
            this.skipWhitespace();
        }
        this.output.startRecord();
        int fieldsWritten = 0;
        try {
            while (this.ch != newLine) {
                this.parseField();
                ++fieldsWritten;
                if (this.ch == newLine) continue;
                this.ch = input.nextChar();
                if (this.ch != newLine) continue;
                this.output.startField(fieldsWritten++);
                this.output.endEmptyField();
                break;
            }
            this.output.finishRecord();
        }
        catch (StreamFinishedPseudoException e) {
            if (fieldsWritten == 0) {
                throw e;
            }
            this.output.finishRecord();
        }
        return true;
    }

    private void parseValueIgnore() throws IOException {
        byte newLine = this.newLine;
        byte delimiter = this.delimiter;
        TextInput input = this.input;
        byte ch = this.ch;
        while (ch != delimiter && ch != newLine) {
            this.appendIgnoringWhitespace(ch);
            ch = input.nextChar();
        }
        this.ch = ch;
    }

    public void appendIgnoringWhitespace(byte data) {
        if (!TextReader.isWhite(data)) {
            this.output.append(data);
        }
    }

    private void parseValueAll() throws IOException {
        byte newLine = this.newLine;
        byte delimiter = this.delimiter;
        TextOutput output = this.output;
        TextInput input = this.input;
        byte ch = this.ch;
        while (ch != delimiter && ch != newLine) {
            output.append(ch);
            ch = input.nextChar();
        }
        this.ch = ch;
    }

    private void parseValue() throws IOException {
        if (this.ignoreTrailingWhitespace) {
            this.parseValueIgnore();
        } else {
            this.parseValueAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseQuotedValue(byte prev) throws IOException {
        byte newLine = this.newLine;
        byte delimiter = this.delimiter;
        TextOutput output = this.output;
        TextInput input = this.input;
        byte quote = this.quote;
        byte quoteEscape = this.quoteEscape;
        this.ch = input.nextCharNoNewLineCheck();
        while (prev != quote || this.ch != delimiter && this.ch != newLine && !TextReader.isWhite(this.ch)) {
            block16: {
                if (this.ch == quote) {
                    if (prev == quoteEscape) {
                        output.append(this.ch);
                        prev = 0;
                        break block16;
                    } else {
                        prev = this.ch;
                        this.ch = input.nextChar();
                        continue;
                    }
                }
                if (prev == quoteEscape) {
                    output.append(prev);
                } else if (prev == quote) {
                    if (!this.parseUnescapedQuotes) {
                        throw new TextParsingException((ParsingContext)this.context, "Unescaped quote character '" + quote + "' inside quoted value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
                    }
                    output.append(prev);
                    break;
                }
                if (this.ch == quoteEscape) {
                    prev = this.ch;
                } else {
                    output.append(this.ch);
                    prev = this.ch;
                }
            }
            this.ch = input.nextCharNoNewLineCheck();
        }
        if (this.ch != newLine && this.ch <= 32 && this.ch != delimiter) {
            DrillBuf workBuf = this.workBuf;
            workBuf.resetWriterIndex();
            do {
                workBuf.writeByte(this.ch);
                this.ch = input.nextChar();
                if (this.ch != newLine) continue;
                return;
            } while (this.ch <= 32 && this.ch != delimiter);
            if (this.ch != delimiter && this.ch != newLine && this.parseUnescapedQuotes) {
                output.append(quote);
                for (int i = 0; i < workBuf.writerIndex(); ++i) {
                    output.append(workBuf.getByte(i));
                }
                if (this.ch != quoteEscape) {
                    output.append(this.ch);
                }
                this.parseQuotedValue(this.ch);
            }
        }
        if (this.ch != delimiter && this.ch != newLine) {
            throw new TextParsingException((ParsingContext)this.context, "Unexpected character '" + this.ch + "' following quoted value of CSV field. Expecting '" + delimiter + "'. Cannot parse CSV input.");
        }
    }

    private boolean parseField() throws IOException {
        this.output.startField(this.fieldIndex++);
        if (TextReader.isWhite(this.ch) && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        if (this.ch == this.delimiter) {
            return this.output.endEmptyField();
        }
        try {
            if (this.ch == this.quote) {
                this.parseQuotedValue((byte)0);
            } else {
                this.parseValue();
            }
            return this.output.endField();
        }
        catch (StreamFinishedPseudoException e) {
            return this.output.endField();
        }
    }

    private void skipWhitespace() throws IOException {
        byte delimiter = this.delimiter;
        byte newLine = this.newLine;
        TextInput input = this.input;
        while (TextReader.isWhite(this.ch) && this.ch != delimiter && this.ch != newLine) {
            this.ch = input.nextChar();
        }
    }

    public final void start() throws IOException {
        this.context.stop(false);
        this.input.start();
    }

    public final boolean parseNext() throws IOException {
        try {
            while (!this.context.isStopped()) {
                this.ch = this.input.nextChar();
                if (this.ch != this.comment) break;
                this.input.skipLines(1);
            }
            long initialLineNumber = this.input.lineCount();
            boolean success = this.parseRecord();
            if (initialLineNumber + 1L < this.input.lineCount()) {
                throw new TextParsingException((ParsingContext)this.context, "Cannot use newline character within quoted string");
            }
            return success;
        }
        catch (UserException ex) {
            this.stopParsing();
            throw ex;
        }
        catch (StreamFinishedPseudoException ex) {
            this.stopParsing();
            return false;
        }
        catch (Exception ex) {
            try {
                throw this.handleException(ex);
            }
            catch (Throwable throwable) {
                this.stopParsing();
                throw throwable;
            }
        }
    }

    private void stopParsing() {
    }

    private String displayLineSeparators(String str, boolean addNewLine) {
        if (addNewLine) {
            str = str.contains("\r\n") ? str.replaceAll("\\r\\n", "[\\\\r\\\\n]\r\n\t") : (str.contains("\n") ? str.replaceAll("\\n", "[\\\\n]\n\t") : str.replaceAll("\\r", "[\\\\r]\r\t"));
        } else {
            str = str.replaceAll("\\n", "\\\\n");
            str = str.replaceAll("\\r", "\\\\r");
        }
        return str;
    }

    private TextParsingException handleException(Exception ex) throws IOException {
        if (ex instanceof TextParsingException) {
            throw (TextParsingException)((Object)ex);
        }
        String message = null;
        String tmp = this.input.getStringSinceMarkForError();
        char[] chars = tmp.toCharArray();
        if (chars != null) {
            int length = chars.length;
            if ((long)length > this.settings.getMaxCharsPerColumn()) {
                message = "Length of parsed input (" + length + ") exceeds the maximum number of characters defined in your parser settings (" + this.settings.getMaxCharsPerColumn() + "). ";
            }
            if (tmp.contains("\n") || tmp.contains("\r")) {
                tmp = this.displayLineSeparators(tmp, true);
                String lineSeparator = this.displayLineSeparators(this.settings.getLineSeparatorString(), false);
                message = message + "\nIdentified line separator characters in the parsed content. This may be the cause of the error. The line separator in your parser settings is set to '" + lineSeparator + "'. Parsed content:\n\t" + tmp;
            }
            int nullCharacterCount = 0;
            int maxLength = length > 0x3FFFFFFF ? 0x3FFFFFFE : length;
            StringBuilder s = new StringBuilder(maxLength);
            for (int i = 0; i < maxLength; ++i) {
                if (chars[i] == '\u0000') {
                    s.append('\\');
                    s.append('0');
                    ++nullCharacterCount;
                    continue;
                }
                s.append(chars[i]);
            }
            tmp = s.toString();
            if (nullCharacterCount > 0) {
                message = message + "\nIdentified " + nullCharacterCount + " null characters ('\u0000') on parsed content. This may indicate the data is corrupt or its encoding is invalid. Parsed content:\n\t" + tmp;
            }
        }
        UserException.Builder builder = ex instanceof UserException ? ((UserException)ex).rebuild() : UserException.dataReadError(ex).message(message, new Object[0]);
        throw builder.addContext("Line", this.context.currentLine()).addContext("Record", this.context.currentRecord()).build(logger);
    }

    public void finishBatch() {
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

