/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.enumerable.plan;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.adapter.jdbc.JdbcConvention;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexNode;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillRelFactories;
import org.apache.drill.exec.store.enumerable.plan.DrillJdbcSort;
import org.apache.drill.exec.store.enumerable.plan.JdbcExpressionCheck;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheBuilder;
import org.apache.drill.shaded.guava.com.google.common.cache.CacheLoader;
import org.apache.drill.shaded.guava.com.google.common.cache.LoadingCache;

public abstract class DrillJdbcRuleBase
extends ConverterRule {
    protected final LoadingCache<RexNode, Boolean> checkedExpressions = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<RexNode, Boolean>(){

        @Override
        public Boolean load(RexNode expr) {
            return JdbcExpressionCheck.isOnlyStandardExpressions(expr);
        }
    });
    protected final JdbcConvention out;

    protected DrillJdbcRuleBase(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
        super((ConverterRule.Config)ConverterRule.Config.INSTANCE.withConversion(clazz, input -> true, in, (RelTrait)out, description).withRelBuilderFactory(DrillRelFactories.LOGICAL_BUILDER).as(ConverterRule.Config.class));
        this.out = out;
    }

    public static class DrillJdbcLimitRule
    extends DrillJdbcRuleBase {
        public DrillJdbcLimitRule(RelTrait in, JdbcConvention out) {
            super(DrillLimitRelBase.class, in, out, "DrillJdbcLimitRule");
        }

        public boolean matches(RelOptRuleCall call) {
            DrillLimitRelBase limit = (DrillLimitRelBase)call.rel(0);
            return !limit.isPushDown() && super.matches(call);
        }

        public RelNode convert(RelNode rel) {
            DrillLimitRelBase limit = (DrillLimitRelBase)rel;
            return new DrillJdbcSort(limit.getCluster(), limit.getTraitSet().plus((RelTrait)RelCollations.EMPTY).replace((RelTrait)this.out).simplify(), DrillJdbcLimitRule.convert((RelNode)limit.getInput(), (RelTraitSet)limit.getInput().getTraitSet().replace((RelTrait)this.out).simplify()), RelCollations.EMPTY, limit.getOffset(), limit.getFetch());
        }
    }

    public static class DrillJdbcSortRule
    extends DrillJdbcRuleBase {
        public DrillJdbcSortRule(RelTrait in, JdbcConvention out) {
            super(Sort.class, in, out, "DrillJdbcSortRule");
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            return new DrillJdbcSort(sort.getCluster(), sort.getTraitSet().replace((RelTrait)this.out), DrillJdbcSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)sort.getInput().getTraitSet().replace((RelTrait)this.out).simplify()), sort.collation, sort.offset, sort.fetch);
        }
    }

    public static class DrillJdbcFilterRule
    extends DrillJdbcRuleBase {
        public DrillJdbcFilterRule(RelTrait in, JdbcConvention out) {
            super(LogicalFilter.class, in, out, "DrillJdbcFilterRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            return new JdbcRules.JdbcFilter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.out), DrillJdbcFilterRule.convert((RelNode)filter.getInput(), (RelTraitSet)filter.getInput().getTraitSet().replace((RelTrait)this.out).simplify()), filter.getCondition());
        }

        public boolean matches(RelOptRuleCall call) {
            try {
                LogicalFilter filter = (LogicalFilter)call.rel(0);
                return (Boolean)this.checkedExpressions.get(filter.getCondition());
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failure while trying to evaluate push down.", e);
            }
        }
    }

    public static class DrillJdbcProjectRule
    extends DrillJdbcRuleBase {
        public DrillJdbcProjectRule(RelTrait in, JdbcConvention out) {
            super(LogicalProject.class, in, out, "DrillJdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            return new JdbcRules.JdbcProject(rel.getCluster(), rel.getTraitSet().replace((RelTrait)this.out), DrillJdbcProjectRule.convert((RelNode)project.getInput(), (RelTraitSet)project.getInput().getTraitSet().replace((RelTrait)this.out).simplify()), project.getProjects(), project.getRowType());
        }

        public boolean matches(RelOptRuleCall call) {
            try {
                LogicalProject project = (LogicalProject)call.rel(0);
                for (RexNode node : project.getProjects()) {
                    if (((Boolean)this.checkedExpressions.get(node)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failure while trying to evaluate pushdown.", e);
            }
        }
    }
}

