/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.drill.exec.expr.fn.impl.RegexpUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Joiner;
import org.apache.drill.shaded.guava.com.google.common.base.Strings;

@JsonTypeName(value="info-schema-filter")
public class InfoSchemaFilter {
    private final ExprNode exprRoot;

    @JsonCreator
    public InfoSchemaFilter(@JsonProperty(value="exprRoot") ExprNode exprRoot) {
        this.exprRoot = exprRoot;
    }

    @JsonProperty(value="exprRoot")
    public ExprNode getExprRoot() {
        return this.exprRoot;
    }

    @JsonIgnore
    public Result evaluate(Map<String, String> recordValues) {
        return this.evaluateHelper(recordValues, false, this.getExprRoot());
    }

    @JsonIgnore
    public Result evaluate(Map<String, String> recordValues, boolean prefixMatchesInconclusive) {
        return this.evaluateHelper(recordValues, prefixMatchesInconclusive, this.getExprRoot());
    }

    private Result evaluateHelper(Map<String, String> recordValues, boolean prefixMatchesInconclusive, ExprNode exprNode) {
        if (exprNode.type == ExprNode.Type.FUNCTION) {
            return this.evaluateHelperFunction(recordValues, prefixMatchesInconclusive, (FunctionExprNode)exprNode);
        }
        throw new UnsupportedOperationException(String.format("Unknown expression type '%s' in InfoSchemaFilter", new Object[]{exprNode.type}));
    }

    private Result evaluateHelperFunction(Map<String, String> recordValues, boolean prefixMatchesInconclusive, FunctionExprNode exprNode) {
        switch (exprNode.function) {
            case "like": {
                RegexpUtil.SqlPatternInfo spi;
                FieldExprNode col = (FieldExprNode)exprNode.args.get(0);
                ConstantExprNode pattern = (ConstantExprNode)exprNode.args.get(1);
                ConstantExprNode escape = exprNode.args.size() > 2 ? (ConstantExprNode)exprNode.args.get(2) : null;
                String fieldValue = recordValues.get(col.field);
                if (fieldValue == null) {
                    return Result.INCONCLUSIVE;
                }
                RegexpUtil.SqlPatternInfo sqlPatternInfo = spi = escape == null ? RegexpUtil.sqlToRegexLike(pattern.value) : RegexpUtil.sqlToRegexLike(pattern.value, escape.value);
                if (Pattern.matches(spi.getJavaPatternString(), fieldValue)) {
                    return Result.TRUE;
                }
                if (!prefixMatchesInconclusive) {
                    return Result.FALSE;
                }
                if (!(spi.getPatternType() != RegexpUtil.SqlPatternType.STARTS_WITH && spi.getPatternType() != RegexpUtil.SqlPatternType.CONSTANT || spi.getSimplePatternString().startsWith(fieldValue))) {
                    return Result.FALSE;
                }
                return Result.INCONCLUSIVE;
            }
            case "equal": 
            case "not equal": 
            case "notequal": 
            case "not_equal": {
                boolean exactMatch;
                FieldExprNode col = (FieldExprNode)exprNode.args.get(0);
                ConstantExprNode arg = (ConstantExprNode)exprNode.args.get(1);
                String value = recordValues.get(col.field);
                if (Strings.isNullOrEmpty(value)) {
                    return Result.INCONCLUSIVE;
                }
                boolean prefixMatch = arg.value.startsWith(value);
                boolean bl = exactMatch = prefixMatch && arg.value.equals(value);
                if (exprNode.function.equals("equal")) {
                    if (exactMatch) {
                        return Result.TRUE;
                    }
                    return prefixMatchesInconclusive && prefixMatch ? Result.INCONCLUSIVE : Result.FALSE;
                }
                if (exactMatch) {
                    return Result.FALSE;
                }
                return prefixMatchesInconclusive && prefixMatch ? Result.INCONCLUSIVE : Result.TRUE;
            }
            case "booleanOr": 
            case "booleanor": {
                Result result = Result.FALSE;
                for (ExprNode arg : exprNode.args) {
                    Result exprResult = this.evaluateHelper(recordValues, prefixMatchesInconclusive, arg);
                    if (exprResult == Result.TRUE) {
                        return Result.TRUE;
                    }
                    if (exprResult != Result.INCONCLUSIVE) continue;
                    result = Result.INCONCLUSIVE;
                }
                return result;
            }
            case "booleanAnd": 
            case "booleanand": {
                Result result = Result.TRUE;
                for (ExprNode arg : exprNode.args) {
                    Result exprResult = this.evaluateHelper(recordValues, prefixMatchesInconclusive, arg);
                    if (exprResult == Result.FALSE) {
                        return exprResult;
                    }
                    if (exprResult != Result.INCONCLUSIVE) continue;
                    result = Result.INCONCLUSIVE;
                }
                return result;
            }
            case "in": {
                FieldExprNode col = (FieldExprNode)exprNode.args.get(0);
                List<ExprNode> args = exprNode.args.subList(1, exprNode.args.size());
                String fieldValue = recordValues.get(col.field);
                if (fieldValue != null) {
                    for (ExprNode arg : args) {
                        if (!fieldValue.equals(((ConstantExprNode)arg).value)) continue;
                        return Result.TRUE;
                    }
                    return Result.FALSE;
                }
                return Result.INCONCLUSIVE;
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown function '%s' in InfoSchemaFilter", exprNode.function));
    }

    public String toString() {
        return this.exprRoot.toString();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    public static class ExprNode {
        @JsonProperty
        public Type type;

        public ExprNode(Type type) {
            this.type = type;
        }

        public static enum Type {
            FUNCTION,
            FIELD,
            CONSTANT;

        }
    }

    public static enum Result {
        TRUE,
        FALSE,
        INCONCLUSIVE;

    }

    public static class FunctionExprNode
    extends ExprNode {
        @JsonProperty
        public String function;
        @JsonProperty
        public List<ExprNode> args;

        @JsonCreator
        public FunctionExprNode(@JsonProperty(value="function") String function, @JsonProperty(value="args") List<ExprNode> args) {
            super(ExprNode.Type.FUNCTION);
            this.function = function;
            this.args = args;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.function);
            builder.append("(");
            builder.append(Joiner.on(",").join(this.args));
            builder.append(")");
            return builder.toString();
        }
    }

    public static class FieldExprNode
    extends ExprNode {
        @JsonProperty
        public String field;

        @JsonCreator
        public FieldExprNode(@JsonProperty(value="field") String field) {
            super(ExprNode.Type.FIELD);
            this.field = field;
        }

        public String toString() {
            return String.format("Field=%s", this.field);
        }
    }

    public static class ConstantExprNode
    extends ExprNode {
        @JsonProperty
        public String value;

        @JsonCreator
        public ConstantExprNode(@JsonProperty(value="value") String value) {
            super(ExprNode.Type.CONSTANT);
            this.value = value;
        }

        public String toString() {
            return String.format("Literal=%s", this.value);
        }
    }
}

