/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.ischema.InfoSchemaFilter;
import org.apache.drill.exec.store.ischema.InfoSchemaSubScan;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="info-schema")
public class InfoSchemaGroupScan
extends AbstractGroupScan {
    private final InfoSchemaTableType table;
    private final InfoSchemaFilter filter;

    public InfoSchemaGroupScan(InfoSchemaTableType table) {
        this(table, null);
    }

    @JsonCreator
    public InfoSchemaGroupScan(@JsonProperty(value="table") InfoSchemaTableType table, @JsonProperty(value="filter") InfoSchemaFilter filter) {
        super((String)null);
        this.table = table;
        this.filter = filter;
    }

    private InfoSchemaGroupScan(InfoSchemaGroupScan that) {
        super(that);
        this.table = that.table;
        this.filter = that.filter;
    }

    @JsonProperty(value="table")
    public InfoSchemaTableType getTable() {
        return this.table;
    }

    @JsonProperty(value="filter")
    public InfoSchemaFilter getSchemaFilter() {
        return this.filter;
    }

    @Override
    @JsonIgnore
    public List<SchemaPath> getColumns() {
        return super.getColumns();
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        Preconditions.checkArgument(endpoints.size() == 1);
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        Preconditions.checkArgument(minorFragmentId == 0);
        return new InfoSchemaSubScan(this.table, this.filter);
    }

    @Override
    public ScanStats getScanStats() {
        if (this.filter == null) {
            return ScanStats.TRIVIAL_TABLE;
        }
        return new ScanStats(ScanStats.GroupScanProperty.NO_EXACT_ROW_COUNT, 10.0, 1.0, 0.0);
    }

    @Override
    public int getMaxParallelizationWidth() {
        return 1;
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        return new InfoSchemaGroupScan(this);
    }

    @Override
    public String getDigest() {
        return this.table.toString() + ", filter=" + this.filter;
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        return new InfoSchemaGroupScan(this);
    }

    @JsonIgnore
    public boolean isFilterPushedDown() {
        return this.filter != null;
    }
}

