/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.DynamicRootSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.drill.exec.store.ischema.FilterEvaluator;
import org.apache.drill.exec.store.ischema.RecordCollector;
import org.apache.drill.exec.store.ischema.Records;
import org.apache.drill.exec.store.pojo.PojoRecordReader;

public abstract class InfoSchemaRecordGenerator<S> {
    protected List<S> records = new ArrayList<S>();
    private final FilterEvaluator filterEvaluator;
    private final List<RecordCollector> recordCollectors = new ArrayList<RecordCollector>();

    public InfoSchemaRecordGenerator(FilterEvaluator filterEvaluator) {
        this.filterEvaluator = filterEvaluator;
    }

    public void registerRecordCollector(RecordCollector recordCollector) {
        this.recordCollectors.add(recordCollector);
    }

    public void scanSchema(SchemaPlus root) {
        this.records = new ArrayList<S>();
        if (this.filterEvaluator.shouldVisitCatalog()) {
            this.scanSchema(root.getName(), root);
        }
    }

    protected void scanSchema(String schemaPath, SchemaPlus schema) {
        this.scanSchemaImpl(schemaPath, schema, new HashSet<String>());
    }

    private void scanSchemaImpl(String schemaPath, SchemaPlus schema, Set<String> visitedPaths) {
        if (schema == null) {
            return;
        }
        Set subSchemaNames = schema.getParentSchema() == null ? ((DynamicRootSchema)schema.unwrap(DynamicRootSchema.class)).schema.getSubSchemaNames() : schema.getSubSchemaNames();
        for (String name : subSchemaNames) {
            String subSchemaPath = schemaPath.isEmpty() ? name : schemaPath + "." + name;
            if (this.filterEvaluator.shouldPruneSchema(subSchemaPath)) continue;
            this.scanSchemaImpl(subSchemaPath, schema.getSubSchema(name), visitedPaths);
        }
        if (this.filterEvaluator.shouldVisitSchema(schemaPath, schema) && visitedPaths.add(schemaPath)) {
            this.visit(schemaPath, schema);
        }
    }

    protected final void visit(String schemaPath, SchemaPlus schema) {
        this.records.addAll(this.recordCollectors.parallelStream().map(recordCollector -> this.collect((RecordCollector)recordCollector, schemaPath, schema)).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public abstract PojoRecordReader<S> getRecordReader();

    protected abstract List<S> collect(RecordCollector var1, String var2, SchemaPlus var3);

    public static class Files
    extends InfoSchemaRecordGenerator<Records.File> {
        public Files(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.File> getRecordReader() {
            return new PojoRecordReader<Records.File>(Records.File.class, this.records);
        }

        @Override
        protected List<Records.File> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.files(schemaPath, schema);
        }
    }

    public static class Partitions
    extends InfoSchemaRecordGenerator<Records.Partition> {
        public Partitions(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.Partition> getRecordReader() {
            return new PojoRecordReader<Records.Partition>(Records.Partition.class, this.records);
        }

        @Override
        protected List<Records.Partition> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.partitions(schemaPath, schema);
        }
    }

    public static class Columns
    extends InfoSchemaRecordGenerator<Records.Column> {
        public Columns(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.Column> getRecordReader() {
            return new PojoRecordReader<Records.Column>(Records.Column.class, this.records);
        }

        @Override
        protected List<Records.Column> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.columns(schemaPath, schema);
        }
    }

    public static class Views
    extends InfoSchemaRecordGenerator<Records.View> {
        public Views(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.View> getRecordReader() {
            return new PojoRecordReader<Records.View>(Records.View.class, this.records);
        }

        @Override
        protected List<Records.View> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.views(schemaPath, schema);
        }
    }

    public static class Tables
    extends InfoSchemaRecordGenerator<Records.Table> {
        public Tables(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.Table> getRecordReader() {
            return new PojoRecordReader<Records.Table>(Records.Table.class, this.records);
        }

        @Override
        protected List<Records.Table> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.tables(schemaPath, schema);
        }
    }

    public static class Schemata
    extends InfoSchemaRecordGenerator<Records.Schema> {
        public Schemata(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.Schema> getRecordReader() {
            return new PojoRecordReader<Records.Schema>(Records.Schema.class, this.records);
        }

        @Override
        protected List<Records.Schema> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.schemas(schemaPath, schema);
        }
    }

    public static class Catalogs
    extends InfoSchemaRecordGenerator<Records.Catalog> {
        public Catalogs(FilterEvaluator filterEvaluator) {
            super(filterEvaluator);
        }

        @Override
        public PojoRecordReader<Records.Catalog> getRecordReader() {
            return new PojoRecordReader<Records.Catalog>(Records.Catalog.class, this.records);
        }

        @Override
        protected List<Records.Catalog> collect(RecordCollector recordCollector, String schemaPath, SchemaPlus schema) {
            return recordCollector.catalogs(schemaPath, schema);
        }

        @Override
        protected void scanSchema(String schemaPath, SchemaPlus schema) {
            this.visit(schemaPath, schema);
        }
    }
}

