/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.map.CaseInsensitiveMap;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.planner.PlannerPhase;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.AbstractStoragePlugin;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.SystemPlugin;
import org.apache.drill.exec.store.ischema.InfoSchemaConfig;
import org.apache.drill.exec.store.ischema.InfoSchemaDrillTable;
import org.apache.drill.exec.store.ischema.InfoSchemaGroupScan;
import org.apache.drill.exec.store.ischema.InfoSchemaPushFilterIntoRecordGenerator;
import org.apache.drill.exec.store.ischema.InfoSchemaTableType;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;

@SystemPlugin
public class InfoSchemaStoragePlugin
extends AbstractStoragePlugin {
    private final InfoSchemaConfig config;

    public InfoSchemaStoragePlugin(DrillbitContext context) {
        this(InfoSchemaConfig.INSTANCE, context, "information_schema");
    }

    public InfoSchemaStoragePlugin(InfoSchemaConfig config, DrillbitContext context, String name) {
        super(context, name);
        this.config = config;
    }

    @Override
    public boolean supportsRead() {
        return true;
    }

    @Override
    public InfoSchemaGroupScan getPhysicalScan(String userName, JSONOptions selection, List<SchemaPath> columns) {
        InfoSchemaTableType table = selection.getWith(this.getContext().getLpPersistence().getMapper(), InfoSchemaTableType.class);
        return new InfoSchemaGroupScan(table);
    }

    @Override
    public StoragePluginConfig getConfig() {
        return this.config;
    }

    @Override
    public void registerSchemas(SchemaConfig schemaConfig, SchemaPlus parent) {
        ISchema s = new ISchema(this);
        parent.add(s.getName(), (Schema)s);
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules(OptimizerRulesContext optimizerRulesContext, PlannerPhase phase) {
        switch (phase) {
            case PHYSICAL: {
                return ImmutableSet.of(InfoSchemaPushFilterIntoRecordGenerator.IS_FILTER_ON_PROJECT, InfoSchemaPushFilterIntoRecordGenerator.IS_FILTER_ON_SCAN);
            }
        }
        return ImmutableSet.of();
    }

    private class ISchema
    extends AbstractSchema {
        private final Map<String, InfoSchemaDrillTable> tables;
        private final Set<String> originalTableNames;

        ISchema(InfoSchemaStoragePlugin plugin) {
            super(Collections.emptyList(), "information_schema");
            this.tables = CaseInsensitiveMap.newHashMap();
            this.originalTableNames = new HashSet<String>();
            Arrays.stream(InfoSchemaTableType.values()).forEach(table -> {
                this.tables.put(table.name(), new InfoSchemaDrillTable(plugin, this.getName(), (InfoSchemaTableType)table, InfoSchemaStoragePlugin.this.config));
                this.originalTableNames.add(table.name());
            });
        }

        @Override
        public Table getTable(String name) {
            return this.tables.get(name);
        }

        @Override
        public Set<String> getTableNames() {
            return this.originalTableNames;
        }

        @Override
        public String getTypeName() {
            return "ischema";
        }

        @Override
        public boolean areTableNamesCaseSensitive() {
            return false;
        }
    }
}

