/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.ischema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.store.ischema.FilterEvaluator;
import org.apache.drill.exec.store.ischema.InfoSchemaRecordGenerator;
import org.apache.drill.exec.store.ischema.Records;

public abstract class InfoSchemaTable<S> {
    public static final TypeProtos.MajorType INT = Types.required(TypeProtos.MinorType.INT);
    public static final TypeProtos.MajorType BIGINT = Types.required(TypeProtos.MinorType.BIGINT);
    public static final TypeProtos.MajorType VARCHAR = Types.required(TypeProtos.MinorType.VARCHAR);
    public static final TypeProtos.MajorType BIT = Types.required(TypeProtos.MinorType.BIT);
    public static final TypeProtos.MajorType TIMESTAMP = Types.required(TypeProtos.MinorType.TIMESTAMP);
    public static final TypeProtos.MajorType FLOAT8 = Types.required(TypeProtos.MinorType.FLOAT8);
    private final List<Field> fields;

    public InfoSchemaTable(List<Field> fields) {
        this.fields = fields;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> relTypes = new ArrayList<RelDataType>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : this.fields) {
            relTypes.add(this.getRelDataType(typeFactory, field.getType()));
            fieldNames.add(field.getName());
        }
        return typeFactory.createStructType(relTypes, fieldNames);
    }

    private RelDataType getRelDataType(RelDataTypeFactory typeFactory, TypeProtos.MajorType type) {
        switch (type.getMinorType()) {
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case BIGINT: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case VARCHAR: {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE);
            }
            case BIT: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
            case FLOAT8: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
        }
        throw new UnsupportedOperationException("Only INT, BIGINT, VARCHAR, BOOLEAN, TIMESTAMP and DOUBLE types are supported in information_schema");
    }

    public abstract InfoSchemaRecordGenerator<S> getRecordGenerator(FilterEvaluator var1);

    public static class Field {
        private final String name;
        private final TypeProtos.MajorType type;

        private Field(String name, TypeProtos.MajorType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public TypeProtos.MajorType getType() {
            return this.type;
        }

        public static Field create(String name, TypeProtos.MajorType type) {
            return new Field(name, type);
        }
    }

    public static class Files
    extends InfoSchemaTable<Records.File> {
        private static final List<Field> fields = Arrays.asList(Field.create("SCHEMA_NAME", VARCHAR), Field.create("ROOT_SCHEMA_NAME", VARCHAR), Field.create("WORKSPACE_NAME", VARCHAR), Field.create("FILE_NAME", VARCHAR), Field.create("RELATIVE_PATH", VARCHAR), Field.create("IS_DIRECTORY", BIT), Field.create("IS_FILE", BIT), Field.create("LENGTH", BIGINT), Field.create("OWNER", VARCHAR), Field.create("GROUP", VARCHAR), Field.create("PERMISSION", VARCHAR), Field.create("ACCESS_TIME", TIMESTAMP), Field.create("MODIFICATION_TIME", TIMESTAMP));

        public Files() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.File> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Files(filterEvaluator);
        }
    }

    public static class Partitions
    extends InfoSchemaTable<Records.Partition> {
        private static final List<Field> fields = Arrays.asList(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("METADATA_KEY", VARCHAR), Field.create("METADATA_TYPE", VARCHAR), Field.create("METADATA_IDENTIFIER", VARCHAR), Field.create("PARTITION_COLUMN", VARCHAR), Field.create("PARTITION_VALUE", VARCHAR), Field.create("LOCATION", VARCHAR), Field.create("LAST_MODIFIED_TIME", TIMESTAMP));

        public Partitions() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.Partition> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Partitions(filterEvaluator);
        }
    }

    public static class Columns
    extends InfoSchemaTable<Records.Column> {
        private static final List<Field> fields = Arrays.asList(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("COLUMN_NAME", VARCHAR), Field.create("ORDINAL_POSITION", INT), Field.create("COLUMN_DEFAULT", VARCHAR), Field.create("IS_NULLABLE", VARCHAR), Field.create("DATA_TYPE", VARCHAR), Field.create("CHARACTER_MAXIMUM_LENGTH", INT), Field.create("CHARACTER_OCTET_LENGTH", INT), Field.create("NUMERIC_PRECISION", INT), Field.create("NUMERIC_PRECISION_RADIX", INT), Field.create("NUMERIC_SCALE", INT), Field.create("DATETIME_PRECISION", INT), Field.create("INTERVAL_TYPE", VARCHAR), Field.create("INTERVAL_PRECISION", INT), Field.create("COLUMN_SIZE", INT), Field.create("COLUMN_FORMAT", VARCHAR), Field.create("NUM_NULLS", BIGINT), Field.create("MIN_VAL", VARCHAR), Field.create("MAX_VAL", VARCHAR), Field.create("NDV", FLOAT8), Field.create("EST_NUM_NON_NULLS", FLOAT8), Field.create("IS_NESTED", BIT));

        public Columns() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.Column> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Columns(filterEvaluator);
        }
    }

    public static class Views
    extends InfoSchemaTable<Records.View> {
        private static final List<Field> fields = Arrays.asList(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("VIEW_DEFINITION", VARCHAR));

        public Views() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.View> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Views(filterEvaluator);
        }
    }

    public static class Tables
    extends InfoSchemaTable<Records.Table> {
        private static final List<Field> fields = Arrays.asList(Field.create("TABLE_CATALOG", VARCHAR), Field.create("TABLE_SCHEMA", VARCHAR), Field.create("TABLE_NAME", VARCHAR), Field.create("TABLE_TYPE", VARCHAR), Field.create("TABLE_SOURCE", VARCHAR), Field.create("LOCATION", VARCHAR), Field.create("NUM_ROWS", BIGINT), Field.create("LAST_MODIFIED_TIME", TIMESTAMP));

        public Tables() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.Table> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Tables(filterEvaluator);
        }
    }

    public static class Schemata
    extends InfoSchemaTable<Records.Schema> {
        private static final List<Field> fields = Arrays.asList(Field.create("CATALOG_NAME", VARCHAR), Field.create("SCHEMA_NAME", VARCHAR), Field.create("SCHEMA_OWNER", VARCHAR), Field.create("TYPE", VARCHAR), Field.create("IS_MUTABLE", VARCHAR));

        public Schemata() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.Schema> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Schemata(filterEvaluator);
        }
    }

    public static class Catalogs
    extends InfoSchemaTable<Records.Catalog> {
        private static final List<Field> fields = Arrays.asList(Field.create("CATALOG_NAME", VARCHAR), Field.create("CATALOG_DESCRIPTION", VARCHAR), Field.create("CATALOG_CONNECT", VARCHAR));

        public Catalogs() {
            super(fields);
        }

        @Override
        public InfoSchemaRecordGenerator<Records.Catalog> getRecordGenerator(FilterEvaluator filterEvaluator) {
            return new InfoSchemaRecordGenerator.Catalogs(filterEvaluator);
        }
    }
}

