/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.drill.exec.physical.impl.scan.framework.ManagedReader;
import org.apache.drill.exec.physical.impl.scan.framework.SchemaNegotiator;
import org.apache.drill.exec.physical.resultSet.ResultSetLoader;
import org.apache.drill.exec.physical.resultSet.RowSetLoader;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.store.mock.ColumnDef;
import org.apache.drill.exec.store.mock.MockTableDef;

public class ExtendedMockBatchReader
implements ManagedReader<SchemaNegotiator> {
    private final MockTableDef.MockScanEntry config;
    private final ColumnDef[] fields;
    private ResultSetLoader loader;
    private RowSetLoader writer;

    public ExtendedMockBatchReader(MockTableDef.MockScanEntry config) {
        this.config = config;
        this.fields = this.buildColumnDefs();
    }

    private ColumnDef[] buildColumnDefs() {
        ArrayList<ColumnDef> defs = new ArrayList<ColumnDef>();
        HashSet<String> names = new HashSet<String>();
        MockTableDef.MockColumn[] cols = this.config.getTypes();
        for (int i = 0; i < cols.length; ++i) {
            MockTableDef.MockColumn col = cols[i];
            if (names.contains(col.name)) {
                throw new IllegalArgumentException("Duplicate column name: " + col.name);
            }
            names.add(col.name);
            int repeat = Math.max(1, col.getRepeatCount());
            if (repeat == 1) {
                defs.add(new ColumnDef(col));
                continue;
            }
            for (int j = 0; j < repeat; ++j) {
                defs.add(new ColumnDef(col, j + 1));
            }
        }
        ColumnDef[] defArray = new ColumnDef[defs.size()];
        defs.toArray(defArray);
        return defArray;
    }

    @Override
    public boolean open(SchemaNegotiator schemaNegotiator) {
        TupleSchema schema = new TupleSchema();
        for (int i = 0; i < this.fields.length; ++i) {
            ColumnDef col = this.fields[i];
            MaterializedField field = MaterializedField.create(col.getName(), col.getConfig().getMajorType());
            schema.add(field);
        }
        schemaNegotiator.tableSchema(schema, true);
        int batchSize = this.config.getBatchSize();
        if (batchSize > 0) {
            schemaNegotiator.batchSize(batchSize);
        }
        schemaNegotiator.limit(this.config.getRecords());
        this.loader = schemaNegotiator.build();
        this.writer = this.loader.writer();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].generator.setup(this.fields[i], this.writer.scalar(i));
        }
        return true;
    }

    @Override
    public boolean next() {
        Random rand = new Random();
        while (!this.writer.isFull()) {
            this.writer.start();
            for (int j = 0; j < this.fields.length; ++j) {
                if (this.fields[j].nullable && rand.nextInt(100) < this.fields[j].nullablePercent) {
                    this.writer.scalar(j).setNull();
                    continue;
                }
                this.fields[j].generator.setValue();
            }
            this.writer.save();
        }
        return !this.loader.atLimit();
    }

    @Override
    public void close() {
    }
}

