/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.physical.base.AbstractGroupScan;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.ScanStats;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.mock.MockSubScanPOP;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="mock-scan")
public class MockGroupScanPOP
extends AbstractGroupScan {
    static final Logger logger = LoggerFactory.getLogger(MockGroupScanPOP.class);
    private final String url;
    protected final List<MockTableDef.MockScanEntry> readEntries;
    private LinkedList<MockTableDef.MockScanEntry>[] mappings;
    private boolean extended;
    private ScanStats scanStats = ScanStats.TRIVIAL_TABLE;

    @JsonCreator
    public MockGroupScanPOP(@JsonProperty(value="url") String url, @JsonProperty(value="entries") List<MockTableDef.MockScanEntry> readEntries) {
        super((String)null);
        this.readEntries = readEntries;
        this.url = url;
        double rowCount = 0.0;
        int rowWidth = 0;
        for (MockTableDef.MockScanEntry entry : readEntries) {
            rowCount += (double)entry.getRecords();
            int groupRowWidth = 0;
            if (entry.getTypes() == null) {
                groupRowWidth = 50;
            } else {
                for (MockTableDef.MockColumn col : entry.getTypes()) {
                    int colWidth = 0;
                    colWidth = col.getWidthValue() == 0 ? TypeHelper.getSize(col.getMajorType()) : col.getWidthValue();
                    groupRowWidth += (colWidth *= col.getRepeatCount());
                }
            }
            rowWidth = Math.max(rowWidth, groupRowWidth);
        }
        double dataSize = rowCount * (double)rowWidth;
        this.scanStats = new ScanStats(ScanStats.GroupScanProperty.EXACT_ROW_COUNT, rowCount, 1.0 * dataSize, 32.0 * dataSize);
    }

    @Override
    public ScanStats getScanStats() {
        return this.scanStats;
    }

    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="entries")
    public List<MockTableDef.MockScanEntry> getReadEntries() {
        return this.readEntries;
    }

    @Override
    public void applyAssignments(List<CoordinationProtos.DrillbitEndpoint> endpoints) {
        Preconditions.checkArgument(endpoints.size() <= this.getReadEntries().size());
        this.mappings = new LinkedList[endpoints.size()];
        int i = 0;
        for (MockTableDef.MockScanEntry e : this.getReadEntries()) {
            LinkedList<MockTableDef.MockScanEntry> entries;
            if (i == endpoints.size()) {
                i -= endpoints.size();
            }
            if ((entries = this.mappings[i]) == null) {
                this.mappings[i] = entries = new LinkedList();
            }
            entries.add(e);
            ++i;
        }
    }

    @Override
    public SubScan getSpecificScan(int minorFragmentId) {
        assert (minorFragmentId < this.mappings.length) : String.format("Mappings length [%d] should be longer than minor fragment id [%d] but it isn't.", this.mappings.length, minorFragmentId);
        return new MockSubScanPOP(this.url, this.extended, this.mappings[minorFragmentId]);
    }

    @Override
    public int getMaxParallelizationWidth() {
        return this.readEntries.size();
    }

    @Override
    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new MockGroupScanPOP(this.url, this.readEntries);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("No columns for mock scan");
        }
        ArrayList<MockTableDef.MockColumn> mockCols = new ArrayList<MockTableDef.MockColumn>();
        Pattern p = Pattern.compile("(\\w+)_([isdb])(\\d*)");
        for (SchemaPath path : columns) {
            TypeProtos.MinorType minorType;
            String col = path.getLastSegment().getNameSegment().getPath();
            if ("**".equals(col)) {
                return this;
            }
            Matcher m = p.matcher(col);
            if (!m.matches()) {
                throw new IllegalArgumentException("Badly formatted mock column name: " + col);
            }
            String name = m.group(1);
            String type = m.group(2);
            String length = m.group(3);
            int width = 10;
            if (!length.isEmpty()) {
                width = Integer.parseInt(length);
            }
            switch (type) {
                case "i": {
                    minorType = TypeProtos.MinorType.INT;
                    break;
                }
                case "s": {
                    minorType = TypeProtos.MinorType.VARCHAR;
                    break;
                }
                case "d": {
                    minorType = TypeProtos.MinorType.FLOAT8;
                    break;
                }
                case "b": {
                    minorType = TypeProtos.MinorType.BIT;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported field type " + type + " for mock column " + col);
                }
            }
            MockTableDef.MockColumn mockCol = new MockTableDef.MockColumn(col, minorType, TypeProtos.DataMode.REQUIRED, width, 0, 0, null, 1, null);
            mockCols.add(mockCol);
        }
        MockTableDef.MockScanEntry entry = this.readEntries.get(0);
        MockTableDef.MockColumn[] types = new MockTableDef.MockColumn[mockCols.size()];
        mockCols.toArray(types);
        MockTableDef.MockScanEntry newEntry = new MockTableDef.MockScanEntry(entry.records, true, 0, 1, types);
        ArrayList<MockTableDef.MockScanEntry> newEntries = new ArrayList<MockTableDef.MockScanEntry>();
        newEntries.add(newEntry);
        return new MockGroupScanPOP(this.url, newEntries);
    }

    @Override
    public String getDigest() {
        return this.toString();
    }

    public String toString() {
        return "MockGroupScanPOP [url=" + this.url + ", readEntries=" + this.readEntries + "]";
    }

    @Override
    @JsonIgnore
    public boolean canPushdownProjects(List<SchemaPath> columns) {
        return true;
    }
}

