/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.store.mock.MockTableDef;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

@JsonTypeName(value="mock-sub-scan")
public class MockSubScanPOP
extends AbstractBase
implements SubScan {
    public static final String OPERATOR_TYPE = "MOCK_SUB_SCAN";
    private final String url;
    protected final List<MockTableDef.MockScanEntry> readEntries;
    private final boolean extended;

    @JsonCreator
    public MockSubScanPOP(@JsonProperty(value="url") String url, @JsonProperty(value="extended") Boolean extended, @JsonProperty(value="entries") List<MockTableDef.MockScanEntry> readEntries) {
        this.readEntries = readEntries;
        this.url = url;
        this.extended = extended == null ? false : extended;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isExtended() {
        return this.extended;
    }

    @JsonProperty(value="entries")
    public List<MockTableDef.MockScanEntry> getReadEntries() {
        return this.readEntries;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSubScan(this, value);
    }

    @Override
    @JsonIgnore
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new MockSubScanPOP(this.url, this.extended, this.readEntries);
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }
}

