/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.planner.logical.DrillTableSelection;

@JsonTypeName(value="mock-table")
public class MockTableDef {
    private String descrip;
    MockTableSelection entries;

    public MockTableDef(@JsonProperty(value="descrip") String descrip, @JsonProperty(value="entries") MockTableSelection entries) {
        this.descrip = descrip;
        this.entries = entries;
    }

    public String getDescrip() {
        return this.descrip;
    }

    public MockTableSelection getEntries() {
        return this.entries;
    }

    public static class MockTableSelection
    implements DrillTableSelection {
        private final List<MockScanEntry> entries;

        @JsonCreator
        public MockTableSelection(@JsonProperty(value="entries") List<MockScanEntry> entries) {
            this.entries = entries;
        }

        @Override
        @JsonIgnore
        public String digest() {
            return this.entries.toString();
        }

        public List<MockScanEntry> getEntries() {
            return this.entries;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MockColumn {
        @JsonProperty(value="type")
        public TypeProtos.MinorType minorType;
        public String name;
        public TypeProtos.DataMode mode;
        public Integer width;
        public Integer precision;
        public Integer scale;
        public String generator;
        public Integer repeat;
        public Map<String, Object> properties;

        @JsonCreator
        public MockColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") TypeProtos.MinorType minorType, @JsonProperty(value="mode") TypeProtos.DataMode mode, @JsonProperty(value="width") Integer width, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="scale") Integer scale, @JsonProperty(value="generator") String generator, @JsonProperty(value="repeat") Integer repeat, @JsonProperty(value="properties") Map<String, Object> properties) {
            this.name = name;
            this.minorType = minorType;
            this.mode = mode;
            this.width = width;
            this.precision = precision;
            this.scale = scale;
            this.generator = generator;
            this.repeat = repeat;
            this.properties = properties;
        }

        @JsonProperty(value="type")
        public TypeProtos.MinorType getMinorType() {
            return this.minorType;
        }

        public String getName() {
            return this.name;
        }

        public TypeProtos.DataMode getMode() {
            return this.mode;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getPrecision() {
            return this.precision;
        }

        public Integer getScale() {
            return this.scale;
        }

        public String getGenerator() {
            return this.generator;
        }

        public Integer getRepeat() {
            return this.repeat;
        }

        @JsonIgnore
        public int getRepeatCount() {
            return this.repeat == null ? 1 : this.repeat;
        }

        @JsonIgnore
        public int getWidthValue() {
            return this.width == null ? 0 : this.width;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @JsonIgnore
        public TypeProtos.MajorType getMajorType() {
            TypeProtos.MajorType.Builder b = TypeProtos.MajorType.newBuilder();
            b.setMode(this.mode);
            b.setMinorType(this.minorType);
            if (this.precision != null) {
                b.setPrecision(this.precision);
            }
            if (this.width != null) {
                b.setPrecision(this.width);
            }
            if (this.scale != null) {
                b.setScale(this.scale);
            }
            return b.build();
        }

        public String toString() {
            return "MockColumn [minorType=" + this.minorType + ", name=" + this.name + ", mode=" + this.mode + "]";
        }
    }

    public static class MockScanEntry {
        final int records;
        final boolean extended;
        final int batchSize;
        final int repeat;
        private final MockColumn[] types;

        @JsonCreator
        public MockScanEntry(@JsonProperty(value="records") int records, @JsonProperty(value="extended") Boolean extended, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="repeat") Integer repeat, @JsonProperty(value="types") MockColumn[] types) {
            this.records = records;
            this.types = types;
            this.extended = extended == null ? false : extended;
            this.batchSize = batchSize == null ? 0 : batchSize;
            this.repeat = repeat == null ? 1 : repeat;
        }

        public int getRecords() {
            return this.records;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public int getBatchSize() {
            return this.batchSize;
        }

        public int getRepeat() {
            return this.repeat;
        }

        public MockColumn[] getTypes() {
            return this.types;
        }

        public String toString() {
            return "MockScanEntry [records=" + this.records + ", columns=" + Arrays.toString(this.types) + "]";
        }
    }
}

