/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.mock;

import java.util.Map;
import java.util.Random;
import org.apache.drill.exec.store.mock.AbstractFieldGen;
import org.apache.drill.exec.store.mock.ColumnDef;
import org.apache.drill.exec.vector.accessor.ScalarWriter;

public class VaryingStringGen
extends AbstractFieldGen {
    private Random rand = new Random();
    private int length;
    private int span;
    private int deltaPerSpan;
    private int valueCount;

    @Override
    public void setup(ColumnDef colDef, ScalarWriter colLoader) {
        super.setup(colDef, colLoader);
        this.length = colDef.width;
        Map<String, Object> props = colDef.mockCol.properties;
        this.span = 1000;
        this.deltaPerSpan = 100;
        if (props != null) {
            Integer value = (Integer)props.get("span");
            if (value != null) {
                this.span = Math.max(1, value);
            }
            if ((value = (Integer)props.get("delta")) != null) {
                this.deltaPerSpan = value;
            }
        }
    }

    public String value() {
        if (this.valueCount++ >= this.span) {
            this.valueCount = 0;
            this.length = Math.max(0, this.length + this.deltaPerSpan);
        }
        String c = Character.toString((char)(this.rand.nextInt(26) + 65));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public void setValue() {
        this.colWriter.setString(this.value());
    }
}

