/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public abstract class AbstractParquetRowGroupScan
extends AbstractBase
implements SubScan {
    protected final List<RowGroupReadEntry> rowGroupReadEntries;
    protected final List<SchemaPath> columns;
    protected final ParquetReaderConfig readerConfig;
    protected final LogicalExpression filter;
    protected final Path selectionRoot;
    protected final TupleMetadata schema;

    protected AbstractParquetRowGroupScan(String userName, List<RowGroupReadEntry> rowGroupReadEntries, List<SchemaPath> columns, ParquetReaderConfig readerConfig, LogicalExpression filter, Path selectionRoot, TupleMetadata schema) {
        super(userName);
        this.rowGroupReadEntries = rowGroupReadEntries;
        this.columns = columns == null ? GroupScan.ALL_COLUMNS : columns;
        this.readerConfig = readerConfig == null ? ParquetReaderConfig.getDefaultInstance() : readerConfig;
        this.filter = filter;
        this.selectionRoot = selectionRoot;
        this.schema = schema;
    }

    @JsonProperty
    public List<RowGroupReadEntry> getRowGroupReadEntries() {
        return this.rowGroupReadEntries;
    }

    @JsonProperty
    public List<SchemaPath> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="readerConfig")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ParquetReaderConfig getReaderConfigForSerialization() {
        return ParquetReaderConfig.getDefaultInstance().equals(this.readerConfig) ? null : this.readerConfig;
    }

    @JsonIgnore
    public ParquetReaderConfig getReaderConfig() {
        return this.readerConfig;
    }

    @JsonProperty
    public LogicalExpression getFilter() {
        return this.filter;
    }

    @Override
    public boolean isExecutable() {
        return false;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSubScan(this, value);
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Collections.emptyIterator();
    }

    @JsonProperty
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @JsonProperty
    public TupleMetadata getSchema() {
        return this.schema;
    }

    public boolean isImplicitColumn(SchemaPath path, String partitionColumnLabel) {
        return path.toString().matches(partitionColumnLabel + "\\d+");
    }

    public abstract AbstractParquetRowGroupScan copy(List<SchemaPath> var1);

    @JsonIgnore
    public abstract Configuration getFsConf(RowGroupReadEntry var1) throws IOException;

    public abstract boolean supportsFileImplicitColumns();

    @JsonIgnore
    public abstract List<String> getPartitionValues(RowGroupReadEntry var1);
}

