/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.FilterPredicate;
import org.apache.drill.exec.expr.stat.RowsMatch;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.CommonParquetRecordReader;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.FilterEvaluatorUtils;
import org.apache.drill.exec.store.parquet.ParquetDirectByteBufferAllocator;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.ParquetTableMetadataUtils;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.compression.DrillCompressionCodecFactory;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V4;
import org.apache.drill.exec.store.parquet2.DrillParquetReader;
import org.apache.drill.metastore.statistics.ColumnStatistics;
import org.apache.drill.metastore.util.SchemaPathUtils;
import org.apache.drill.shaded.guava.com.google.common.base.Functions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParquetScanBatchCreator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractParquetScanBatchCreator.class);

    /*
     * WARNING - void declaration
     */
    protected ScanBatch getBatch(ExecutorFragmentContext context, AbstractParquetRowGroupScan rowGroupScan, OperatorContext oContext) throws ExecutionSetupException {
        ColumnExplorer columnExplorer = new ColumnExplorer(context.getOptions(), rowGroupScan.getColumns());
        if (!columnExplorer.isStarQuery()) {
            rowGroupScan = rowGroupScan.copy(columnExplorer.getTableColumns());
            rowGroupScan.setOperatorId(rowGroupScan.getOperatorId());
        }
        AbstractDrillFileSystemManager fsManager = this.getDrillFileSystemCreator(oContext, context.getOptions());
        HashMap<Path, ParquetMetadata> footers = new HashMap<Path, ParquetMetadata>();
        LinkedList<CommonParquetRecordReader> readers = new LinkedList<CommonParquetRecordReader>();
        ArrayList<Map<String, String>> implicitColumns = new ArrayList<Map<String, String>>();
        Map<String, String> mapWithMaxColumns = new LinkedHashMap<String, String>();
        ParquetReaderConfig readerConfig = rowGroupScan.getReaderConfig();
        ReadEntryWithPath firstRowGroup = null;
        ParquetMetadata firstFooter = null;
        long rowGroupsPruned = 0L;
        try {
            LogicalExpression filterExpr = rowGroupScan.getFilter();
            boolean doRuntimePruning = filterExpr != null && (!(filterExpr instanceof ValueExpressions.BooleanExpression) || !((ValueExpressions.BooleanExpression)filterExpr).getBoolean());
            Object var17_18 = null;
            Metadata_V4.ParquetTableMetadata_v4 tableMetadataV4 = null;
            Metadata_V4.ParquetFileAndRowCountMetadata fileMetadataV4 = null;
            FilterPredicate<?> filterPredicate = null;
            Set<SchemaPath> schemaPathsInExpr = null;
            HashSet<SchemaPath> columnsInExpr = null;
            long totalPruneTime = 0L;
            long totalRowGroups = rowGroupScan.getRowGroupReadEntries().size();
            Stopwatch pruneTimer = Stopwatch.createUnstarted();
            if (doRuntimePruning) {
                filterPredicate = AbstractGroupScanWithMetadata.getFilterPredicate(filterExpr, context, context.getFunctionRegistry(), context.getOptions(), true, true, rowGroupScan.getSchema());
                schemaPathsInExpr = filterExpr.accept(FilterEvaluatorUtils.FieldReferenceFinder.INSTANCE, null);
                columnsInExpr = new HashSet<SchemaPath>();
                String partitionColumnLabel = context.getOptions().getOption((String)"drill.exec.storage.file.partition.column.label").string_val;
                for (SchemaPath path : schemaPathsInExpr) {
                    if (rowGroupScan.supportsFileImplicitColumns() && rowGroupScan.isImplicitColumn(path, partitionColumnLabel)) continue;
                    columnsInExpr.add(SchemaPath.getSimplePath(path.getRootSegmentPath()));
                }
                doRuntimePruning = !columnsInExpr.isEmpty();
            }
            for (RowGroupReadEntry rowGroup : rowGroupScan.getRowGroupReadEntries()) {
                ParquetMetadata footer;
                Stopwatch timer = logger.isTraceEnabled() ? Stopwatch.createUnstarted() : null;
                DrillFileSystem fs = fsManager.get(rowGroupScan.getFsConf(rowGroup), rowGroup.getPath());
                if (!footers.containsKey(rowGroup.getPath())) {
                    if (timer != null) {
                        timer.start();
                    }
                    footer = this.readFooter(fs.getConf(), rowGroup.getPath(), readerConfig);
                    if (timer != null) {
                        long timeToRead = timer.elapsed(TimeUnit.MICROSECONDS);
                        logger.trace("ParquetTrace,Read Footer,{},{},{},{},{},{},{}", new Object[]{"", rowGroup.getPath(), "", 0, 0, 0, timeToRead});
                    }
                    footers.put(rowGroup.getPath(), footer);
                }
                footer = (ParquetMetadata)footers.get(rowGroup.getPath());
                if (doRuntimePruning) {
                    pruneTimer.start();
                    RowsMatch matchResult = RowsMatch.ALL;
                    if (rowGroup.isEmpty()) {
                        matchResult = RowsMatch.NONE;
                    } else {
                        void var17_19;
                        int rowGroupIndex = rowGroup.getRowGroupIndex();
                        long footerRowCount = ((BlockMetaData)footer.getBlocks().get(rowGroupIndex)).getRowCount();
                        if (!rowGroup.getPath().equals((Object)var17_19)) {
                            tableMetadataV4 = new Metadata_V4.ParquetTableMetadata_v4();
                            FileStatus fileStatus = fs.getFileStatus(rowGroup.getPath());
                            fileMetadataV4 = Metadata.getParquetFileMetadata_v4(tableMetadataV4, footer, fileStatus, fs, false, true, columnsInExpr, readerConfig);
                            Path path = rowGroup.getPath();
                        }
                        MetadataBase.RowGroupMetadata rowGroupMetadata = fileMetadataV4.getFileMetadata().getRowGroups().get(rowGroup.getRowGroupIndex());
                        Map<SchemaPath, ColumnStatistics<?>> columnsStatistics = ParquetTableMetadataUtils.getRowGroupColumnStatistics(tableMetadataV4, rowGroupMetadata);
                        try {
                            Map<SchemaPath, TypeProtos.MajorType> intermediateColumns = ParquetTableMetadataUtils.getIntermediateFields(tableMetadataV4, rowGroupMetadata);
                            Map<SchemaPath, TypeProtos.MajorType> rowGroupFields = ParquetTableMetadataUtils.getRowGroupFields(tableMetadataV4, rowGroupMetadata);
                            TupleSchema rowGroupSchema = new TupleSchema();
                            rowGroupFields.forEach((schemaPath, majorType) -> SchemaPathUtils.addColumnMetadata(rowGroupSchema, schemaPath, majorType, intermediateColumns));
                            if (!rowGroupSchema.isEquivalent(rowGroupScan.getSchema())) {
                                filterPredicate = AbstractGroupScanWithMetadata.getFilterPredicate(filterExpr, context, context.getFunctionRegistry(), context.getOptions(), true, true, rowGroupSchema);
                            }
                            matchResult = FilterEvaluatorUtils.matches(filterPredicate, columnsStatistics, footerRowCount, rowGroupSchema, schemaPathsInExpr, context);
                            long timeToRead = pruneTimer.elapsed(TimeUnit.MICROSECONDS);
                            totalPruneTime += timeToRead;
                            logger.trace("Run-time pruning: {} row-group {} (RG index: {} row count: {}), took {} usec", new Object[]{matchResult == RowsMatch.NONE ? "Excluded" : "Included", rowGroup.getPath(), rowGroupIndex, footerRowCount, timeToRead});
                        }
                        catch (Exception e) {
                            logger.warn("Run-time pruning check failed - {}. Skip pruning rowgroup - {}", (Object)e.getMessage(), (Object)rowGroup.getPath());
                            logger.debug("Failure during run-time pruning: {}", (Object)e.getMessage(), (Object)e);
                        }
                    }
                    pruneTimer.stop();
                    pruneTimer.reset();
                    if (matchResult == RowsMatch.NONE) {
                        ++rowGroupsPruned;
                        if (firstRowGroup != null) continue;
                        firstRowGroup = rowGroup;
                        firstFooter = footer;
                        continue;
                    }
                }
                mapWithMaxColumns = this.createReaderAndImplicitColumns(context, rowGroupScan, oContext, columnExplorer, readers, implicitColumns, mapWithMaxColumns, rowGroup, fs, footer, false);
            }
            if (readers.isEmpty() && firstRowGroup != null) {
                DrillFileSystem fs = fsManager.get(rowGroupScan.getFsConf((RowGroupReadEntry)firstRowGroup), firstRowGroup.getPath());
                mapWithMaxColumns = this.createReaderAndImplicitColumns(context, rowGroupScan, oContext, columnExplorer, readers, implicitColumns, mapWithMaxColumns, (RowGroupReadEntry)firstRowGroup, fs, firstFooter, true);
            }
            if (totalPruneTime > 0L) {
                logger.info("Finished parquet_runtime_pruning in {} usec. Out of given {} rowgroups, {} were pruned. {}", new Object[]{totalPruneTime, totalRowGroups, rowGroupsPruned, totalRowGroups == rowGroupsPruned ? "ALL_PRUNED !!" : ""});
            }
            for (CommonParquetRecordReader rr : readers) {
                rr.updateRowGroupsStats(totalRowGroups, rowGroupsPruned);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionSetupException(e);
        }
        Map diff = Maps.transformValues(mapWithMaxColumns, Functions.constant(null));
        for (Map map : implicitColumns) {
            map.putAll(Maps.difference(map, diff).entriesOnlyOnRight());
        }
        return new ScanBatch(context, oContext, readers, implicitColumns);
    }

    private Map<String, String> createReaderAndImplicitColumns(ExecutorFragmentContext context, AbstractParquetRowGroupScan rowGroupScan, OperatorContext oContext, ColumnExplorer columnExplorer, List<CommonParquetRecordReader> readers, List<Map<String, String>> implicitColumns, Map<String, String> mapWithMaxColumns, RowGroupReadEntry rowGroup, DrillFileSystem fs, ParquetMetadata footer, boolean readSchemaOnly) {
        CommonParquetRecordReader reader;
        long recordsToRead;
        ParquetReaderConfig readerConfig = rowGroupScan.getReaderConfig();
        ParquetReaderUtility.DateCorruptionStatus containsCorruptDates = ParquetReaderUtility.detectCorruptDates(footer, rowGroupScan.getColumns(), readerConfig.autoCorrectCorruptedDates());
        logger.debug("Contains corrupt dates: {}.", (Object)containsCorruptDates);
        boolean useNewReader = context.getOptions().getBoolean("store.parquet.use_new_reader");
        boolean containsComplexColumn = ParquetReaderUtility.containsComplexColumn(footer, rowGroupScan.getColumns());
        logger.debug("PARQUET_NEW_RECORD_READER is {}. Complex columns {}.", (Object)(useNewReader ? "enabled" : "disabled"), (Object)(containsComplexColumn ? "found." : "not found."));
        long l = recordsToRead = readSchemaOnly ? 0L : rowGroup.getNumRecordsToRead();
        if (useNewReader || containsComplexColumn) {
            reader = new DrillParquetReader(context, footer, rowGroup, columnExplorer.getTableColumns(), fs, containsCorruptDates, recordsToRead);
        } else {
            CompressionCodecFactory ccf = DrillCompressionCodecFactory.createDirectCodecFactory(fs.getConf(), new ParquetDirectByteBufferAllocator(oContext.getAllocator()), 0);
            reader = new ParquetRecordReader((FragmentContext)context, rowGroup.getPath(), rowGroup.getRowGroupIndex(), recordsToRead, (FileSystem)fs, ccf, footer, rowGroupScan.getColumns(), containsCorruptDates);
        }
        logger.debug("Query {} uses {}", (Object)QueryIdHelper.getQueryId(oContext.getFragmentContext().getHandle().getQueryId()), (Object)reader.getClass().getSimpleName());
        readers.add(reader);
        Map<String, String> implicitValues = this.getImplicitValues(rowGroupScan, columnExplorer, rowGroup, fs);
        implicitColumns.add(implicitValues);
        if (implicitValues.size() > mapWithMaxColumns.size()) {
            mapWithMaxColumns = implicitValues;
        }
        return mapWithMaxColumns;
    }

    protected Map<String, String> getImplicitValues(AbstractParquetRowGroupScan rowGroupScan, ColumnExplorer columnExplorer, RowGroupReadEntry rowGroup, DrillFileSystem fs) {
        List<String> partitionValues = rowGroupScan.getPartitionValues(rowGroup);
        return columnExplorer.populateColumns(rowGroup.getPath(), partitionValues, rowGroupScan.supportsFileImplicitColumns(), fs, rowGroup.getRowGroupIndex(), rowGroup.getStart(), rowGroup.getLength());
    }

    protected abstract AbstractDrillFileSystemManager getDrillFileSystemCreator(OperatorContext var1, OptionManager var2);

    private ParquetMetadata readFooter(Configuration conf, Path path, ParquetReaderConfig readerConfig) throws IOException {
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)readerConfig.addCountersToConf(conf)), (ParquetReadOptions)readerConfig.toReadOptions());){
            ParquetMetadata parquetMetadata = reader.getFooter();
            return parquetMetadata;
        }
    }

    protected static abstract class AbstractDrillFileSystemManager {
        protected final OperatorContext operatorContext;

        protected AbstractDrillFileSystemManager(OperatorContext operatorContext) {
            this.operatorContext = operatorContext;
        }

        protected abstract DrillFileSystem get(Configuration var1, Path var2) throws ExecutionSetupException;
    }
}

