/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnDataReader {
    static final Logger logger = LoggerFactory.getLogger(ColumnDataReader.class);
    private final long endPosition;
    public final FSDataInputStream input;

    public ColumnDataReader(FSDataInputStream input, long start, long length) throws IOException {
        this.input = input;
        this.input.seek(start);
        this.endPosition = start + length;
    }

    public PageHeader readPageHeader() throws IOException {
        return Util.readPageHeader((InputStream)this.input);
    }

    public FSDataInputStream getInputStream() {
        return this.input;
    }

    public BytesInput getPageAsBytesInput(int pageLength) throws IOException {
        byte[] b = new byte[pageLength];
        this.input.read(b);
        return new HadoopBytesInput(b);
    }

    public void loadPage(DrillBuf target, int pageLength) throws IOException {
        target.clear();
        HadoopStreams.wrap((FSDataInputStream)this.input).read(target.nioBuffer(0, pageLength));
        target.writerIndex(pageLength);
    }

    public void clear() {
        try {
            this.input.close();
        }
        catch (IOException ex) {
            logger.warn("Error while closing input stream.", (Throwable)ex);
        }
    }

    public boolean hasRemainder() throws IOException {
        return this.input.getPos() < this.endPosition;
    }

    public class HadoopBytesInput
    extends BytesInput {
        private final byte[] pageBytes;

        public HadoopBytesInput(byte[] pageBytes) {
            this.pageBytes = pageBytes;
        }

        public byte[] toByteArray() throws IOException {
            return this.pageBytes;
        }

        public long size() {
            return this.pageBytes.length;
        }

        public void writeAllTo(OutputStream out) throws IOException {
            out.write(this.pageBytes);
        }
    }
}

