/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.exec.expr.FilterPredicate;
import org.apache.drill.exec.ops.OptimizerRulesContext;
import org.apache.drill.exec.physical.base.AbstractGroupScanWithMetadata;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.FilterPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilePushDownFilter
extends StoragePluginOptimizerRule {
    private static final Logger logger = LoggerFactory.getLogger(FilePushDownFilter.class);
    private static final Collection<String> BANNED_OPERATORS = new ArrayList<String>(1);
    protected final OptimizerRulesContext optimizerContext;

    public static RelOptRule getFilterOnProject(OptimizerRulesContext optimizerRulesContext) {
        return new FilePushDownFilter(RelOptHelper.some(FilterPrel.class, RelOptHelper.some(ProjectPrel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "FilePushDownFilter:Filter_On_Project", optimizerRulesContext){

            public boolean matches(RelOptRuleCall call) {
                ScanPrel scan = (ScanPrel)call.rel(2);
                if (scan.getGroupScan().supportsFilterPushDown()) {
                    return super.matches(call);
                }
                return false;
            }

            public void onMatch(RelOptRuleCall call) {
                FilterPrel filterRel = (FilterPrel)call.rel(0);
                ProjectPrel projectRel = (ProjectPrel)call.rel(1);
                ScanPrel scanRel = (ScanPrel)call.rel(2);
                this.doOnMatch(call, filterRel, projectRel, scanRel);
            }
        };
    }

    public static StoragePluginOptimizerRule getFilterOnScan(OptimizerRulesContext optimizerContext) {
        return new FilePushDownFilter(RelOptHelper.some(FilterPrel.class, RelOptHelper.any(ScanPrel.class), new RelOptRuleOperand[0]), "FilePushDownFilter:Filter_On_Scan", optimizerContext){

            public boolean matches(RelOptRuleCall call) {
                ScanPrel scan = (ScanPrel)call.rel(1);
                if (scan.getGroupScan().supportsFilterPushDown()) {
                    return super.matches(call);
                }
                return false;
            }

            public void onMatch(RelOptRuleCall call) {
                FilterPrel filterRel = (FilterPrel)call.rel(0);
                ScanPrel scanRel = (ScanPrel)call.rel(1);
                this.doOnMatch(call, filterRel, null, scanRel);
            }
        };
    }

    private FilePushDownFilter(RelOptRuleOperand operand, String id, OptimizerRulesContext optimizerContext) {
        super(operand, id);
        this.optimizerContext = optimizerContext;
    }

    protected void doOnMatch(RelOptRuleCall call, FilterPrel filter, ProjectPrel project, ScanPrel scan) {
        AbstractGroupScanWithMetadata groupScan = (AbstractGroupScanWithMetadata)scan.getGroupScan();
        if (groupScan.getFilter() != null && !groupScan.getFilter().equals(ValueExpressions.BooleanExpression.TRUE)) {
            return;
        }
        RexNode condition = project == null ? filter.getCondition() : RelOptUtil.pushPastProject((RexNode)filter.getCondition(), (Project)project);
        if (condition == null || condition.isAlwaysTrue()) {
            return;
        }
        List predList = RelOptUtil.conjunctions((RexNode)RexUtil.toCnf((RexBuilder)filter.getCluster().getRexBuilder(), (int)100, (RexNode)condition));
        ArrayList<RexNode> qualifiedPredList = new ArrayList<RexNode>();
        ArrayList<RexNode> nonConvertedPredList = new ArrayList<RexNode>();
        for (RexNode pred : predList) {
            if (DrillRelOptUtil.findOperators(pred, Collections.emptyList(), BANNED_OPERATORS) == null) {
                LogicalExpression drillPredicate = DrillOptiq.toDrill(new DrillParseContext(PrelUtil.getPlannerSettings(call.getPlanner())), scan, pred);
                FilterPredicate<?> filterPredicate = groupScan.getFilterPredicate(drillPredicate, this.optimizerContext, this.optimizerContext.getFunctionRegistry(), this.optimizerContext.getPlannerSettings().getOptions(), false);
                if (filterPredicate == null) {
                    nonConvertedPredList.add(pred);
                }
                qualifiedPredList.add(pred);
                continue;
            }
            nonConvertedPredList.add(pred);
        }
        RexNode qualifiedPred = RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), qualifiedPredList, (boolean)true);
        if (qualifiedPred == null) {
            return;
        }
        LogicalExpression conditionExp = DrillOptiq.toDrill(new DrillParseContext(PrelUtil.getPlannerSettings(call.getPlanner())), scan, qualifiedPred);
        groupScan.setFilterForRuntime(conditionExp, this.optimizerContext);
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        GroupScan newGroupScan = groupScan.applyFilter(conditionExp, this.optimizerContext, this.optimizerContext.getFunctionRegistry(), this.optimizerContext.getPlannerSettings().getOptions());
        if (timer != null) {
            logger.debug("Took {} ms to apply filter. ", (Object)timer.elapsed(TimeUnit.MILLISECONDS));
            timer.stop();
        }
        if (newGroupScan == null) {
            if (groupScan.isMatchAllMetadata()) {
                Prel child;
                Prel prel = child = project == null ? scan : project;
                if (nonConvertedPredList.isEmpty()) {
                    groupScan.setFilterForRuntime(null, this.optimizerContext);
                    call.transformTo((RelNode)child);
                } else {
                    if (nonConvertedPredList.size() == predList.size()) {
                        return;
                    }
                    Filter theNewFilter = filter.copy(filter.getTraitSet(), child, RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), nonConvertedPredList, (boolean)true));
                    LogicalExpression filterPredicate = DrillOptiq.toDrill(new DrillParseContext(PrelUtil.getPlannerSettings(call.getPlanner())), scan, theNewFilter.getCondition());
                    groupScan.setFilterForRuntime(filterPredicate, this.optimizerContext);
                    call.transformTo((RelNode)theNewFilter);
                }
            }
            return;
        }
        ScanPrel newNode = new ScanPrel(scan.getCluster(), scan.getTraitSet(), newGroupScan, scan.getRowType(), scan.getTable());
        if (project != null) {
            newNode = project.copy(project.getTraitSet(), Collections.singletonList(newNode));
        }
        if (((AbstractGroupScanWithMetadata)newGroupScan).isMatchAllMetadata()) {
            if (!nonConvertedPredList.isEmpty()) {
                Filter theFilterRel = filter.copy(filter.getTraitSet(), newNode, RexUtil.composeConjunction((RexBuilder)filter.getCluster().getRexBuilder(), nonConvertedPredList, (boolean)true));
                LogicalExpression filterPredicate = DrillOptiq.toDrill(new DrillParseContext(PrelUtil.getPlannerSettings(call.getPlanner())), scan, theFilterRel.getCondition());
                ((AbstractGroupScanWithMetadata)newGroupScan).setFilterForRuntime(filterPredicate, this.optimizerContext);
                newNode = theFilterRel;
            }
            call.transformTo((RelNode)newNode);
            return;
        }
        RelNode newFilter = filter.copy(filter.getTraitSet(), Collections.singletonList(newNode));
        call.transformTo(newFilter);
    }

    static {
        BANNED_OPERATORS.add("flatten");
    }
}

