/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.drill.common.PlanStringBuilder;
import org.apache.drill.common.logical.FormatPluginConfig;

@JsonTypeName(value="parquet")
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ParquetFormatConfig
implements FormatPluginConfig {
    private final boolean autoCorrectCorruptDates;
    private final boolean enableStringsSignedMinMax;
    private final Integer blockSize;
    private final Integer pageSize;
    private final Boolean useSingleFSBlock;
    private final String writerCompressionType;
    private final String writerLogicalTypeForDecimals;
    private final Boolean writerUsePrimitivesForDecimals;
    private final String writerFormatVersion;

    public ParquetFormatConfig() {
        this(true, false, null, null, null, null, null, null, null);
    }

    @JsonCreator
    public ParquetFormatConfig(@JsonProperty(value="autoCorrectCorruptDates") Boolean autoCorrectCorruptDates, @JsonProperty(value="enableStringsSignedMinMax") boolean enableStringsSignedMinMax, @JsonProperty(value="blockSize") Integer blockSize, @JsonProperty(value="pageSize") Integer pageSize, @JsonProperty(value="useSingleFSBlock") Boolean useSingleFSBlock, @JsonProperty(value="writerCompressionType") String writerCompressionType, @JsonProperty(value="writerLogicalTypeForDecimals") String writerLogicalTypeForDecimals, @JsonProperty(value="writerUsePrimitivesForDecimals") Boolean writerUsePrimitivesForDecimals, @JsonProperty(value="writerFormatVersion") String writerFormatVersion) {
        this.autoCorrectCorruptDates = autoCorrectCorruptDates == null ? true : autoCorrectCorruptDates;
        this.enableStringsSignedMinMax = enableStringsSignedMinMax;
        this.blockSize = blockSize;
        this.pageSize = pageSize;
        this.useSingleFSBlock = useSingleFSBlock;
        this.writerCompressionType = writerCompressionType;
        this.writerLogicalTypeForDecimals = writerLogicalTypeForDecimals;
        this.writerUsePrimitivesForDecimals = writerUsePrimitivesForDecimals;
        this.writerFormatVersion = writerFormatVersion;
    }

    public static ParquetFormatConfigBuilder builder() {
        return new ParquetFormatConfigBuilder();
    }

    public String toString() {
        return new PlanStringBuilder(this).field("autoCorrectCorruptDates", this.autoCorrectCorruptDates).field("enableStringsSignedMinMax", this.enableStringsSignedMinMax).field("blockSize", this.blockSize).field("pageSize", this.pageSize).field("useSingleFSBlock", this.useSingleFSBlock).field("writerCompressionType", this.writerCompressionType).field("writerLogicalTypeForDecimals", this.writerLogicalTypeForDecimals).field("writerUsePrimitivesForDecimals", this.writerUsePrimitivesForDecimals).field("writerFormatVersion", this.writerFormatVersion).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParquetFormatConfig that = (ParquetFormatConfig)o;
        return this.autoCorrectCorruptDates == that.autoCorrectCorruptDates && this.enableStringsSignedMinMax == that.enableStringsSignedMinMax && Objects.equals(this.blockSize, that.blockSize) && Objects.equals(this.pageSize, that.pageSize) && Objects.equals(this.useSingleFSBlock, that.useSingleFSBlock) && Objects.equals(this.writerCompressionType, that.writerCompressionType) && Objects.equals(this.writerLogicalTypeForDecimals, that.writerLogicalTypeForDecimals) && Objects.equals(this.writerUsePrimitivesForDecimals, that.writerUsePrimitivesForDecimals) && Objects.equals(this.writerFormatVersion, that.writerFormatVersion);
    }

    public int hashCode() {
        return Objects.hash(this.autoCorrectCorruptDates, this.enableStringsSignedMinMax, this.blockSize, this.pageSize, this.useSingleFSBlock, this.writerCompressionType, this.writerLogicalTypeForDecimals, this.writerUsePrimitivesForDecimals, this.writerFormatVersion);
    }

    public boolean isAutoCorrectCorruptDates() {
        return this.autoCorrectCorruptDates;
    }

    public boolean isEnableStringsSignedMinMax() {
        return this.enableStringsSignedMinMax;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Boolean getUseSingleFSBlock() {
        return this.useSingleFSBlock;
    }

    public String getWriterCompressionType() {
        return this.writerCompressionType;
    }

    public String getWriterLogicalTypeForDecimals() {
        return this.writerLogicalTypeForDecimals;
    }

    public Boolean getWriterUsePrimitivesForDecimals() {
        return this.writerUsePrimitivesForDecimals;
    }

    public String getWriterFormatVersion() {
        return this.writerFormatVersion;
    }

    public static class ParquetFormatConfigBuilder {
        private Boolean autoCorrectCorruptDates;
        private boolean enableStringsSignedMinMax;
        private Integer blockSize;
        private Integer pageSize;
        private Boolean useSingleFSBlock;
        private String writerCompressionType;
        private String writerLogicalTypeForDecimals;
        private Boolean writerUsePrimitivesForDecimals;
        private String writerFormatVersion;

        public ParquetFormatConfigBuilder autoCorrectCorruptDates(Boolean autoCorrectCorruptDates) {
            this.autoCorrectCorruptDates = autoCorrectCorruptDates;
            return this;
        }

        public ParquetFormatConfigBuilder enableStringsSignedMinMax(boolean enableStringsSignedMinMax) {
            this.enableStringsSignedMinMax = enableStringsSignedMinMax;
            return this;
        }

        public ParquetFormatConfigBuilder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public ParquetFormatConfigBuilder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ParquetFormatConfigBuilder useSingleFSBlock(Boolean useSingleFSBlock) {
            this.useSingleFSBlock = useSingleFSBlock;
            return this;
        }

        public ParquetFormatConfigBuilder writerCompressionType(String writerCompressionType) {
            this.writerCompressionType = writerCompressionType;
            return this;
        }

        public ParquetFormatConfigBuilder writerLogicalTypeForDecimals(String writerLogicalTypeForDecimals) {
            this.writerLogicalTypeForDecimals = writerLogicalTypeForDecimals;
            return this;
        }

        public ParquetFormatConfigBuilder writerUsePrimitivesForDecimals(Boolean writerUsePrimitivesForDecimals) {
            this.writerUsePrimitivesForDecimals = writerUsePrimitivesForDecimals;
            return this;
        }

        public ParquetFormatConfigBuilder writerFormatVersion(String writerFormatVersion) {
            this.writerFormatVersion = writerFormatVersion;
            return this;
        }

        public ParquetFormatConfig build() {
            return new ParquetFormatConfig(this.autoCorrectCorruptDates, this.enableStringsSignedMinMax, this.blockSize, this.pageSize, this.useSingleFSBlock, this.writerCompressionType, this.writerLogicalTypeForDecimals, this.writerUsePrimitivesForDecimals, this.writerFormatVersion);
        }
    }
}

