/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractFileGroupScan;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.SchemalessScan;
import org.apache.drill.exec.physical.impl.WriterRecordBatch;
import org.apache.drill.exec.planner.common.DrillStatsTable;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.apache.drill.exec.planner.logical.DrillTableSelection;
import org.apache.drill.exec.planner.logical.DynamicDrillTable;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.RecordWriter;
import org.apache.drill.exec.store.SchemaConfig;
import org.apache.drill.exec.store.StoragePluginOptimizerRule;
import org.apache.drill.exec.store.dfs.BasicFormatMatcher;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.FileSystemPlugin;
import org.apache.drill.exec.store.dfs.FormatMatcher;
import org.apache.drill.exec.store.dfs.FormatPlugin;
import org.apache.drill.exec.store.dfs.FormatSelection;
import org.apache.drill.exec.store.dfs.MagicString;
import org.apache.drill.exec.store.dfs.MetadataContext;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetGroupScan;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.ParquetRecordWriter;
import org.apache.drill.exec.store.parquet.ParquetWriter;
import org.apache.drill.exec.store.parquet.metadata.Metadata;
import org.apache.drill.exec.store.parquet.metadata.ParquetTableMetadataDirs;
import org.apache.drill.exec.util.DrillFileSystemUtil;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFormatPlugin
implements FormatPlugin {
    public static final String[] PARQUET_FORMAT_VERSIONS = new String[]{"v1", "v2"};
    private static final Logger logger = LoggerFactory.getLogger(ParquetFormatPlugin.class);
    public static final ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private static final String DEFAULT_NAME = "parquet";
    private static final List<Pattern> PATTERNS = Arrays.asList(Pattern.compile(".*\\.parquet$"), Pattern.compile(".*/_metadata"));
    private static final List<MagicString> MAGIC_STRINGS = Collections.singletonList(new MagicString(0L, ParquetFileWriter.MAGIC));
    private final DrillbitContext context;
    private final Configuration fsConf;
    private final ParquetFormatMatcher formatMatcher;
    private final ParquetFormatConfig config;
    private final StoragePluginConfig storageConfig;
    private final String name;

    public ParquetFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig) {
        this(name, context, fsConf, storageConfig, new ParquetFormatConfig());
    }

    public ParquetFormatPlugin(String name, DrillbitContext context, Configuration fsConf, StoragePluginConfig storageConfig, ParquetFormatConfig formatConfig) {
        this.context = context;
        this.config = formatConfig;
        this.formatMatcher = new ParquetFormatMatcher(this, this.config);
        this.storageConfig = storageConfig;
        this.fsConf = fsConf;
        this.name = name == null ? DEFAULT_NAME : name;
    }

    @Override
    public Configuration getFsConf() {
        return this.fsConf;
    }

    @Override
    public ParquetFormatConfig getConfig() {
        return this.config;
    }

    @Override
    public DrillbitContext getContext() {
        return this.context;
    }

    @Override
    public boolean supportsRead() {
        return true;
    }

    public Set<StoragePluginOptimizerRule> getOptimizerRules() {
        return ImmutableSet.of();
    }

    @Override
    public AbstractWriter getWriter(PhysicalOperator child, String location, List<String> partitionColumns) throws IOException {
        return new ParquetWriter(child, location, partitionColumns, this);
    }

    public RecordWriter getRecordWriter(FragmentContext context, ParquetWriter writer) throws IOException, OutOfMemoryException {
        HashMap<String, String> writerOpts = new HashMap<String, String>();
        OptionManager contextOpts = context.getOptions();
        writerOpts.put("location", writer.getLocation());
        ExecProtos.FragmentHandle handle = context.getHandle();
        String fragmentId = String.format("%d_%d", handle.getMajorFragmentId(), handle.getMinorFragmentId());
        writerOpts.put("prefix", fragmentId);
        OptionValue.OptionScope minScope = OptionValue.OptionScope.SESSION;
        writerOpts.put("store.parquet.block-size", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.block-size").getValueMinScope(minScope), this.config.getBlockSize(), contextOpts.getInt("store.parquet.block-size")}).toString());
        writerOpts.put("store.parquet.writer.use_single_fs_block", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.writer.use_single_fs_block").getValueMinScope(minScope), this.config.getUseSingleFSBlock(), contextOpts.getBoolean("store.parquet.writer.use_single_fs_block")}).toString());
        writerOpts.put("store.parquet.page-size", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.page-size").getValueMinScope(minScope), this.config.getPageSize(), contextOpts.getInt("store.parquet.page-size")}).toString());
        writerOpts.put("store.parquet.dictionary.page-size", contextOpts.getOption((String)"store.parquet.dictionary.page-size").num_val.toString());
        writerOpts.put("store.parquet.enable_dictionary_encoding", contextOpts.getOption((String)"store.parquet.enable_dictionary_encoding").bool_val.toString());
        writerOpts.put("store.parquet.compression", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.compression").getValueMinScope(minScope), this.config.getWriterCompressionType(), contextOpts.getString("store.parquet.compression")}).toString());
        writerOpts.put("store.parquet.writer.logical_type_for_decimals", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.writer.logical_type_for_decimals").getValueMinScope(minScope), this.config.getWriterLogicalTypeForDecimals(), contextOpts.getString("store.parquet.writer.logical_type_for_decimals")}).toString());
        writerOpts.put("store.parquet.writer.use_primitive_types_for_decimals", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.writer.use_primitive_types_for_decimals").getValueMinScope(minScope), this.config.getWriterUsePrimitivesForDecimals(), contextOpts.getBoolean("store.parquet.writer.use_primitive_types_for_decimals")}).toString());
        writerOpts.put("store.parquet.writer.format_version", ObjectUtils.firstNonNull((Object[])new Object[]{contextOpts.getOption("store.parquet.writer.format_version").getValueMinScope(minScope), this.config.getWriterFormatVersion(), contextOpts.getString("store.parquet.writer.format_version")}).toString());
        ParquetRecordWriter recordWriter = new ParquetRecordWriter(context, writer);
        recordWriter.init(writerOpts);
        return recordWriter;
    }

    public WriterRecordBatch getWriterBatch(FragmentContext context, RecordBatch incoming, ParquetWriter writer) throws ExecutionSetupException {
        try {
            return new WriterRecordBatch(writer, incoming, context, this.getRecordWriter(context, writer));
        }
        catch (IOException e) {
            throw new ExecutionSetupException(String.format("Failed to create the WriterRecordBatch. %s", e.getMessage()), e);
        }
    }

    @Override
    public AbstractFileGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns) throws IOException {
        return this.getGroupScan(userName, selection, (List)columns, (OptionManager)null);
    }

    @Override
    public AbstractFileGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, OptionManager options) throws IOException {
        return this.getGroupScan(userName, selection, (List)columns, options, (MetadataProviderManager)null);
    }

    @Override
    public AbstractFileGroupScan getGroupScan(String userName, FileSelection selection, List<SchemaPath> columns, OptionManager options, MetadataProviderManager metadataProviderManager) throws IOException {
        ParquetReaderConfig readerConfig = ParquetReaderConfig.builder().withFormatConfig(this.getConfig()).withOptions(options).build();
        ParquetGroupScan parquetGroupScan = new ParquetGroupScan(userName, selection, this, columns, readerConfig, metadataProviderManager);
        if (parquetGroupScan.getEntries().isEmpty()) {
            return new SchemalessScan(userName, parquetGroupScan.getSelectionRoot());
        }
        return parquetGroupScan;
    }

    @Override
    public boolean supportsStatistics() {
        return true;
    }

    @Override
    public DrillStatsTable.TableStatistics readStatistics(FileSystem fs, Path statsTablePath) throws IOException {
        Stopwatch timer = Stopwatch.createStarted();
        ObjectMapper mapper = DrillStatsTable.getMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        FSDataInputStream is = fs.open(statsTablePath);
        DrillStatsTable.TableStatistics statistics = (DrillStatsTable.TableStatistics)mapper.readValue((InputStream)is, DrillStatsTable.TableStatistics.class);
        logger.info("Took {} ms to read statistics from {} format plugin", (Object)timer.elapsed(TimeUnit.MILLISECONDS), (Object)this.name);
        timer.stop();
        return statistics;
    }

    @Override
    public void writeStatistics(DrillStatsTable.TableStatistics statistics, FileSystem fs, Path statsTablePath) throws IOException {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public StoragePluginConfig getStorageConfig() {
        return this.storageConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean supportsWrite() {
        return false;
    }

    @Override
    public boolean supportsAutoPartitioning() {
        return true;
    }

    @Override
    public FormatMatcher getMatcher() {
        return this.formatMatcher;
    }

    private static class ParquetFormatMatcher
    extends BasicFormatMatcher {
        private final ParquetFormatConfig formatConfig;

        ParquetFormatMatcher(ParquetFormatPlugin plugin, ParquetFormatConfig formatConfig) {
            super(plugin, PATTERNS, MAGIC_STRINGS);
            this.formatConfig = formatConfig;
        }

        @Override
        public boolean supportDirectoryReads() {
            return true;
        }

        @Override
        public DrillTable isReadable(DrillFileSystem fs, FileSelection selection, FileSystemPlugin fsPlugin, String storageEngineName, SchemaConfig schemaConfig) throws IOException {
            if (selection.containsDirectories(fs)) {
                ParquetReaderConfig readerConfig;
                MetadataContext metaContext;
                ParquetTableMetadataDirs mDirs;
                Path dirMetaPath = new Path(selection.getSelectionRoot(), ".drill.parquet_metadata_directories");
                if (fs.exists(dirMetaPath) && (mDirs = Metadata.readMetadataDirs(fs, dirMetaPath, metaContext = new MetadataContext(), readerConfig = ParquetReaderConfig.builder().withFormatConfig(this.formatConfig).build())) != null && mDirs.getDirectories().size() > 0) {
                    metaContext.setDirectories(mDirs.getDirectories());
                    FileSelection dirSelection = FileSelection.createFromDirectories(mDirs.getDirectories(), selection, selection.getSelectionRoot());
                    dirSelection.setExpandedPartial();
                    dirSelection.setMetaContext(metaContext);
                    return new DynamicDrillTable(fsPlugin, storageEngineName, schemaConfig.getUserName(), (DrillTableSelection)new FormatSelection(this.plugin.getConfig(), dirSelection));
                }
                if (this.isDirReadable(fs, selection.getFirstPath(fs))) {
                    return new DynamicDrillTable(fsPlugin, storageEngineName, schemaConfig.getUserName(), (DrillTableSelection)new FormatSelection(this.plugin.getConfig(), selection));
                }
            }
            return super.isReadable(fs, selection, fsPlugin, storageEngineName, schemaConfig);
        }

        private Path getOldMetadataPath(FileStatus dir) {
            return new Path(dir.getPath(), ".drill.parquet_metadata");
        }

        private boolean metaDataFileExists(FileSystem fs, FileStatus dir) throws IOException {
            boolean fileExists = true;
            for (String metaFileName : Metadata.CURRENT_METADATA_FILENAMES) {
                Path path = new Path(dir.getPath(), metaFileName);
                if (fs.exists(path)) continue;
                fileExists = false;
            }
            if (fileExists) {
                return true;
            }
            return fs.exists(this.getOldMetadataPath(dir));
        }

        boolean isDirReadable(DrillFileSystem fs, FileStatus dir) {
            Path p = new Path(dir.getPath(), "_metadata");
            try {
                if (fs.exists(p)) {
                    return true;
                }
                if (this.metaDataFileExists(fs, dir)) {
                    return true;
                }
                List<FileStatus> statuses = DrillFileSystemUtil.listFiles(fs, dir.getPath(), false, new PathFilter[0]);
                return !statuses.isEmpty() && super.isFileReadable(fs, statuses.get(0));
            }
            catch (IOException e) {
                logger.info("Failure while attempting to check for Parquet metadata file.", (Throwable)e);
                return false;
            }
        }
    }
}

