/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.metastore.MetadataProviderManager;
import org.apache.drill.exec.metastore.MetastoreMetadataProviderManager;
import org.apache.drill.exec.metastore.analyze.AnalyzeInfoProvider;
import org.apache.drill.exec.metastore.analyze.AnalyzeParquetInfoProvider;
import org.apache.drill.exec.metastore.store.FileSystemMetadataProviderManager;
import org.apache.drill.exec.metastore.store.parquet.MetastoreParquetTableMetadataProvider;
import org.apache.drill.exec.metastore.store.parquet.ParquetMetadataProviderBuilder;
import org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProvider;
import org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProviderBuilder;
import org.apache.drill.exec.metastore.store.parquet.ParquetTableMetadataProviderImpl;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.ColumnExplorer;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.dfs.FileSelection;
import org.apache.drill.exec.store.dfs.ReadEntryWithPath;
import org.apache.drill.exec.store.parquet.AbstractParquetGroupScan;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetFormatPlugin;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.ParquetRowGroupScan;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.drill.metastore.metadata.TableMetadataProviderBuilder;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.fs.Path;

@JsonTypeName(value="parquet-scan")
public class ParquetGroupScan
extends AbstractParquetGroupScan {
    private final ParquetFormatPlugin formatPlugin;
    private final ParquetFormatConfig formatConfig;
    private final boolean usedMetadataCache;
    private final Path selectionRoot;
    private final Path cacheFileRoot;

    @JsonCreator
    public ParquetGroupScan(@JacksonInject StoragePluginRegistry engineRegistry, @JsonProperty(value="userName") String userName, @JsonProperty(value="entries") List<ReadEntryWithPath> entries, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JsonProperty(value="format") FormatPluginConfig formatConfig, @JsonProperty(value="columns") List<SchemaPath> columns, @JsonProperty(value="selectionRoot") Path selectionRoot, @JsonProperty(value="cacheFileRoot") Path cacheFileRoot, @JsonProperty(value="readerConfig") ParquetReaderConfig readerConfig, @JsonProperty(value="filter") LogicalExpression filter, @JsonProperty(value="schema") TupleMetadata schema) throws IOException {
        super(ImpersonationUtil.resolveUserName(userName), columns, entries, readerConfig, filter);
        Preconditions.checkNotNull(storageConfig);
        Preconditions.checkNotNull(formatConfig);
        this.cacheFileRoot = cacheFileRoot;
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, formatConfig, ParquetFormatPlugin.class);
        this.formatConfig = this.formatPlugin.getConfig();
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.resolveUserName(userName), this.formatPlugin.getFsConf());
        ParquetMetadataProviderBuilder builder = this.defaultTableMetadataProviderBuilder(new FileSystemMetadataProviderManager());
        this.metadataProvider = ((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)builder.withEntries(this.entries)).withSelectionRoot(selectionRoot)).withCacheFileRoot(cacheFileRoot).withReaderConfig(readerConfig)).withFileSystem(fs)).withCorrectCorruptedDates(this.formatConfig.isAutoCorrectCorruptDates()).withSchema(schema)).build();
        ParquetTableMetadataProvider metadataProvider = (ParquetTableMetadataProvider)this.metadataProvider;
        this.selectionRoot = metadataProvider.getSelectionRoot();
        this.usedMetadataCache = metadataProvider.isUsedMetadataCache();
        this.fileSet = metadataProvider.getFileSet();
        this.init();
    }

    public ParquetGroupScan(String userName, FileSelection selection, ParquetFormatPlugin formatPlugin, List<SchemaPath> columns, ParquetReaderConfig readerConfig, MetadataProviderManager metadataProviderManager) throws IOException {
        this(userName, selection, formatPlugin, columns, readerConfig, ValueExpressions.BooleanExpression.TRUE, metadataProviderManager);
    }

    public ParquetGroupScan(String userName, FileSelection selection, ParquetFormatPlugin formatPlugin, List<SchemaPath> columns, ParquetReaderConfig readerConfig, LogicalExpression filter, MetadataProviderManager metadataProviderManager) throws IOException {
        super(userName, columns, new ArrayList<ReadEntryWithPath>(), readerConfig, filter);
        this.formatPlugin = formatPlugin;
        this.formatConfig = formatPlugin.getConfig();
        this.cacheFileRoot = selection.getCacheFileRoot();
        DrillFileSystem fs = ImpersonationUtil.createFileSystem(ImpersonationUtil.resolveUserName(userName), formatPlugin.getFsConf());
        if (metadataProviderManager == null) {
            metadataProviderManager = new FileSystemMetadataProviderManager();
        }
        TableMetadataProviderBuilder builder = this.tableMetadataProviderBuilder(metadataProviderManager);
        ParquetTableMetadataProvider metadataProvider = ((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)((ParquetTableMetadataProviderBuilder)builder.withSelection(selection)).withReaderConfig(readerConfig)).withFileSystem(fs)).withCorrectCorruptedDates(this.formatConfig.isAutoCorrectCorruptDates()).build();
        this.usedMetadataCache = metadataProvider.isUsedMetadataCache();
        this.usedMetastore = metadataProviderManager.usesMetastore();
        this.selectionRoot = metadataProvider.getSelectionRoot();
        this.entries = metadataProvider.getEntries();
        this.fileSet = metadataProvider.getFileSet();
        this.metadataProvider = metadataProvider;
        this.init();
        this.checkMetadataConsistency(selection, formatPlugin.getFsConf());
    }

    private ParquetGroupScan(ParquetGroupScan that) {
        this(that, (FileSelection)null);
    }

    private ParquetGroupScan(ParquetGroupScan that, FileSelection selection) {
        super(that);
        this.formatConfig = that.formatConfig;
        this.formatPlugin = that.formatPlugin;
        this.selectionRoot = that.selectionRoot;
        this.cacheFileRoot = selection == null ? that.cacheFileRoot : selection.getCacheFileRoot();
        this.usedMetadataCache = that.usedMetadataCache;
        this.usedMetastore = that.usedMetastore;
    }

    @JsonProperty(value="format")
    public ParquetFormatConfig getFormatConfig() {
        return this.formatConfig;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getEngineConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @Override
    @JsonProperty
    public Path getSelectionRoot() {
        return this.selectionRoot;
    }

    @JsonProperty
    public Path getCacheFileRoot() {
        return this.cacheFileRoot;
    }

    @Override
    public ParquetRowGroupScan getSpecificScan(int minorFragmentId) {
        return new ParquetRowGroupScan(this.getUserName(), this.formatPlugin, this.getReadEntries(minorFragmentId), this.columns, this.readerConfig, this.selectionRoot, this.filter, this.tableMetadata == null ? null : this.tableMetadata.getSchema());
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return new ParquetGroupScan(this);
    }

    @Override
    public GroupScan clone(List<SchemaPath> columns) {
        ParquetGroupScan newScan = new ParquetGroupScan(this);
        newScan.columns = columns;
        return newScan;
    }

    @Override
    public ParquetGroupScan clone(FileSelection selection) throws IOException {
        ParquetGroupScan newScan = new ParquetGroupScan(this, selection);
        newScan.modifyFileSelection(selection);
        newScan.init();
        return newScan;
    }

    private List<ReadEntryWithPath> entries() {
        return this.entries;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ParquetGroupScan [");
        builder.append("entries=").append(this.entries());
        builder.append(", selectionRoot=").append(this.selectionRoot);
        builder.append(", numFiles=").append(this.getEntries().size());
        builder.append(", numRowGroups=").append(this.getRowGroupsMetadata().size());
        builder.append(", usedMetadataFile=").append(this.usedMetadataCache);
        builder.append(", usedMetastore=").append(this.usedMetastore);
        String filterString = this.getFilterString();
        if (!filterString.isEmpty()) {
            builder.append(", filter=").append(filterString);
        }
        if (this.usedMetadataCache) {
            String cacheFileRootString = this.cacheFileRoot == null ? Path.getPathWithoutSchemeAndAuthority((Path)this.selectionRoot).toString() : Path.getPathWithoutSchemeAndAuthority((Path)this.cacheFileRoot).toString();
            builder.append(", cacheFileRoot=").append(cacheFileRootString);
        }
        builder.append(", columns=").append(this.columns);
        builder.append("]");
        return builder.toString();
    }

    @Override
    protected AbstractParquetGroupScan cloneWithFileSelection(Collection<Path> filePaths) throws IOException {
        FileSelection newSelection = new FileSelection(null, new ArrayList<Path>(filePaths), this.getSelectionRoot(), this.cacheFileRoot, false);
        return this.clone(newSelection);
    }

    @Override
    protected AbstractParquetGroupScan.RowGroupScanFilterer<?> getFilterer() {
        return new ParquetGroupScanFilterer(this);
    }

    @Override
    protected Collection<CoordinationProtos.DrillbitEndpoint> getDrillbits() {
        return this.formatPlugin.getContext().getBits();
    }

    @Override
    protected boolean supportsFileImplicitColumns() {
        return this.selectionRoot != null;
    }

    @Override
    protected List<String> getPartitionValues(LocationProvider locationProvider) {
        return ColumnExplorer.listPartitionValues(locationProvider.getPath(), this.selectionRoot, false);
    }

    @Override
    public AnalyzeInfoProvider getAnalyzeInfoProvider() {
        return AnalyzeParquetInfoProvider.INSTANCE;
    }

    @Override
    protected ParquetTableMetadataProviderBuilder<?> defaultTableMetadataProviderBuilder(MetadataProviderManager source) {
        return new ParquetTableMetadataProviderImpl.Builder(source);
    }

    @Override
    protected ParquetTableMetadataProviderBuilder<?> tableMetadataProviderBuilder(MetadataProviderManager source) {
        if (source.usesMetastore()) {
            return new MetastoreParquetTableMetadataProvider.Builder((MetastoreMetadataProviderManager)source);
        }
        return this.defaultTableMetadataProviderBuilder(source);
    }

    private static class ParquetGroupScanFilterer
    extends AbstractParquetGroupScan.RowGroupScanFilterer<ParquetGroupScanFilterer> {
        ParquetGroupScanFilterer(ParquetGroupScan source) {
            super(source);
        }

        @Override
        protected AbstractParquetGroupScan getNewScan() {
            return new ParquetGroupScan((ParquetGroupScan)this.source);
        }

        @Override
        protected ParquetGroupScanFilterer self() {
            return this;
        }
    }
}

