/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.ParquetReadOptions;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ParquetReaderConfig {
    public static final String ENABLE_BYTES_READ_COUNTER = "parquet.benchmark.bytes.read";
    public static final String ENABLE_BYTES_TOTAL_COUNTER = "parquet.benchmark.bytes.total";
    public static final String ENABLE_TIME_READ_COUNTER = "parquet.benchmark.time.read";
    private static final ParquetReaderConfig DEFAULT_INSTANCE = new ParquetReaderConfig();
    private boolean enableBytesReadCounter = false;
    private boolean enableBytesTotalCounter = false;
    private boolean enableTimeReadCounter = false;
    private boolean autoCorrectCorruptedDates = true;
    private boolean enableStringsSignedMinMax = false;

    public static Builder builder() {
        return new Builder();
    }

    public static ParquetReaderConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    @JsonCreator
    public ParquetReaderConfig(@JsonProperty(value="enableBytesReadCounter") Boolean enableBytesReadCounter, @JsonProperty(value="enableBytesTotalCounter") Boolean enableBytesTotalCounter, @JsonProperty(value="enableTimeReadCounter") Boolean enableTimeReadCounter, @JsonProperty(value="autoCorrectCorruptedDates") Boolean autoCorrectCorruptedDates, @JsonProperty(value="enableStringsSignedMinMax") Boolean enableStringsSignedMinMax) {
        this.enableBytesReadCounter = enableBytesReadCounter == null ? this.enableBytesReadCounter : enableBytesReadCounter;
        this.enableBytesTotalCounter = enableBytesTotalCounter == null ? this.enableBytesTotalCounter : enableBytesTotalCounter;
        this.enableTimeReadCounter = enableTimeReadCounter == null ? this.enableTimeReadCounter : enableTimeReadCounter;
        this.autoCorrectCorruptedDates = autoCorrectCorruptedDates == null ? this.autoCorrectCorruptedDates : autoCorrectCorruptedDates;
        this.enableStringsSignedMinMax = enableStringsSignedMinMax == null ? this.enableStringsSignedMinMax : enableStringsSignedMinMax;
    }

    private ParquetReaderConfig() {
    }

    @JsonProperty(value="enableBytesReadCounter")
    public boolean enableBytesReadCounter() {
        return this.enableBytesReadCounter;
    }

    @JsonProperty(value="enableBytesTotalCounter")
    public boolean enableBytesTotalCounter() {
        return this.enableBytesTotalCounter;
    }

    @JsonProperty(value="enableTimeReadCounter")
    public boolean enableTimeReadCounter() {
        return this.enableTimeReadCounter;
    }

    @JsonProperty(value="autoCorrectCorruptedDates")
    public boolean autoCorrectCorruptedDates() {
        return this.autoCorrectCorruptedDates;
    }

    @JsonProperty(value="enableStringsSignedMinMax")
    public boolean enableStringsSignedMinMax() {
        return this.enableStringsSignedMinMax;
    }

    public ParquetReadOptions toReadOptions() {
        return ParquetReadOptions.builder().useSignedStringMinMax(this.enableStringsSignedMinMax).build();
    }

    public Configuration addCountersToConf(Configuration conf) {
        Configuration newConfig = new Configuration(conf);
        newConfig.setBoolean(ENABLE_BYTES_READ_COUNTER, this.enableBytesReadCounter);
        newConfig.setBoolean(ENABLE_BYTES_TOTAL_COUNTER, this.enableBytesTotalCounter);
        newConfig.setBoolean(ENABLE_TIME_READ_COUNTER, this.enableTimeReadCounter);
        return newConfig;
    }

    public int hashCode() {
        return Objects.hash(this.enableBytesReadCounter, this.enableBytesTotalCounter, this.enableTimeReadCounter, this.autoCorrectCorruptedDates, this.enableStringsSignedMinMax);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParquetReaderConfig that = (ParquetReaderConfig)o;
        return this.enableBytesReadCounter == that.enableBytesReadCounter && this.enableBytesTotalCounter == that.enableBytesTotalCounter && this.enableTimeReadCounter == that.enableTimeReadCounter && this.autoCorrectCorruptedDates == that.autoCorrectCorruptedDates && this.enableStringsSignedMinMax == that.enableStringsSignedMinMax;
    }

    public String toString() {
        return "ParquetReaderConfig{enableBytesReadCounter=" + this.enableBytesReadCounter + ", enableBytesTotalCounter=" + this.enableBytesTotalCounter + ", enableTimeReadCounter=" + this.enableTimeReadCounter + ", autoCorrectCorruptedDates=" + this.autoCorrectCorruptedDates + ", enableStringsSignedMinMax=" + this.enableStringsSignedMinMax + '}';
    }

    public static class Builder {
        private ParquetFormatConfig formatConfig;
        private Configuration conf;
        private OptionManager options;

        public Builder withFormatConfig(ParquetFormatConfig formatConfig) {
            this.formatConfig = formatConfig;
            return this;
        }

        public Builder withConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder withOptions(OptionManager options) {
            this.options = options;
            return this;
        }

        public ParquetReaderConfig build() {
            String optVal;
            ParquetReaderConfig readerConfig = new ParquetReaderConfig();
            if (this.formatConfig != null) {
                readerConfig.autoCorrectCorruptedDates = this.formatConfig.isAutoCorrectCorruptDates();
                readerConfig.enableStringsSignedMinMax = this.formatConfig.isEnableStringsSignedMinMax();
            }
            if (this.conf != null) {
                readerConfig.enableBytesReadCounter = this.conf.getBoolean(ParquetReaderConfig.ENABLE_BYTES_READ_COUNTER, readerConfig.enableBytesReadCounter);
                readerConfig.enableBytesTotalCounter = this.conf.getBoolean(ParquetReaderConfig.ENABLE_BYTES_TOTAL_COUNTER, readerConfig.enableBytesTotalCounter);
                readerConfig.enableTimeReadCounter = this.conf.getBoolean(ParquetReaderConfig.ENABLE_TIME_READ_COUNTER, readerConfig.enableTimeReadCounter);
            }
            if (this.options != null && (optVal = (String)this.options.getOption("store.parquet.reader.strings_signed_min_max").getValueMinScope(OptionValue.OptionScope.SESSION)) != null && !optVal.isEmpty()) {
                readerConfig.enableStringsSignedMinMax = Boolean.valueOf(optVal);
            }
            return readerConfig;
        }
    }
}

