/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.store.CommonParquetRecordReader;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;

public class ParquetReaderStats {
    public AtomicLong numRowgroups = new AtomicLong();
    public AtomicLong rowgroupsPruned = new AtomicLong();
    public AtomicLong numDictPageLoads = new AtomicLong();
    public AtomicLong numDataPageLoads = new AtomicLong();
    public AtomicLong numDataPagesDecoded = new AtomicLong();
    public AtomicLong numDictPagesDecompressed = new AtomicLong();
    public AtomicLong numDataPagesDecompressed = new AtomicLong();
    public AtomicLong totalDictPageReadBytes = new AtomicLong();
    public AtomicLong totalDataPageReadBytes = new AtomicLong();
    public AtomicLong totalDictDecompressedBytes = new AtomicLong();
    public AtomicLong totalDataDecompressedBytes = new AtomicLong();
    public AtomicLong timeDictPageLoads = new AtomicLong();
    public AtomicLong timeDataPageLoads = new AtomicLong();
    public AtomicLong timeDataPageDecode = new AtomicLong();
    public AtomicLong timeDictPageDecode = new AtomicLong();
    public AtomicLong timeDictPagesDecompressed = new AtomicLong();
    public AtomicLong timeDataPagesDecompressed = new AtomicLong();
    public AtomicLong timeDiskScanWait = new AtomicLong();
    public AtomicLong timeDiskScan = new AtomicLong();
    public AtomicLong timeFixedColumnRead = new AtomicLong();
    public AtomicLong timeVarColumnRead = new AtomicLong();
    public AtomicLong timeProcess = new AtomicLong();

    public void logStats(Logger logger, Path hadoopPath) {
        logger.trace("ParquetTrace,Summary,{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{},{}", new Object[]{hadoopPath, this.numRowgroups, this.rowgroupsPruned, this.numDictPageLoads, this.numDataPageLoads, this.numDataPagesDecoded, this.numDictPagesDecompressed, this.numDataPagesDecompressed, this.totalDictPageReadBytes, this.totalDataPageReadBytes, this.totalDictDecompressedBytes, this.totalDataDecompressedBytes, this.timeDictPageLoads, this.timeDataPageLoads, this.timeDataPageDecode, this.timeDictPageDecode, this.timeDictPagesDecompressed, this.timeDataPagesDecompressed, this.timeDiskScanWait, this.timeDiskScan, this.timeFixedColumnRead, this.timeVarColumnRead});
    }

    public void update(OperatorStats stats) {
        stats.setLongStat(CommonParquetRecordReader.Metric.NUM_ROWGROUPS, this.numRowgroups.longValue());
        stats.setLongStat(CommonParquetRecordReader.Metric.ROWGROUPS_PRUNED, this.rowgroupsPruned.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.NUM_DICT_PAGE_LOADS, this.numDictPageLoads.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.NUM_DATA_PAGE_lOADS, this.numDataPageLoads.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.NUM_DATA_PAGES_DECODED, this.numDataPagesDecoded.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.NUM_DICT_PAGES_DECOMPRESSED, this.numDictPagesDecompressed.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.NUM_DATA_PAGES_DECOMPRESSED, this.numDataPagesDecompressed.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TOTAL_DICT_PAGE_READ_BYTES, this.totalDictPageReadBytes.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TOTAL_DATA_PAGE_READ_BYTES, this.totalDataPageReadBytes.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TOTAL_DICT_DECOMPRESSED_BYTES, this.totalDictDecompressedBytes.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TOTAL_DATA_DECOMPRESSED_BYTES, this.totalDataDecompressedBytes.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DICT_PAGE_LOADS, this.timeDictPageLoads.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DATA_PAGE_LOADS, this.timeDataPageLoads.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DATA_PAGE_DECODE, this.timeDataPageDecode.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DICT_PAGE_DECODE, this.timeDictPageDecode.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DICT_PAGES_DECOMPRESSED, this.timeDictPagesDecompressed.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DATA_PAGES_DECOMPRESSED, this.timeDataPagesDecompressed.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DISK_SCAN_WAIT, this.timeDiskScanWait.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_DISK_SCAN, this.timeDiskScan.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_FIXEDCOLUMN_READ, this.timeFixedColumnRead.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_VARCOLUMN_READ, this.timeVarColumnRead.longValue());
        stats.addLongStat(CommonParquetRecordReader.Metric.TIME_PROCESS, this.timeProcess.longValue());
    }
}

