/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.parquet.ParquetReaderConfig;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.parquet.metadata.MetadataVersion;
import org.apache.drill.exec.store.parquet.metadata.Metadata_V2;
import org.apache.drill.exec.util.Utilities;
import org.apache.drill.exec.work.ExecErrorConstants;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.util.VersionUtil;
import org.apache.parquet.SemanticVersion;
import org.apache.parquet.VersionParser;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.example.data.simple.NanoTime;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetReaderUtility {
    private static final Logger logger = LoggerFactory.getLogger(ParquetReaderUtility.class);
    public static final long JULIAN_DAY_NUMBER_FOR_UNIX_EPOCH = 2440588L;
    public static final long CORRECT_CORRUPT_DATE_SHIFT = 4881176L;
    private static final Chronology UTC = ISOChronology.getInstanceUTC();
    public static final int DATE_CORRUPTION_THRESHOLD = (int)(UTC.getDateTimeMillis(5000, 1, 1, 0) / 86400000L);
    public static final int DRILL_WRITER_VERSION_STD_DATE_FORMAT = 2;
    public static final String ALLOWED_DRILL_VERSION_FOR_BINARY = "1.15.0";

    public static void checkDecimalTypeEnabled(OptionManager options) {
        if (!options.getOption(PlannerSettings.ENABLE_DECIMAL_DATA_TYPE)) {
            throw UserException.unsupportedError().message(ExecErrorConstants.DECIMAL_DISABLE_ERR_MSG, new Object[0]).build(logger);
        }
    }

    public static int getIntFromLEBytes(byte[] input, int start) {
        int out = 0;
        int shiftOrder = 0;
        for (int i = start; i < start + 4; ++i) {
            out |= (input[i] & 0xFF) << shiftOrder;
            shiftOrder += 8;
        }
        return out;
    }

    public static Map<String, SchemaElement> getColNameToSchemaElementMapping(ParquetMetadata footer) {
        HashMap<String, SchemaElement> schemaElements = new HashMap<String, SchemaElement>();
        FileMetaData fileMetaData = new ParquetMetadataConverter().toParquetMetadata(1, footer);
        Iterator<SchemaElement> iter = fileMetaData.getSchema().iterator();
        if (iter.hasNext()) {
            iter.next();
        }
        while (iter.hasNext()) {
            ParquetReaderUtility.addSchemaElementMapping(iter, new StringBuilder(), schemaElements);
        }
        return schemaElements;
    }

    private static void addSchemaElementMapping(Iterator<SchemaElement> iter, StringBuilder path, Map<String, SchemaElement> schemaElements) {
        SchemaElement schemaElement = iter.next();
        path.append('`').append(schemaElement.getName().toLowerCase()).append('`');
        schemaElements.put(path.toString(), schemaElement);
        for (int remainingChildren = schemaElement.getNum_children(); remainingChildren > 0 && iter.hasNext(); --remainingChildren) {
            ParquetReaderUtility.addSchemaElementMapping(iter, new StringBuilder(path).append('.'), schemaElements);
        }
    }

    public static String getFullColumnPath(ColumnDescriptor column) {
        StringBuilder sb = new StringBuilder();
        String[] path = column.getPath();
        for (int i = 0; i < path.length; ++i) {
            sb.append("`").append(path[i].toLowerCase()).append("`").append(".");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, ColumnDescriptor> getColNameToColumnDescriptorMapping(ParquetMetadata footer) {
        HashMap<String, ColumnDescriptor> colDescMap = new HashMap<String, ColumnDescriptor>();
        List columns = footer.getFileMetaData().getSchema().getColumns();
        for (ColumnDescriptor column : columns) {
            colDescMap.put(ParquetReaderUtility.getFullColumnPath(column), column);
        }
        return colDescMap;
    }

    public static int autoCorrectCorruptedDate(int corruptedDate) {
        return (int)((long)corruptedDate - 4881176L);
    }

    public static void correctDatesInMetadataCache(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        DateCorruptionStatus cacheFileCanContainsCorruptDates;
        MetadataVersion metadataVersion = new MetadataVersion(parquetTableMetadata.getMetadataVersion());
        DateCorruptionStatus dateCorruptionStatus = cacheFileCanContainsCorruptDates = metadataVersion.isAtLeast(3, 0) ? DateCorruptionStatus.META_SHOWS_NO_CORRUPTION : DateCorruptionStatus.META_UNCLEAR_TEST_VALUES;
        if (cacheFileCanContainsCorruptDates == DateCorruptionStatus.META_UNCLEAR_TEST_VALUES) {
            Object[] names = new String[]{};
            if (metadataVersion.isEqualTo(2, 0)) {
                for (Metadata_V2.ColumnTypeMetadata_v2 columnTypeMetadata_v2 : ((Metadata_V2.ParquetTableMetadata_v2)parquetTableMetadata).columnTypeInfo.values()) {
                    if (!OriginalType.DATE.equals((Object)columnTypeMetadata_v2.originalType)) continue;
                    names = columnTypeMetadata_v2.name;
                }
            }
            for (MetadataBase.ParquetFileMetadata parquetFileMetadata : parquetTableMetadata.getFiles()) {
                MetadataBase.RowGroupMetadata rowGroupMetadata = parquetFileMetadata.getRowGroups().get(0);
                Long rowCount = rowGroupMetadata.getRowCount();
                for (MetadataBase.ColumnMetadata columnMetadata : rowGroupMetadata.getColumns()) {
                    if (metadataVersion.isEqualTo(1, 0)) {
                        OriginalType originalType = columnMetadata.getOriginalType();
                        if (!OriginalType.DATE.equals((Object)originalType) || !columnMetadata.hasSingleValue(rowCount) || (Integer)columnMetadata.getMaxValue() <= DATE_CORRUPTION_THRESHOLD) continue;
                        int newMinMax = ParquetReaderUtility.autoCorrectCorruptedDate((Integer)columnMetadata.getMaxValue());
                        columnMetadata.setMax(newMinMax);
                        columnMetadata.setMin(newMinMax);
                        continue;
                    }
                    if (!metadataVersion.isEqualTo(2, 0) || columnMetadata.getName() == null || !Arrays.equals(columnMetadata.getName(), names) || !columnMetadata.hasSingleValue(rowCount) || (Integer)columnMetadata.getMaxValue() <= DATE_CORRUPTION_THRESHOLD) continue;
                    int newMax = ParquetReaderUtility.autoCorrectCorruptedDate((Integer)columnMetadata.getMaxValue());
                    columnMetadata.setMax(newMax);
                }
            }
        }
    }

    public static void transformBinaryInMetadataCache(MetadataBase.ParquetTableMetadataBase parquetTableMetadata, ParquetReaderConfig readerConfig) {
        int n;
        int n2;
        Set<List<String>> columnsNames = ParquetReaderUtility.getBinaryColumnsNames(parquetTableMetadata);
        boolean allowBinaryMetadata = ParquetReaderUtility.allowBinaryMetadata(parquetTableMetadata.getDrillVersion(), readerConfig);
        MetadataVersion metadataVersion = new MetadataVersion(parquetTableMetadata.getMetadataVersion());
        if (metadataVersion.isEqualTo(1, 0)) {
            for (MetadataBase.ParquetFileMetadata parquetFileMetadata : parquetTableMetadata.getFiles()) {
                for (MetadataBase.RowGroupMetadata rowGroupMetadata : parquetFileMetadata.getRowGroups()) {
                    Long rowCount = rowGroupMetadata.getRowCount();
                    for (MetadataBase.ColumnMetadata columnMetadata : rowGroupMetadata.getColumns()) {
                        if (columnMetadata.getPrimitiveType() != PrimitiveType.PrimitiveTypeName.BINARY && columnMetadata.getPrimitiveType() != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) continue;
                        ParquetReaderUtility.setMinMaxValues(columnMetadata, rowCount, allowBinaryMetadata, false);
                    }
                }
            }
            return;
        }
        Stopwatch timer = logger.isDebugEnabled() ? Stopwatch.createStarted() : null;
        boolean bl = false;
        int minRowGroups = Integer.MAX_VALUE;
        boolean bl2 = false;
        boolean needDecoding = metadataVersion.isAtLeast(3, 3);
        for (MetadataBase.ParquetFileMetadata parquetFileMetadata : parquetTableMetadata.getFiles()) {
            if (timer != null) {
                n2 = Math.max(n2, parquetFileMetadata.getRowGroups().size());
                minRowGroups = Math.min(minRowGroups, parquetFileMetadata.getRowGroups().size());
            }
            for (MetadataBase.RowGroupMetadata rowGroupMetadata : parquetFileMetadata.getRowGroups()) {
                Long rowCount = rowGroupMetadata.getRowCount();
                if (timer != null) {
                    n = Math.max(n, rowGroupMetadata.getColumns().size());
                }
                for (MetadataBase.ColumnMetadata columnMetadata : rowGroupMetadata.getColumns()) {
                    if (!columnsNames.contains(Arrays.asList(columnMetadata.getName()))) continue;
                    ParquetReaderUtility.setMinMaxValues(columnMetadata, rowCount, allowBinaryMetadata, needDecoding);
                }
            }
        }
        if (timer != null) {
            String reportRG = 1 == n2 ? "1 rowgroup" : "between " + minRowGroups + "-" + n2 + "rowgroups";
            logger.debug("Transforming binary in metadata cache took {} ms ({} files, {} per file, max {} columns)", new Object[]{timer.elapsed(TimeUnit.MILLISECONDS), parquetTableMetadata.getFiles().size(), reportRG, n});
            timer.stop();
        }
    }

    private static boolean allowBinaryMetadata(String drillVersion, ParquetReaderConfig readerConfig) {
        return readerConfig.enableStringsSignedMinMax() || drillVersion != null && VersionUtil.compareVersions((String)ALLOWED_DRILL_VERSION_FOR_BINARY, (String)drillVersion) <= 0;
    }

    private static Set<List<String>> getBinaryColumnsNames(MetadataBase.ParquetTableMetadataBase parquetTableMetadata) {
        HashSet<List<String>> names = new HashSet<List<String>>();
        List<? extends MetadataBase.ColumnTypeMetadata> columnTypeMetadataList = parquetTableMetadata.getColumnTypeInfoList();
        if (columnTypeMetadataList != null) {
            for (MetadataBase.ColumnTypeMetadata columnTypeMetadata : columnTypeMetadataList) {
                if (columnTypeMetadata.getPrimitiveType() != PrimitiveType.PrimitiveTypeName.BINARY && columnTypeMetadata.getPrimitiveType() != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) continue;
                names.add(Arrays.asList(columnTypeMetadata.getName()));
            }
        }
        return names;
    }

    private static void setMinMaxValues(MetadataBase.ColumnMetadata columnMetadata, long rowCount, boolean allowBinaryMetadata, boolean needsDecoding) {
        byte[] minBytes = null;
        byte[] maxBytes = null;
        boolean hasSingleValue = false;
        if (allowBinaryMetadata || (hasSingleValue = columnMetadata.hasSingleValue(rowCount))) {
            Object minValue = columnMetadata.getMinValue();
            Object maxValue = columnMetadata.getMaxValue();
            if (minValue instanceof String && maxValue instanceof String) {
                minBytes = ((String)minValue).getBytes(StandardCharsets.UTF_8);
                maxBytes = ((String)maxValue).getBytes(StandardCharsets.UTF_8);
                if (needsDecoding) {
                    minBytes = Base64.decodeBase64((byte[])minBytes);
                    maxBytes = hasSingleValue ? minBytes : Base64.decodeBase64((byte[])maxBytes);
                }
            } else if (minValue instanceof Binary && maxValue instanceof Binary) {
                minBytes = ((Binary)minValue).getBytes();
                maxBytes = ((Binary)maxValue).getBytes();
            }
        }
        columnMetadata.setMin(minBytes);
        columnMetadata.setMax(maxBytes);
    }

    public static DateCorruptionStatus detectCorruptDates(ParquetMetadata footer, List<SchemaPath> columns, boolean autoCorrectCorruptDates) {
        String createdBy = footer.getFileMetaData().getCreatedBy();
        String drillVersion = (String)footer.getFileMetaData().getKeyValueMetaData().get("drill.version");
        String writerVersionValue = (String)footer.getFileMetaData().getKeyValueMetaData().get("drill-writer.version");
        String isDateCorrectFlag = "is.date.correct";
        String isDateCorrect = (String)footer.getFileMetaData().getKeyValueMetaData().get("is.date.correct");
        if (drillVersion != null) {
            int writerVersion = 1;
            if (writerVersionValue != null) {
                writerVersion = Integer.parseInt(writerVersionValue);
            } else if (Boolean.valueOf(isDateCorrect).booleanValue()) {
                writerVersion = 2;
            }
            return writerVersion >= 2 ? DateCorruptionStatus.META_SHOWS_NO_CORRUPTION : ParquetReaderUtility.checkForCorruptDateValuesInStatistics(footer, columns, autoCorrectCorruptDates);
        }
        if (createdBy == null || createdBy.equals("parquet-mr")) {
            return ParquetReaderUtility.checkForCorruptDateValuesInStatistics(footer, columns, autoCorrectCorruptDates);
        }
        try {
            VersionParser.ParsedVersion parsedCreatedByVersion = VersionParser.parse((String)createdBy);
            if (parsedCreatedByVersion.hasSemanticVersion()) {
                SemanticVersion semVer = parsedCreatedByVersion.getSemanticVersion();
                String pre = semVer.pre + "";
                if (semVer.major == 1 && semVer.minor == 8 && semVer.patch == 1 && pre.contains("drill")) {
                    return ParquetReaderUtility.checkForCorruptDateValuesInStatistics(footer, columns, autoCorrectCorruptDates);
                }
            }
            return DateCorruptionStatus.META_SHOWS_NO_CORRUPTION;
        }
        catch (VersionParser.VersionParseException e) {
            return ParquetReaderUtility.checkForCorruptDateValuesInStatistics(footer, columns, autoCorrectCorruptDates);
        }
    }

    public static DateCorruptionStatus checkForCorruptDateValuesInStatistics(ParquetMetadata footer, List<SchemaPath> columns, boolean autoCorrectCorruptDates) {
        if (!autoCorrectCorruptDates) {
            return DateCorruptionStatus.META_SHOWS_NO_CORRUPTION;
        }
        int rowGroupIndex = 0;
        Map<String, SchemaElement> schemaElements = ParquetReaderUtility.getColNameToSchemaElementMapping(footer);
        for (SchemaPath schemaPath : columns) {
            List parquetColumns = footer.getFileMetaData().getSchema().getColumns();
            for (int i = 0; i < parquetColumns.size(); ++i) {
                ColumnDescriptor column = (ColumnDescriptor)parquetColumns.get(i);
                if (!Utilities.isStarQuery(columns) && !ParquetReaderUtility.getFullColumnPath(column).equalsIgnoreCase(schemaPath.getUnIndexed().toString())) continue;
                int colIndex = -1;
                ConvertedType convertedType = schemaElements.get(ParquetReaderUtility.getFullColumnPath(column)).getConverted_type();
                if (convertedType != null && convertedType.equals((Object)ConvertedType.DATE)) {
                    List colChunkList = ((BlockMetaData)footer.getBlocks().get(rowGroupIndex)).getColumns();
                    for (int j = 0; j < colChunkList.size(); ++j) {
                        if (!((ColumnChunkMetaData)colChunkList.get(j)).getPath().equals((Object)ColumnPath.get((String[])column.getPath()))) continue;
                        colIndex = j;
                        break;
                    }
                }
                if (colIndex == -1) continue;
                IntStatistics statistics = (IntStatistics)((ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(rowGroupIndex)).getColumns().get(colIndex)).getStatistics();
                return statistics.hasNonNullValue() && statistics.compareMaxToValue(DATE_CORRUPTION_THRESHOLD) > 0 ? DateCorruptionStatus.META_SHOWS_CORRUPTION : DateCorruptionStatus.META_UNCLEAR_TEST_VALUES;
            }
        }
        return DateCorruptionStatus.META_SHOWS_NO_CORRUPTION;
    }

    public static TypeProtos.MajorType getType(PrimitiveType.PrimitiveTypeName type, OriginalType originalType, int precision, int scale) {
        TypeProtos.MinorType minorType = ParquetReaderUtility.getMinorType(type, originalType);
        if (originalType == OriginalType.DECIMAL) {
            return Types.withPrecisionAndScale(minorType, TypeProtos.DataMode.OPTIONAL, precision, scale);
        }
        return Types.optional(minorType);
    }

    public static TypeProtos.MinorType getMinorType(PrimitiveType.PrimitiveTypeName type, OriginalType originalType) {
        if (originalType != null) {
            switch (originalType) {
                case DECIMAL: {
                    return TypeProtos.MinorType.VARDECIMAL;
                }
                case DATE: {
                    return TypeProtos.MinorType.DATE;
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    return TypeProtos.MinorType.TIME;
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return TypeProtos.MinorType.TIMESTAMP;
                }
                case UTF8: {
                    return TypeProtos.MinorType.VARCHAR;
                }
                case UINT_8: {
                    return TypeProtos.MinorType.UINT1;
                }
                case UINT_16: {
                    return TypeProtos.MinorType.UINT2;
                }
                case UINT_32: {
                    return TypeProtos.MinorType.UINT4;
                }
                case UINT_64: {
                    return TypeProtos.MinorType.UINT8;
                }
                case INT_8: {
                    return TypeProtos.MinorType.TINYINT;
                }
                case INT_16: {
                    return TypeProtos.MinorType.SMALLINT;
                }
                case INTERVAL: {
                    return TypeProtos.MinorType.INTERVAL;
                }
            }
        }
        switch (type) {
            case BOOLEAN: {
                return TypeProtos.MinorType.BIT;
            }
            case INT32: {
                return TypeProtos.MinorType.INT;
            }
            case INT64: {
                return TypeProtos.MinorType.BIGINT;
            }
            case FLOAT: {
                return TypeProtos.MinorType.FLOAT4;
            }
            case DOUBLE: {
                return TypeProtos.MinorType.FLOAT8;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: 
            case INT96: {
                return TypeProtos.MinorType.VARBINARY;
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    public static boolean containsComplexColumn(ParquetMetadata footer, List<SchemaPath> columns) {
        MessageType schema = footer.getFileMetaData().getSchema();
        if (Utilities.isStarQuery(columns)) {
            for (Type type : schema.getFields()) {
                if (type.isPrimitive()) continue;
                return true;
            }
            for (ColumnDescriptor col : schema.getColumns()) {
                if (col.getMaxRepetitionLevel() <= 0) continue;
                return true;
            }
            return false;
        }
        Map<String, ColumnDescriptor> colDescMap = ParquetReaderUtility.getColNameToColumnDescriptorMapping(footer);
        Map<String, SchemaElement> schemaElements = ParquetReaderUtility.getColNameToSchemaElementMapping(footer);
        for (SchemaPath schemaPath : columns) {
            if (!schemaPath.isLeaf()) {
                logger.trace("rowGroupScan contains complex column: {}", (Object)schemaPath.getUnIndexed().toString());
                return true;
            }
            ColumnDescriptor column = colDescMap.get(schemaPath.getUnIndexed().toString().toLowerCase());
            if (column == null) {
                SchemaElement schemaElement = schemaElements.get(schemaPath.getUnIndexed().toString().toLowerCase());
                if (schemaElement == null) continue;
                return true;
            }
            if (column.getMaxRepetitionLevel() <= 0) continue;
            logger.trace("rowGroupScan contains repetitive column: {}", (Object)schemaPath.getUnIndexed().toString());
            return true;
        }
        return false;
    }

    public static List<TypeProtos.MajorType> getComplexTypes(List<OriginalType> originalTypes) {
        ArrayList<TypeProtos.MajorType> result = new ArrayList<TypeProtos.MajorType>();
        if (originalTypes == null) {
            return result;
        }
        for (OriginalType type : originalTypes) {
            if (type == OriginalType.MAP) {
                result.add(Types.required(TypeProtos.MinorType.DICT));
                continue;
            }
            if (type == OriginalType.LIST) {
                result.add(Types.required(TypeProtos.MinorType.LIST));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static boolean isLogicalListType(GroupType groupType) {
        if (groupType.getOriginalType() == OriginalType.LIST && groupType.getFieldCount() == 1) {
            Type nestedField = (Type)groupType.getFields().get(0);
            return nestedField.isRepetition(Type.Repetition.REPEATED) && !nestedField.isPrimitive() && nestedField.getOriginalType() == null && nestedField.asGroupType().getFieldCount() == 1;
        }
        return false;
    }

    public static boolean isLogicalMapType(GroupType groupType) {
        OriginalType type = groupType.getOriginalType();
        if ((type == OriginalType.MAP || type == OriginalType.MAP_KEY_VALUE) && groupType.getFieldCount() == 1) {
            Type nestedField = (Type)groupType.getFields().get(0);
            return nestedField.isRepetition(Type.Repetition.REPEATED) && !nestedField.isPrimitive() && nestedField.asGroupType().getFieldCount() == 2;
        }
        return false;
    }

    public static TypeProtos.DataMode getDataMode(Type.Repetition repetition) {
        TypeProtos.DataMode mode;
        switch (repetition) {
            case REPEATED: {
                mode = TypeProtos.DataMode.REPEATED;
                break;
            }
            case OPTIONAL: {
                mode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
            case REQUIRED: {
                mode = TypeProtos.DataMode.REQUIRED;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown Repetition: %s.", repetition));
            }
        }
        return mode;
    }

    public static enum DateCorruptionStatus {
        META_SHOWS_CORRUPTION{

            public String toString() {
                return "It is determined from metadata that the date values are definitely CORRUPT";
            }
        }
        ,
        META_SHOWS_NO_CORRUPTION{

            public String toString() {
                return "It is determined from metadata that the date values are definitely CORRECT";
            }
        }
        ,
        META_UNCLEAR_TEST_VALUES{

            public String toString() {
                return "Not enough info in metadata, parquet reader will test individual date values";
            }
        };

    }

    public static class NanoTimeUtils {
        public static final long NANOS_PER_MILLISECOND = 1000000L;

        public static long getDateTimeValueFromBinary(Binary binaryTimeStampValue, boolean retainLocalTimezone) {
            NanoTime nt = NanoTime.fromBinary((Binary)binaryTimeStampValue);
            int julianDay = nt.getJulianDay();
            long nanosOfDay = nt.getTimeOfDayNanos();
            long dateTime = ((long)julianDay - 2440588L) * 86400000L + nanosOfDay / 1000000L;
            if (retainLocalTimezone) {
                return DateTimeZone.getDefault().convertUTCToLocal(dateTime);
            }
            return dateTime;
        }
    }
}

