/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.store.EventBasedRecordWriter;
import org.apache.drill.exec.store.ParquetOutputRecordWriter;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.parquet.ParquetDirectByteBufferAllocator;
import org.apache.drill.exec.store.parquet.ParquetTypeHelper;
import org.apache.drill.exec.store.parquet.ParquetWriter;
import org.apache.drill.exec.store.parquet.compression.DrillCompressionCodecFactory;
import org.apache.drill.exec.util.DecimalUtility;
import org.apache.drill.exec.vector.BitVector;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.impl.ColumnWriteStoreV2;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.values.factory.DefaultV1ValuesWriterFactory;
import org.apache.parquet.column.values.factory.DefaultV2ValuesWriterFactory;
import org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.hadoop.ParquetColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetRecordWriter
extends ParquetOutputRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(ParquetRecordWriter.class);
    private static final int MINIMUM_BUFFER_SIZE = 65536;
    private static final int MINIMUM_RECORD_COUNT_FOR_CHECK = 100;
    private static final int MAXIMUM_RECORD_COUNT_FOR_CHECK = 10000;
    private static final int BLOCKSIZE_MULTIPLE = 65536;
    private static final String GROUP_KEY_VALUE_NAME = "key_value";
    public static final String DRILL_VERSION_PROPERTY = "drill.version";
    public static final String WRITER_VERSION_PROPERTY = "drill-writer.version";
    private final StorageStrategy storageStrategy;
    private ParquetFileWriter parquetFileWriter;
    private MessageType schema;
    private Map<String, String> extraMetaData = new HashMap<String, String>();
    private int blockSize;
    private int pageSize;
    private int dictionaryPageSize;
    private boolean enableDictionary = false;
    private boolean useSingleFSBlock = false;
    private CompressionCodecName codec = CompressionCodecName.SNAPPY;
    private ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
    private CompressionCodecFactory codecFactory;
    private long recordCount = 0L;
    private long recordCountForNextMemCheck = 100L;
    private ColumnWriteStore store;
    private ParquetColumnChunkPageWriteStore pageStore;
    private RecordConsumer consumer;
    private BatchSchema batchSchema;
    private Configuration conf;
    private FileSystem fs;
    private String location;
    private List<Path> cleanUpLocations;
    private String prefix;
    private int index = 0;
    private OperatorContext oContext;
    private List<String> partitionColumns;
    private boolean hasPartitions;
    private PrimitiveType.PrimitiveTypeName logicalTypeForDecimals;
    private boolean usePrimitiveTypesForDecimals;
    private boolean empty = true;

    public ParquetRecordWriter(FragmentContext context, ParquetWriter writer) throws OutOfMemoryException {
        this.oContext = context.newOperatorContext(writer);
        this.codecFactory = DrillCompressionCodecFactory.createDirectCodecFactory(writer.getFormatPlugin().getFsConf(), new ParquetDirectByteBufferAllocator(this.oContext.getAllocator()), this.pageSize);
        this.partitionColumns = writer.getPartitionColumns();
        this.hasPartitions = this.partitionColumns != null && this.partitionColumns.size() > 0;
        this.extraMetaData.put(DRILL_VERSION_PROPERTY, DrillVersionInfo.getVersion());
        this.extraMetaData.put(WRITER_VERSION_PROPERTY, String.valueOf(3));
        this.storageStrategy = writer.getStorageStrategy() == null ? StorageStrategy.DEFAULT : writer.getStorageStrategy();
        this.cleanUpLocations = new ArrayList<Path>();
        this.conf = new Configuration(writer.getFormatPlugin().getFsConf());
    }

    @Override
    public void init(Map<String, String> writerOptions) throws IOException {
        String logicalTypeNameForDecimals;
        String codecName;
        this.location = writerOptions.get("location");
        this.prefix = writerOptions.get("prefix");
        this.fs = FileSystem.get((Configuration)this.conf);
        this.blockSize = Integer.parseInt(writerOptions.get("store.parquet.block-size"));
        this.pageSize = Integer.parseInt(writerOptions.get("store.parquet.page-size"));
        this.dictionaryPageSize = Integer.parseInt(writerOptions.get("store.parquet.dictionary.page-size"));
        switch (codecName = writerOptions.get("store.parquet.compression").toLowerCase()) {
            case "none": 
            case "uncompressed": {
                this.codec = CompressionCodecName.UNCOMPRESSED;
                break;
            }
            case "brotli": {
                this.codec = CompressionCodecName.BROTLI;
                break;
            }
            case "gzip": {
                this.codec = CompressionCodecName.GZIP;
                break;
            }
            case "lz4": {
                this.codec = CompressionCodecName.LZ4;
                break;
            }
            case "lzo": {
                this.codec = CompressionCodecName.LZO;
                break;
            }
            case "snappy": {
                this.codec = CompressionCodecName.SNAPPY;
                break;
            }
            case "zstd": {
                this.codec = CompressionCodecName.ZSTD;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown compression type: %s", codecName));
            }
        }
        switch (logicalTypeNameForDecimals = writerOptions.get("store.parquet.writer.logical_type_for_decimals").toLowerCase()) {
            case "fixed_len_byte_array": {
                this.logicalTypeForDecimals = PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
                break;
            }
            case "binary": {
                this.logicalTypeForDecimals = PrimitiveType.PrimitiveTypeName.BINARY;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported logical type for decimals: %s\nSupported types: ['fixed_len_byte_array', 'binary']", codecName));
            }
        }
        this.enableDictionary = Boolean.parseBoolean(writerOptions.get("store.parquet.enable_dictionary_encoding"));
        this.useSingleFSBlock = Boolean.parseBoolean(writerOptions.get("store.parquet.writer.use_single_fs_block"));
        this.usePrimitiveTypesForDecimals = Boolean.parseBoolean(writerOptions.get("store.parquet.writer.use_primitive_types_for_decimals"));
        this.writerVersion = ParquetProperties.WriterVersion.fromString((String)writerOptions.get("store.parquet.writer.format_version"));
        if (this.useSingleFSBlock) {
            this.blockSize = (int)Math.ceil((double)this.blockSize / 65536.0) * 65536;
        }
    }

    private boolean containsComplexVectors(BatchSchema schema) {
        for (MaterializedField field : schema) {
            TypeProtos.MinorType type = field.getType().getMinorType();
            switch (type) {
                case MAP: 
                case DICT: 
                case LIST: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void updateSchema(VectorAccessible batch) throws IOException {
        TypedFieldId fieldId;
        if (this.batchSchema == null || !this.batchSchema.equals(batch.getSchema()) || this.containsComplexVectors(this.batchSchema)) {
            if (this.batchSchema != null) {
                this.flush(false);
            }
            this.batchSchema = batch.getSchema();
            this.newSchema();
        }
        if ((fieldId = batch.getValueVectorId(SchemaPath.getSimplePath("P_A_R_T_I_T_I_O_N_C_O_M_P_A_R_A_T_O_R"))) != null) {
            VectorWrapper<?> w = batch.getValueAccessorById(BitVector.class, fieldId.getFieldIds());
            this.setPartitionVector((BitVector)w.getValueVector());
        }
    }

    private void newSchema() {
        ArrayList<Type> types = new ArrayList<Type>();
        for (MaterializedField field : this.batchSchema) {
            this.pruneUnsupported(field);
            if (!this.supportsField(field)) continue;
            types.add(this.getType(field));
        }
        this.schema = new MessageType("root", types);
        int initialBlockBufferSize = this.schema.getColumns().size() > 0 ? Math.max(65536, this.blockSize / this.schema.getColumns().size() / 5) : 65536;
        int initialPageBufferSize = Math.max(65536, Math.min(this.pageSize + this.pageSize / 10, initialBlockBufferSize));
        DefaultV1ValuesWriterFactory valWriterFactory = this.writerVersion == ParquetProperties.WriterVersion.PARQUET_1_0 ? new DefaultV1ValuesWriterFactory() : new DefaultV2ValuesWriterFactory();
        ParquetProperties parquetProperties = ParquetProperties.builder().withPageSize(this.pageSize).withDictionaryEncoding(this.enableDictionary).withDictionaryPageSize(initialPageBufferSize).withAllocator((ByteBufferAllocator)new ParquetDirectByteBufferAllocator(this.oContext)).withValuesWriterFactory((ValuesWriterFactory)valWriterFactory).withWriterVersion(this.writerVersion).build();
        this.pageStore = new ParquetColumnChunkPageWriteStore(this.codecFactory.getCompressor(this.codec), this.schema, parquetProperties.getInitialSlabSize(), this.pageSize, parquetProperties.getAllocator(), parquetProperties.getColumnIndexTruncateLength(), parquetProperties.getPageWriteChecksumEnabled());
        this.store = this.writerVersion == ParquetProperties.WriterVersion.PARQUET_1_0 ? new ColumnWriteStoreV1(this.schema, (PageWriteStore)this.pageStore, parquetProperties) : new ColumnWriteStoreV2(this.schema, (PageWriteStore)this.pageStore, parquetProperties);
        MessageColumnIO columnIO = new ColumnIOFactory(false).getColumnIO(this.schema);
        this.consumer = columnIO.getRecordWriter(this.store);
        this.setUp(this.schema, this.consumer);
    }

    private void pruneUnsupported(MaterializedField field) {
        for (MaterializedField child : field.getChildren()) {
            this.pruneUnsupported(child);
            if (this.supportsField(child)) continue;
            field.removeChild(child);
        }
    }

    @Override
    public boolean supportsField(MaterializedField field) {
        return super.supportsField(field) && (field.getType().getMinorType() != TypeProtos.MinorType.MAP || field.getChildCount() > 0);
    }

    @Override
    protected PrimitiveType getPrimitiveType(MaterializedField field) {
        TypeProtos.MinorType minorType = field.getType().getMinorType();
        String name = field.getName();
        int length = ParquetTypeHelper.getLengthForMinorType(minorType);
        PrimitiveType.PrimitiveTypeName primitiveTypeName = ParquetTypeHelper.getPrimitiveTypeNameForMinorType(minorType);
        if (org.apache.drill.common.types.Types.isDecimalType(minorType)) {
            primitiveTypeName = this.logicalTypeForDecimals;
            if (this.usePrimitiveTypesForDecimals) {
                if (field.getPrecision() <= ParquetTypeHelper.getMaxPrecisionForPrimitiveType(PrimitiveType.PrimitiveTypeName.INT32)) {
                    primitiveTypeName = PrimitiveType.PrimitiveTypeName.INT32;
                } else if (field.getPrecision() <= ParquetTypeHelper.getMaxPrecisionForPrimitiveType(PrimitiveType.PrimitiveTypeName.INT64)) {
                    primitiveTypeName = PrimitiveType.PrimitiveTypeName.INT64;
                }
            }
            length = DecimalUtility.getMaxBytesSizeForPrecision(field.getPrecision());
        }
        Type.Repetition repetition = ParquetTypeHelper.getRepetitionForDataMode(field.getDataMode());
        OriginalType originalType = ParquetTypeHelper.getOriginalTypeForMinorType(minorType);
        DecimalMetadata decimalMetadata = ParquetTypeHelper.getDecimalMetadataForField(field);
        return new PrimitiveType(repetition, primitiveTypeName, length, name, originalType, decimalMetadata, null);
    }

    private Type getType(MaterializedField field) {
        TypeProtos.MinorType minorType = field.getType().getMinorType();
        TypeProtos.DataMode dataMode = field.getType().getMode();
        switch (minorType) {
            case MAP: {
                List<Type> types = this.getChildrenTypes(field);
                return new GroupType(dataMode == TypeProtos.DataMode.REPEATED ? Type.Repetition.REPEATED : Type.Repetition.OPTIONAL, field.getName(), types);
            }
            case DICT: {
                MaterializedField dictField = dataMode != TypeProtos.DataMode.REPEATED ? field : (MaterializedField)((List)field.getChildren()).get(0);
                List<Type> keyValueTypes = this.getChildrenTypes(dictField);
                GroupType keyValueGroup = new GroupType(Type.Repetition.REPEATED, GROUP_KEY_VALUE_NAME, keyValueTypes);
                if (dataMode == TypeProtos.DataMode.REPEATED) {
                    GroupType elementType = (GroupType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).as(OriginalType.MAP)).addField((Type)keyValueGroup)).named("list");
                    GroupType listGroup = new GroupType(Type.Repetition.REPEATED, "list", new Type[]{elementType});
                    return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).as(OriginalType.LIST)).addField((Type)listGroup)).named(field.getName());
                }
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).as(OriginalType.MAP)).addField((Type)keyValueGroup)).named(field.getName());
            }
            case LIST: {
                MaterializedField elementField = this.getDataField(field);
                Types.ListBuilder listBuilder = Types.list((Type.Repetition)(dataMode == TypeProtos.DataMode.OPTIONAL ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED));
                this.addElementType((Types.ListBuilder<GroupType>)listBuilder, elementField);
                GroupType listType = (GroupType)listBuilder.named(field.getName());
                return listType;
            }
            case NULL: {
                MaterializedField newField = field.withType(TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.INT).setMode(TypeProtos.DataMode.OPTIONAL).build());
                return this.getPrimitiveType(newField);
            }
        }
        return this.getPrimitiveType(field);
    }

    private List<Type> getChildrenTypes(MaterializedField field) {
        return field.getChildren().stream().map(this::getType).collect(Collectors.toList());
    }

    private MaterializedField getDataField(MaterializedField field) {
        return field.getChildren().stream().filter(child -> "$data$".equals(child.getName())).findAny().orElseThrow(() -> new NoSuchElementException(String.format("Failed to get elementField '%s' from list: %s", "$data$", field.getChildren())));
    }

    private void addElementType(Types.ListBuilder<GroupType> listBuilder, MaterializedField elementField) {
        if (elementField.getDataMode() == TypeProtos.DataMode.REPEATED) {
            Types.ListBuilder inner = Types.requiredList();
            if (elementField.getType().getMinorType() == TypeProtos.MinorType.MAP) {
                GroupType mapGroupType = new GroupType(Type.Repetition.REQUIRED, "element", this.getChildrenTypes(elementField));
                inner.element((Type)mapGroupType);
            } else {
                MaterializedField child2 = this.getDataField(elementField);
                this.addElementType((Types.ListBuilder<GroupType>)inner, child2);
            }
            listBuilder.setElementType((Type)inner.named("element"));
        } else {
            Type element = this.getType(elementField);
            if (element.isPrimitive()) {
                PrimitiveType primitiveElement = element.asPrimitiveType();
                element = new PrimitiveType(primitiveElement.getRepetition(), primitiveElement.getPrimitiveTypeName(), "element", primitiveElement.getOriginalType());
            } else {
                GroupType groupElement = element.asGroupType();
                element = new GroupType(groupElement.getRepetition(), "element", groupElement.getFields());
            }
            listBuilder.element(element);
        }
    }

    @Override
    public void checkForNewPartition(int index) {
        if (!this.hasPartitions) {
            return;
        }
        try {
            boolean newPartition = this.newPartition(index);
            if (newPartition) {
                this.flush(false);
                this.newSchema();
            }
        }
        catch (Exception e) {
            throw new DrillRuntimeException(e);
        }
    }

    private void flush(boolean cleanUp) throws IOException {
        block7: {
            try {
                if (this.recordCount > 0L) {
                    this.flushParquetFileWriter();
                    break block7;
                }
                if (!cleanUp || !this.empty || this.schema == null || this.schema.getFieldCount() <= 0) break block7;
                this.createParquetFileWriter();
                this.flushParquetFileWriter();
            }
            catch (Throwable throwable) {
                AutoCloseables.closeSilently(new AutoCloseable[]{this.pageStore});
                try {
                    this.store.close();
                }
                catch (Exception e) {
                    logger.warn("Error closing {}", (Object)this.store, (Object)e);
                }
                this.codecFactory.release();
                this.store = null;
                this.pageStore = null;
                ++this.index;
                throw throwable;
            }
        }
        AutoCloseables.closeSilently(new AutoCloseable[]{this.pageStore});
        try {
            this.store.close();
        }
        catch (Exception e) {
            logger.warn("Error closing {}", (Object)this.store, (Object)e);
        }
        this.codecFactory.release();
        this.store = null;
        this.pageStore = null;
        ++this.index;
    }

    private void checkBlockSizeReached() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.store.getBufferedSize();
            if (memSize > (long)this.blockSize) {
                logger.debug("Reached block size " + this.blockSize);
                this.flush(false);
                this.newSchema();
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, this.recordCount / 2L), 10000L);
            } else {
                float recordSize = (float)memSize / (float)this.recordCount;
                this.recordCountForNextMemCheck = Math.min(Math.max(100L, (this.recordCount + (long)((float)this.blockSize / recordSize)) / 2L), this.recordCount + 10000L);
            }
        }
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new MapParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedMapConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedMapParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedListConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedListParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewDictConverter(int fieldId, String fieldName, FieldReader reader) {
        return new DictParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public EventBasedRecordWriter.FieldConverter getNewRepeatedDictConverter(int fieldId, String fieldName, FieldReader reader) {
        return new RepeatedDictParquetConverter(fieldId, fieldName, reader);
    }

    @Override
    public void startRecord() throws IOException {
        if (CollectionUtils.isEmpty((Collection)this.schema.getFields())) {
            return;
        }
        this.consumer.startMessage();
    }

    @Override
    public void endRecord() throws IOException {
        if (CollectionUtils.isEmpty((Collection)this.schema.getFields())) {
            return;
        }
        this.consumer.endMessage();
        if (this.parquetFileWriter == null) {
            this.createParquetFileWriter();
        }
        this.empty = false;
        ++this.recordCount;
        this.checkBlockSizeReached();
    }

    @Override
    public void abort() throws IOException {
        ArrayList<String> errors = new ArrayList<String>();
        for (Path location : this.cleanUpLocations) {
            try {
                if (!this.fs.exists(location)) continue;
                this.fs.delete(location, true);
                logger.info("Aborting writer. Location [{}] on file system [{}] is deleted.", (Object)location.toUri().getPath(), (Object)this.fs.getUri());
            }
            catch (IOException e) {
                errors.add(location.toUri().getPath());
                logger.error("Failed to delete location [{}] on file system [{}].", new Object[]{location, this.fs.getUri(), e});
            }
        }
        if (!errors.isEmpty()) {
            throw new IOException(String.format("Failed to delete the following locations %s on file system [%s] during aborting writer", errors, this.fs.getUri()));
        }
    }

    @Override
    public void cleanup() throws IOException {
        this.flush(true);
    }

    private void createParquetFileWriter() throws IOException {
        Path path = new Path(this.location, this.prefix + "_" + this.index + ".parquet");
        Path firstCreatedPath = this.storageStrategy.createFileAndApply(this.fs, path);
        this.addCleanUpLocation(this.fs, firstCreatedPath);
        this.parquetFileWriter = this.useSingleFSBlock ? new ParquetFileWriter(this.conf, this.schema, path, ParquetFileWriter.Mode.OVERWRITE, (long)this.blockSize, 0) : new ParquetFileWriter(this.conf, this.schema, path, ParquetFileWriter.Mode.OVERWRITE);
        this.storageStrategy.applyToFile(this.fs, path);
        this.parquetFileWriter.start();
    }

    private void flushParquetFileWriter() throws IOException {
        this.parquetFileWriter.startBlock(this.recordCount);
        this.consumer.flush();
        this.store.flush();
        this.pageStore.flushToFileWriter(this.parquetFileWriter);
        this.recordCount = 0L;
        this.parquetFileWriter.endBlock();
        this.parquetFileWriter.end(this.extraMetaData);
        this.parquetFileWriter = null;
    }

    private void addCleanUpLocation(FileSystem fs, Path location) throws IOException {
        if (this.cleanUpLocations.isEmpty() || fs.isFile(this.cleanUpLocations.get(0))) {
            this.cleanUpLocations.add(location);
        }
    }

    public class MapParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        List<EventBasedRecordWriter.FieldConverter> converters;

        public MapParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converters = new ArrayList<EventBasedRecordWriter.FieldConverter>();
            int i = 0;
            for (String name : reader) {
                EventBasedRecordWriter.FieldConverter converter = EventBasedRecordWriter.getConverter(ParquetRecordWriter.this, i++, name, reader.reader(name));
                this.converters.add(converter);
            }
        }

        @Override
        public void writeField() throws IOException {
            if (!this.converters.isEmpty()) {
                ParquetRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
                ParquetRecordWriter.this.consumer.startGroup();
                for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                    converter.writeField();
                }
                ParquetRecordWriter.this.consumer.endGroup();
                ParquetRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
            }
        }
    }

    public class RepeatedMapParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        List<EventBasedRecordWriter.FieldConverter> converters;

        public RepeatedMapParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converters = new ArrayList<EventBasedRecordWriter.FieldConverter>();
            int i = 0;
            for (String name : reader) {
                EventBasedRecordWriter.FieldConverter converter = EventBasedRecordWriter.getConverter(ParquetRecordWriter.this, i++, name, reader.reader(name));
                this.converters.add(converter);
            }
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            while (this.reader.next()) {
                ParquetRecordWriter.this.consumer.startGroup();
                for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                    converter.writeField();
                }
                ParquetRecordWriter.this.consumer.endGroup();
            }
            ParquetRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }

        @Override
        public void writeListField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetRecordWriter.this.consumer.startField("list", 0);
            while (this.reader.next()) {
                ParquetRecordWriter.this.consumer.startGroup();
                ParquetRecordWriter.this.consumer.startField("element", 0);
                ParquetRecordWriter.this.consumer.startGroup();
                for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                    converter.writeField();
                }
                ParquetRecordWriter.this.consumer.endGroup();
                ParquetRecordWriter.this.consumer.endField("element", 0);
                ParquetRecordWriter.this.consumer.endGroup();
            }
            ParquetRecordWriter.this.consumer.endField("list", 0);
        }
    }

    public class RepeatedListParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final EventBasedRecordWriter.FieldConverter converter;

        RepeatedListParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converter = EventBasedRecordWriter.getConverter(ParquetRecordWriter.this, 0, "", reader.reader());
        }

        @Override
        public void writeField() throws IOException {
            ParquetRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetRecordWriter.this.consumer.startField("list", 0);
            while (this.reader.next()) {
                ParquetRecordWriter.this.consumer.startGroup();
                ParquetRecordWriter.this.consumer.startField("element", 0);
                this.converter.writeListField();
                ParquetRecordWriter.this.consumer.endField("element", 0);
                ParquetRecordWriter.this.consumer.endGroup();
            }
            ParquetRecordWriter.this.consumer.endField("list", 0);
            ParquetRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class DictParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        List<EventBasedRecordWriter.FieldConverter> converters;

        public DictParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.converters = new ArrayList<EventBasedRecordWriter.FieldConverter>();
            int i = 0;
            for (String name : reader) {
                EventBasedRecordWriter.FieldConverter converter = EventBasedRecordWriter.getConverter(ParquetRecordWriter.this, i++, name, reader.reader(name));
                this.converters.add(converter);
            }
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetRecordWriter.this.consumer.startGroup();
            ParquetRecordWriter.this.consumer.startField(ParquetRecordWriter.GROUP_KEY_VALUE_NAME, 0);
            while (this.reader.next()) {
                ParquetRecordWriter.this.consumer.startGroup();
                for (EventBasedRecordWriter.FieldConverter converter : this.converters) {
                    converter.writeField();
                }
                ParquetRecordWriter.this.consumer.endGroup();
            }
            ParquetRecordWriter.this.consumer.endField(ParquetRecordWriter.GROUP_KEY_VALUE_NAME, 0);
            ParquetRecordWriter.this.consumer.endGroup();
            ParquetRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }

    public class RepeatedDictParquetConverter
    extends EventBasedRecordWriter.FieldConverter {
        private final EventBasedRecordWriter.FieldConverter dictConverter;

        public RepeatedDictParquetConverter(int fieldId, String fieldName, FieldReader reader) {
            super(fieldId, fieldName, reader);
            this.dictConverter = new DictParquetConverter(0, "element", reader.reader());
        }

        @Override
        public void writeField() throws IOException {
            if (this.reader.size() == 0) {
                return;
            }
            ParquetRecordWriter.this.consumer.startField(this.fieldName, this.fieldId);
            ParquetRecordWriter.this.consumer.startGroup();
            ParquetRecordWriter.this.consumer.startField("list", 0);
            while (this.reader.next()) {
                ParquetRecordWriter.this.consumer.startGroup();
                this.dictConverter.writeField();
                ParquetRecordWriter.this.consumer.endGroup();
            }
            ParquetRecordWriter.this.consumer.endField("list", 0);
            ParquetRecordWriter.this.consumer.endGroup();
            ParquetRecordWriter.this.consumer.endField(this.fieldName, this.fieldId);
        }
    }
}

