/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import java.io.IOException;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.ExecutorFragmentContext;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.ScanBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.store.dfs.DrillFileSystem;
import org.apache.drill.exec.store.parquet.AbstractParquetRowGroupScan;
import org.apache.drill.exec.store.parquet.AbstractParquetScanBatchCreator;
import org.apache.drill.exec.store.parquet.ParquetRowGroupScan;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class ParquetScanBatchCreator
extends AbstractParquetScanBatchCreator
implements BatchCreator<ParquetRowGroupScan> {
    public ScanBatch getBatch(ExecutorFragmentContext context, ParquetRowGroupScan rowGroupScan, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkArgument(children.isEmpty());
        OperatorContext oContext = context.newOperatorContext(rowGroupScan);
        return this.getBatch(context, (AbstractParquetRowGroupScan)rowGroupScan, oContext);
    }

    @Override
    protected AbstractParquetScanBatchCreator.AbstractDrillFileSystemManager getDrillFileSystemCreator(OperatorContext operatorContext, OptionManager optionManager) {
        return new ParquetDrillFileSystemManager(operatorContext, optionManager.getOption((String)"store.parquet.reader.pagereader.async").bool_val);
    }

    public static class ParquetDrillFileSystemManager
    extends AbstractParquetScanBatchCreator.AbstractDrillFileSystemManager {
        private final boolean useAsyncPageReader;
        private DrillFileSystem fs;

        public ParquetDrillFileSystemManager(OperatorContext operatorContext, boolean useAsyncPageReader) {
            super(operatorContext);
            this.useAsyncPageReader = useAsyncPageReader;
        }

        @Override
        protected DrillFileSystem get(Configuration config, Path path) throws ExecutionSetupException {
            if (this.fs == null) {
                try {
                    this.fs = this.useAsyncPageReader ? this.operatorContext.newNonTrackingFileSystem(config) : this.operatorContext.newFileSystem(config);
                }
                catch (IOException e) {
                    throw new ExecutionSetupException(String.format("Failed to create DrillFileSystem: %s", e.getMessage()), e);
                }
            }
            return this.fs;
        }
    }
}

