/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.FormatPluginConfig;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.AbstractWriter;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.StorageStrategy;
import org.apache.drill.exec.store.parquet.ParquetFormatConfig;
import org.apache.drill.exec.store.parquet.ParquetFormatPlugin;

@JsonTypeName(value="parquet-writer")
public class ParquetWriter
extends AbstractWriter {
    public static final int WRITER_VERSION = 3;
    public static final String OPERATOR_TYPE = "PARQUET_WRITER";
    private final String location;
    private final List<String> partitionColumns;
    private final ParquetFormatPlugin formatPlugin;

    @JsonCreator
    public ParquetWriter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="location") String location, @JsonProperty(value="partitionColumns") List<String> partitionColumns, @JsonProperty(value="storageStrategy") StorageStrategy storageStrategy, @JsonProperty(value="storage") StoragePluginConfig storageConfig, @JacksonInject StoragePluginRegistry engineRegistry) throws IOException, ExecutionSetupException {
        super(child);
        this.formatPlugin = engineRegistry.resolveFormat(storageConfig, new ParquetFormatConfig(), ParquetFormatPlugin.class);
        this.location = location;
        this.partitionColumns = partitionColumns;
        this.setStorageStrategy(storageStrategy);
    }

    public ParquetWriter(PhysicalOperator child, String location, List<String> partitionColumns, ParquetFormatPlugin formatPlugin) {
        super(child);
        this.formatPlugin = formatPlugin;
        this.location = location;
        this.partitionColumns = partitionColumns;
    }

    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="storage")
    public StoragePluginConfig getStorageConfig() {
        return this.formatPlugin.getStorageConfig();
    }

    @JsonProperty(value="partitionColumns")
    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public FormatPluginConfig getFormatConfig() {
        return this.formatPlugin.getConfig();
    }

    @JsonIgnore
    public ParquetFormatPlugin getFormatPlugin() {
        return this.formatPlugin;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        ParquetWriter writer = new ParquetWriter(child, this.location, this.partitionColumns, this.formatPlugin);
        writer.setStorageStrategy(this.getStorageStrategy());
        return writer;
    }

    @Override
    public String getOperatorType() {
        return OPERATOR_TYPE;
    }

    public String toString() {
        return "ParquetWriter[location=" + this.location + ", storageStrategy=" + this.getStorageStrategy() + ", partitionColumns=" + this.partitionColumns + "]";
    }
}

