/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.drill.exec.store.dfs.ReadEntryFromHDFS;
import org.apache.drill.exec.store.dfs.easy.FileWork;
import org.apache.drill.exec.store.parquet.RowGroupReadEntry;
import org.apache.drill.exec.store.parquet.metadata.MetadataBase;
import org.apache.drill.exec.store.schedule.CompleteWork;
import org.apache.drill.exec.store.schedule.EndpointByteMap;
import org.apache.hadoop.fs.Path;

public class RowGroupInfo
extends ReadEntryFromHDFS
implements CompleteWork,
FileWork {
    private EndpointByteMap byteMap;
    private int rowGroupIndex;
    private List<? extends MetadataBase.ColumnMetadata> columns;
    private long rowCount;
    private long numRecordsToRead;

    @JsonCreator
    public RowGroupInfo(@JsonProperty(value="path") Path path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="rowGroupIndex") int rowGroupIndex, long rowCount) {
        super(path, start, length);
        this.rowGroupIndex = rowGroupIndex;
        this.rowCount = rowCount;
        this.numRecordsToRead = rowCount;
    }

    public RowGroupReadEntry getRowGroupReadEntry() {
        return new RowGroupReadEntry(this.getPath(), this.getStart(), this.getLength(), this.rowGroupIndex, this.getNumRecordsToRead());
    }

    public int getRowGroupIndex() {
        return this.rowGroupIndex;
    }

    @Override
    public int compareTo(CompleteWork o) {
        return Long.compare(this.getTotalBytes(), o.getTotalBytes());
    }

    @Override
    public long getTotalBytes() {
        return this.getLength();
    }

    @Override
    public EndpointByteMap getByteMap() {
        return this.byteMap;
    }

    public long getNumRecordsToRead() {
        return this.numRecordsToRead;
    }

    public void setNumRecordsToRead(long numRecords) {
        this.numRecordsToRead = numRecords;
    }

    public void setEndpointByteMap(EndpointByteMap byteMap) {
        this.byteMap = byteMap;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public List<? extends MetadataBase.ColumnMetadata> getColumns() {
        return this.columns;
    }

    public void setColumns(List<? extends MetadataBase.ColumnMetadata> columns) {
        this.columns = columns;
    }
}

