/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.drill.exec.store.dfs.ReadEntryFromHDFS;
import org.apache.hadoop.fs.Path;

public class RowGroupReadEntry
extends ReadEntryFromHDFS {
    private int rowGroupIndex;
    private long numRecordsToRead;

    @JsonCreator
    public RowGroupReadEntry(@JsonProperty(value="path") Path path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="rowGroupIndex") int rowGroupIndex, @JsonProperty(value="numRecordsToRead") long numRecordsToRead) {
        super(path, start, length);
        this.rowGroupIndex = rowGroupIndex;
        this.numRecordsToRead = numRecordsToRead;
    }

    @JsonIgnore
    public RowGroupReadEntry getRowGroupReadEntry() {
        return new RowGroupReadEntry(this.getPath(), this.getStart(), this.getLength(), this.rowGroupIndex, this.numRecordsToRead);
    }

    public int getRowGroupIndex() {
        return this.rowGroupIndex;
    }

    public long getNumRecordsToRead() {
        return this.numRecordsToRead;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.rowGroupIndex == -1 || this.numRecordsToRead == 0L;
    }
}

