/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.vector.DateVector;
import org.apache.drill.exec.vector.IntervalVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

class FixedByteAlignedReader<V extends ValueVector>
extends ColumnReader<V> {
    protected DrillBuf bytebuf;

    FixedByteAlignedReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
    }

    @Override
    protected void readField(long recordsToReadInThisPass) {
        this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
        this.readStartInBytes = this.pageReader.readPosInBytes;
        this.readLengthInBits = this.recordsReadInThisIteration * (long)this.dataTypeLengthInBits;
        this.readLength = (int)Math.ceil((double)this.readLengthInBits / 8.0);
        this.bytebuf = this.pageReader.pageData;
        this.writeData();
    }

    protected void writeData() {
        this.vectorData.writeBytes(this.bytebuf, (int)this.readStartInBytes, (int)this.readLength);
    }

    public static class IntervalReader
    extends ConvertedReader<IntervalVector> {
        IntervalReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, IntervalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        void addNext(int start, int index) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                byte[] input = valReader.readBytes().getBytes();
                ((IntervalVector)this.valueVec).getMutator().setSafe(index, ParquetReaderUtility.getIntFromLEBytes(input, 0), ParquetReaderUtility.getIntFromLEBytes(input, 4), ParquetReaderUtility.getIntFromLEBytes(input, 8));
            } else {
                ((IntervalVector)this.valueVec).getMutator().setSafe(index, this.bytebuf.getInt(start), this.bytebuf.getInt(start + 4), this.bytebuf.getInt(start + 8));
            }
        }
    }

    public static class CorruptionDetectingDateReader
    extends ConvertedReader<DateVector> {
        private final DateVector.Mutator mutator;

        CorruptionDetectingDateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, DateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.mutator = v.getMutator();
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = CorruptionDetectingDateReader.readIntLittleEndian(this.bytebuf, start);
            }
            if (intValue > ParquetReaderUtility.DATE_CORRUPTION_THRESHOLD) {
                this.mutator.set(index, ((long)intValue - 4881176L) * 86400000L);
            } else {
                this.mutator.set(index, (long)intValue * 86400000L);
            }
        }
    }

    public static class CorruptDateReader
    extends ConvertedReader<DateVector> {
        private final DateVector.Mutator mutator;

        CorruptDateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, DateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.mutator = v.getMutator();
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = CorruptDateReader.readIntLittleEndian(this.bytebuf, start);
            }
            this.mutator.set(index, ((long)intValue - 4881176L) * 86400000L);
        }
    }

    public static class DateReader
    extends ConvertedReader<DateVector> {
        private final DateVector.Mutator mutator;

        DateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, DateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.mutator = v.getMutator();
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = DateReader.readIntLittleEndian(this.bytebuf, start);
            }
            this.mutator.set(index, (long)intValue * 86400000L);
        }
    }

    public static abstract class ConvertedReader<V extends ValueVector>
    extends FixedByteAlignedReader<V> {
        protected int dataTypeLengthInBytes;

        ConvertedReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        public void writeData() {
            this.dataTypeLengthInBytes = (int)Math.ceil((double)this.dataTypeLengthInBits / 8.0);
            int i = 0;
            while ((long)i < this.recordsReadInThisIteration) {
                this.addNext((int)this.readStartInBytes + i * this.dataTypeLengthInBytes, i + this.valuesReadInCurrentPass);
                ++i;
            }
        }

        abstract void addNext(int var1, int var2);
    }

    public static class FixedBinaryReader
    extends FixedByteAlignedReader<VariableWidthVector> {
        VariableWidthVector castedVector;

        FixedBinaryReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, VariableWidthVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, true, v, schemaElement);
            this.castedVector = v;
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            super.readField(recordsToReadInThisPass);
            int byteLength = this.dataTypeLengthInBits / 8;
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                this.castedVector.getMutator().setValueLengthSafe(this.valuesReadInCurrentPass + i, byteLength);
                ++i;
            }
        }
    }
}

