/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import java.io.IOException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.store.parquet.columnreaders.VarLengthColumn;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.complex.RepeatedValueVector;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public class FixedWidthRepeatedReader
extends VarLengthColumn<RepeatedValueVector> {
    ColumnReader<?> dataReader;
    int dataTypeLengthInBytes;
    int valuesToRead;
    int repeatedGroupsReadInCurrentPass;
    int repeatedValuesInCurrentList;
    int definitionLevelsRead;
    boolean notFishedReadingList;
    byte[] leftOverBytes;

    FixedWidthRepeatedReader(ParquetRecordReader parentReader, ColumnReader<?> dataReader, int dataTypeLengthInBytes, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, RepeatedValueVector valueVector, SchemaElement schemaElement) throws ExecutionSetupException {
        super(parentReader, descriptor, columnChunkMetaData, fixedLength, valueVector, schemaElement);
        this.dataTypeLengthInBytes = dataTypeLengthInBytes;
        this.dataReader = dataReader;
        this.dataReader.pageReader.clear();
        this.dataReader.pageReader = this.pageReader;
        this.notFishedReadingList = false;
    }

    @Override
    public void reset() {
        this.bytesReadInCurrentPass = 0;
        this.valuesReadInCurrentPass = 0;
        this.pageReader.valuesReadyToRead = 0;
        this.dataReader.vectorData = ((BaseDataValueVector)BaseDataValueVector.class.cast(((RepeatedValueVector)this.valueVec).getDataVector())).getBuffer();
        this.dataReader.valuesReadInCurrentPass = 0;
        this.repeatedGroupsReadInCurrentPass = 0;
    }

    @Override
    public int getRecordsReadInCurrentPass() {
        return this.repeatedGroupsReadInCurrentPass;
    }

    @Override
    protected void readField(long recordsToRead) {
    }

    @Override
    public boolean skipReadyToReadPositionUpdate() {
        return false;
    }

    @Override
    public void updateReadyToReadPosition() {
        this.valuesToRead += this.repeatedValuesInCurrentList;
        this.pageReader.valuesReadyToRead += this.repeatedValuesInCurrentList;
        ++this.repeatedGroupsReadInCurrentPass;
        this.currDictVal = null;
        if (!this.notFishedReadingList) {
            this.repeatedValuesInCurrentList = -1;
        }
    }

    @Override
    public void updatePosition() {
        this.pageReader.readPosInBytes += (long)this.dataTypeLengthInBits;
        this.bytesReadInCurrentPass += this.dataTypeLengthInBits;
        ++this.valuesReadInCurrentPass;
    }

    @Override
    public void hitRowGroupEnd() {
        this.pageReader.valuesReadyToRead = 0;
        this.definitionLevelsRead = 0;
    }

    @Override
    public void postPageRead() {
        super.postPageRead();
        if (!this.notFishedReadingList) {
            this.repeatedValuesInCurrentList = -1;
        }
        this.definitionLevelsRead = 0;
    }

    @Override
    protected int totalValuesReadAndReadyToReadInPage() {
        if (this.notFishedReadingList) {
            return this.definitionLevelsRead - this.repeatedValuesInCurrentList;
        }
        return this.definitionLevelsRead;
    }

    @Override
    protected boolean checkVectorCapacityReached() {
        boolean doneReading = super.checkVectorCapacityReached();
        if (doneReading) {
            return true;
        }
        return this.valuesReadInCurrentPass + this.pageReader.valuesReadyToRead + this.repeatedValuesInCurrentList >= ((RepeatedValueVector)this.valueVec).getValueCapacity();
    }

    @Override
    protected boolean readAndStoreValueSizeInformation() {
        int numLeftoverVals = 0;
        if (this.notFishedReadingList) {
            numLeftoverVals = this.repeatedValuesInCurrentList;
            this.readRecords(numLeftoverVals);
            this.notFishedReadingList = false;
            this.pageReader.valuesReadyToRead = 0;
            try {
                boolean stopReading = this.readPage();
                if (stopReading) {
                    return false;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error reading parquet repeated column.", e);
            }
        }
        if (this.currDefLevel == -1) {
            this.currDefLevel = this.pageReader.definitionLevels.nextInt();
            ++this.definitionLevelsRead;
        }
        if (this.columnDescriptor.getMaxDefinitionLevel() == this.currDefLevel) {
            if (this.repeatedValuesInCurrentList == -1 || this.notFishedReadingList) {
                int repLevel;
                this.repeatedValuesInCurrentList = 1;
                do {
                    if ((repLevel = this.pageReader.repetitionLevels.nextInt()) <= 0) continue;
                    ++this.repeatedValuesInCurrentList;
                    this.currDefLevel = this.pageReader.definitionLevels.nextInt();
                    ++this.definitionLevelsRead;
                    if (this.definitionLevelsRead != this.pageReader.pageValueCount || (long)(this.totalValuesRead + this.pageReader.valuesReadyToRead + this.repeatedValuesInCurrentList) == this.columnChunkMetaData.getValueCount()) continue;
                    this.notFishedReadingList = true;
                    return true;
                } while (repLevel != 0);
            }
        } else {
            this.repeatedValuesInCurrentList = 0;
        }
        UInt4Vector offsets = ((RepeatedValueVector)this.valueVec).getOffsetVector();
        offsets.getMutator().setSafe(this.repeatedGroupsReadInCurrentPass + 1, offsets.getAccessor().get(this.repeatedGroupsReadInCurrentPass));
        this.dataTypeLengthInBits = this.repeatedValuesInCurrentList * this.dataTypeLengthInBytes;
        return false;
    }

    @Override
    protected void readRecords(int valuesToRead) {
        if (valuesToRead == 0) {
            return;
        }
        this.dataReader.valuesReadInCurrentPass = 0;
        this.dataReader.readValues(valuesToRead);
        this.valuesReadInCurrentPass += valuesToRead;
        ((RepeatedValueVector)this.valueVec).getMutator().setValueCount(this.repeatedGroupsReadInCurrentPass);
        ((RepeatedValueVector)this.valueVec).getDataVector().getMutator().setValueCount(this.valuesReadInCurrentPass);
    }

    @Override
    public int capacity() {
        return ((BaseDataValueVector)BaseDataValueVector.class.cast(((RepeatedValueVector)this.valueVec).getDataVector())).getBuffer().capacity();
    }

    @Override
    public void clear() {
        super.clear();
        this.dataReader.clear();
    }
}

