/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.NullableColumnReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.vector.NullableBigIntVector;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.NullableFloat4Vector;
import org.apache.drill.exec.vector.NullableFloat8Vector;
import org.apache.drill.exec.vector.NullableIntVector;
import org.apache.drill.exec.vector.NullableIntervalVector;
import org.apache.drill.exec.vector.NullableTimeStampVector;
import org.apache.drill.exec.vector.NullableTimeVector;
import org.apache.drill.exec.vector.NullableUInt4Vector;
import org.apache.drill.exec.vector.NullableUInt8Vector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;
import org.apache.drill.shaded.guava.com.google.common.primitives.Longs;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;

public class NullableFixedByteAlignedReaders {

    public static class NullableIntervalReader
    extends NullableConvertedReader<NullableIntervalVector> {
        NullableIntervalReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableIntervalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        void addNext(int start, int index) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                byte[] input = valReader.readBytes().getBytes();
                ((NullableIntervalVector)this.valueVec).getMutator().setSafe(index, 1, ParquetReaderUtility.getIntFromLEBytes(input, 0), ParquetReaderUtility.getIntFromLEBytes(input, 4), ParquetReaderUtility.getIntFromLEBytes(input, 8));
            } else {
                ((NullableIntervalVector)this.valueVec).getMutator().set(index, 1, this.bytebuf.getInt(start), this.bytebuf.getInt(start + 4), this.bytebuf.getInt(start + 8));
            }
        }
    }

    public static class CorruptionDetectingNullableDateReader
    extends NullableConvertedReader<NullableDateVector> {
        CorruptionDetectingNullableDateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableDateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = CorruptionDetectingNullableDateReader.readIntLittleEndian(this.bytebuf, start);
            }
            if (intValue > ParquetReaderUtility.DATE_CORRUPTION_THRESHOLD) {
                ((NullableDateVector)this.valueVec).getMutator().set(index, ((long)intValue - 4881176L) * 86400000L);
            } else {
                ((NullableDateVector)this.valueVec).getMutator().set(index, (long)intValue * 86400000L);
            }
        }
    }

    public static class NullableCorruptDateReader
    extends NullableConvertedReader<NullableDateVector> {
        NullableCorruptDateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableDateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = NullableCorruptDateReader.readIntLittleEndian(this.bytebuf, start);
            }
            ((NullableDateVector)this.valueVec).getMutator().set(index, ((long)intValue - 4881176L) * 86400000L);
        }
    }

    public static class NullableDateReader
    extends NullableConvertedReader<NullableDateVector> {
        NullableDateReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableDateVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        void addNext(int start, int index) {
            int intValue;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                intValue = valReader.readInteger();
            } else {
                intValue = NullableDateReader.readIntLittleEndian(this.bytebuf, start);
            }
            ((NullableDateVector)this.valueVec).getMutator().set(index, (long)intValue * 86400000L);
        }
    }

    static abstract class NullableConvertedReader<V extends ValueVector>
    extends NullableFixedByteAlignedReader<V> {
        protected int dataTypeLengthInBytes;

        NullableConvertedReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.bytebuf = this.pageReader.pageData;
            this.dataTypeLengthInBytes = (int)Math.ceil((double)this.dataTypeLengthInBits / 8.0);
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                this.addNext((int)this.readStartInBytes + i * this.dataTypeLengthInBytes, i + this.valuesReadInCurrentPass);
                ++i;
            }
        }

        abstract void addNext(int var1, int var2);
    }

    static class NullableDictionaryFloat8Reader
    extends NullableColumnReader<NullableFloat8Vector> {
        NullableDictionaryFloat8Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableFloat8Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableFloat8Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readDouble());
                ++i;
            }
        }
    }

    static class NullableDictionaryFloat4Reader
    extends NullableColumnReader<NullableFloat4Vector> {
        NullableDictionaryFloat4Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableFloat4Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableFloat4Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readFloat());
                ++i;
            }
        }
    }

    static class NullableDictionaryVarDecimalReader
    extends NullableColumnReader<NullableVarDecimalVector> {
        NullableDictionaryVarDecimalReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableVarDecimalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            switch (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    if (this.usingDictionary) {
                        int i = 0;
                        while ((long)i < recordsToReadInThisPass) {
                            byte[] bytes = Ints.toByteArray(this.pageReader.getDictionaryValueReader().readInteger());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < recordsToReadInThisPass) {
                            byte[] bytes = Ints.toByteArray(this.pageReader.getValueReader().readInteger());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    }
                    break;
                }
                case INT64: {
                    if (this.usingDictionary) {
                        int i = 0;
                        while ((long)i < recordsToReadInThisPass) {
                            byte[] bytes = Longs.toByteArray(this.pageReader.getDictionaryValueReader().readLong());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < recordsToReadInThisPass) {
                            byte[] bytes = Longs.toByteArray(this.pageReader.getValueReader().readLong());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    }
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    if (this.usingDictionary) {
                        this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                        NullableVarDecimalVector.Mutator mutator = ((NullableVarDecimalVector)this.valueVec).getMutator();
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            Binary currDictValToWrite = this.pageReader.getDictionaryValueReader().readBytes();
                            mutator.setSafe(this.valuesReadInCurrentPass + i, currDictValToWrite.toByteBuffer().slice(), 0, currDictValToWrite.length());
                            ++i;
                        }
                        int writerIndex = ((NullableVarDecimalVector)this.valueVec).getBuffer().writerIndex();
                        ((NullableVarDecimalVector)this.valueVec).getBuffer().setIndex(0, writerIndex + (int)this.readLength);
                        break;
                    }
                    int i = 0;
                    while ((long)i < recordsToReadInThisPass) {
                        Binary valueToWrite = this.pageReader.getValueReader().readBytes();
                        ((NullableVarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valueToWrite.toByteBuffer().slice(), 0, valueToWrite.length());
                        ++i;
                    }
                    break;
                }
            }
        }

        private void setValueBytes(int i, byte[] bytes) {
            ((NullableVarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, bytes, 0, bytes.length);
        }
    }

    static class NullableDictionaryTimeStampMicrosReader
    extends NullableColumnReader<NullableTimeStampVector> {
        NullableDictionaryTimeStampMicrosReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableTimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableTimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong() / 1000L);
                ++i;
            }
        }
    }

    static class NullableDictionaryTimeStampReader
    extends NullableColumnReader<NullableTimeStampVector> {
        NullableDictionaryTimeStampReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableTimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableTimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                ++i;
            }
        }
    }

    static class NullableDictionaryUInt8Reader
    extends NullableColumnReader<NullableUInt8Vector> {
        NullableDictionaryUInt8Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableUInt8Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableUInt8Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                ++i;
            }
        }
    }

    static class NullableDictionaryBigIntReader
    extends NullableColumnReader<NullableBigIntVector> {
        NullableDictionaryBigIntReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableBigIntVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableBigIntVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                ++i;
            }
        }
    }

    static class NullableDictionaryTimeMicrosReader
    extends NullableColumnReader<NullableTimeVector> {
        NullableDictionaryTimeMicrosReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableTimeVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableTimeVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, (int)(valReader.readLong() / 1000L));
                ++i;
            }
        }
    }

    static class NullableDictionaryTimeReader
    extends NullableColumnReader<NullableTimeVector> {
        NullableDictionaryTimeReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableTimeVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableTimeVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                ++i;
            }
        }
    }

    static class NullableDictionaryUInt4Reader
    extends NullableColumnReader<NullableUInt4Vector> {
        NullableDictionaryUInt4Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableUInt4Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableUInt4Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                ++i;
            }
        }
    }

    static class NullableDictionaryIntReader
    extends NullableColumnReader<NullableIntVector> {
        NullableDictionaryIntReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableIntVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((NullableIntVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                ++i;
            }
        }
    }

    static class NullableFixedBinaryAsTimeStampReader
    extends NullableFixedByteAlignedReader<NullableTimeStampVector> {
        NullableFixedBinaryAsTimeStampReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableTimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
            this.dataTypeLengthInBits = 64;
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.bytebuf = this.pageReader.pageData;
            ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                Binary binaryTimeStampValue = valReader.readBytes();
                ((NullableTimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, ParquetReaderUtility.NanoTimeUtils.getDateTimeValueFromBinary(binaryTimeStampValue, true));
                ++i;
            }
        }
    }

    static class NullableFixedBinaryReader
    extends NullableFixedByteAlignedReader<NullableVarBinaryVector> {
        NullableFixedBinaryReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, NullableVarBinaryVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.bytebuf = this.pageReader.pageData;
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                NullableVarBinaryVector.Mutator mutator = ((NullableVarBinaryVector)this.valueVec).getMutator();
                int i = 0;
                while ((long)i < recordsToReadInThisPass) {
                    Binary currDictValToWrite = valReader.readBytes();
                    ByteBuffer buf = currDictValToWrite.toByteBuffer();
                    mutator.setSafe(this.valuesReadInCurrentPass + i, buf, buf.position(), currDictValToWrite.length());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
                int byteLength = this.dataTypeLengthInBits / 8;
                int i = 0;
                while ((long)i < recordsToReadInThisPass) {
                    ((NullableVarBinaryVector)this.valueVec).getMutator().setValueLengthSafe(this.valuesReadInCurrentPass + i, byteLength);
                    ++i;
                }
            }
        }
    }

    static class NullableFixedByteAlignedReader<V extends ValueVector>
    extends NullableColumnReader<V> {
        protected DrillBuf bytebuf;

        NullableFixedByteAlignedReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, V v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.bytebuf = this.pageReader.pageData;
            this.vectorData.writeBytes(this.bytebuf, (int)this.readStartInBytes, (int)this.readLength);
        }
    }
}

