/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DrillBuf;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.store.parquet.DataPageHeaderInfoProvider;
import org.apache.drill.exec.store.parquet.ParquetFormatPlugin;
import org.apache.drill.exec.store.parquet.ParquetReaderStats;
import org.apache.drill.exec.store.parquet.columnreaders.ColumnReader;
import org.apache.drill.exec.util.filereader.BufferedDirectBufInputStream;
import org.apache.drill.exec.util.filereader.DirectBufInputStream;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.base.Stopwatch;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.dictionary.DictionaryValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.ParquetDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageReader {
    static final Logger logger = LoggerFactory.getLogger(PageReader.class);
    public static final ParquetMetadataConverter METADATA_CONVERTER = ParquetFormatPlugin.parquetMetadataConverter;
    protected final ColumnReader<?> parentColumnReader;
    protected final DirectBufInputStream dataReader;
    protected DrillBuf pageData;
    long readyToReadPosInBytes;
    long readPosInBytes;
    int valuesReadyToRead;
    int valuesRead;
    int byteLength;
    IntIterator definitionLevels;
    IntIterator repetitionLevels;
    private ValuesReader valueReader;
    private ValuesReader dictionaryLengthDeterminingReader;
    private ValuesReader dictionaryValueReader;
    Dictionary dictionary;
    PageHeader pageHeader;
    int pageValueCount = -1;
    protected FSDataInputStream inputStream;
    DrillBuf dictData;
    protected final CompressionCodecFactory codecFactory;
    protected final CompressionCodecName codecName;
    protected final BufferAllocator allocator;
    protected final ColumnDescriptor columnDescriptor;
    protected final ColumnChunkMetaData columnChunkMetaData;
    protected final String fileName;
    protected final ParquetReaderStats stats;
    private final boolean useBufferedReader;
    private final int scanBufferSize;
    private final boolean useFadvise;
    private final boolean enforceTotalSize;
    protected final String debugName;
    private DataPageHeaderInfoProvider dataPageInfo;

    PageReader(ColumnReader<?> columnReader, FileSystem fs, Path path) throws ExecutionSetupException {
        this.parentColumnReader = columnReader;
        this.columnDescriptor = this.parentColumnReader.getColumnDescriptor();
        this.columnChunkMetaData = columnReader.columnChunkMetaData;
        this.codecFactory = this.parentColumnReader.parentReader.getCodecFactory();
        this.codecName = this.parentColumnReader.columnChunkMetaData.getCodec();
        this.allocator = this.parentColumnReader.parentReader.getOperatorContext().getAllocator();
        this.stats = this.parentColumnReader.parentReader.parquetReaderStats;
        this.fileName = path.toString();
        this.debugName = this.parentColumnReader.parentReader.getFragmentContext().getFragIdString() + ":" + this.parentColumnReader.parentReader.getOperatorContext().getStats().getId() + this.parentColumnReader.columnChunkMetaData.toString();
        try {
            this.inputStream = fs.open(path);
            this.useBufferedReader = this.parentColumnReader.parentReader.useBufferedReader;
            this.scanBufferSize = this.parentColumnReader.parentReader.bufferedReadSize;
            this.useFadvise = this.parentColumnReader.parentReader.useFadvise;
            this.enforceTotalSize = this.parentColumnReader.parentReader.enforceTotalSize;
            this.dataReader = this.useBufferedReader ? new BufferedDirectBufInputStream((InputStream)this.inputStream, this.allocator, path.getName(), this.columnChunkMetaData.getStartingPos(), this.columnChunkMetaData.getTotalSize(), this.scanBufferSize, this.enforceTotalSize, this.useFadvise) : new DirectBufInputStream((InputStream)this.inputStream, this.allocator, path.getName(), this.columnChunkMetaData.getStartingPos(), this.columnChunkMetaData.getTotalSize(), this.enforceTotalSize, this.useFadvise);
        }
        catch (IOException e) {
            throw new ExecutionSetupException("Error opening or reading metadata for parquet file at location: " + path.getName(), e);
        }
    }

    protected void throwUserException(Exception e, String msg) throws UserException {
        UserException ex = UserException.dataReadError(e).message(msg, new Object[0]).pushContext("Row Group Start: ", this.columnChunkMetaData.getStartingPos()).pushContext("Column: ", this.parentColumnReader.schemaElement.getName()).pushContext("File: ", this.fileName).build(logger);
        throw ex;
    }

    protected void init() throws IOException {
        this.dataReader.init();
    }

    protected void skip(long n) throws IOException {
        assert (n >= 0L);
        while (n > 0L) {
            long skipped = this.dataReader.skip(n);
            if (skipped > 0L) {
                n -= skipped;
                continue;
            }
            DrillBuf skipBuf = this.dataReader.getNext((int)n);
            if (skipBuf != null) {
                skipBuf.release();
                continue;
            }
            throw new EOFException("End of file reached.");
        }
    }

    protected void loadDictionary() throws IOException {
        assert (this.pageHeader.getType() == PageType.DICTIONARY_PAGE);
        assert (this.dictionary == null);
        this.dictData = this.codecName == CompressionCodecName.UNCOMPRESSED ? this.readUncompressedPage() : this.readCompressedPageV1();
        DictionaryPage page = new DictionaryPage(PageReader.asBytesInput(this.dictData, 0, this.pageHeader.uncompressed_page_size), this.pageHeader.uncompressed_page_size, this.pageHeader.dictionary_page_header.num_values, Encoding.valueOf((String)this.pageHeader.dictionary_page_header.encoding.name()));
        this.dictionary = page.getEncoding().initDictionary(this.columnDescriptor, page);
    }

    protected DrillBuf readUncompressedPage() throws IOException {
        int outputSize = this.pageHeader.getUncompressed_page_size();
        long start = this.dataReader.getPos();
        Stopwatch timer = Stopwatch.createStarted();
        DrillBuf outputPageData = this.dataReader.getNext(outputSize);
        long timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
        if (logger.isTraceEnabled()) {
            logger.trace("Col: {}  readPos: {}  Uncompressed_size: {}  pageData: {}", new Object[]{this.columnChunkMetaData.toString(), this.dataReader.getPos(), outputSize, ByteBufUtil.hexDump(outputPageData)});
        }
        this.updateStats(this.pageHeader, "Page Read", start, timeToRead, outputSize, outputSize);
        return outputPageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DrillBuf readCompressedPageV1() throws IOException {
        Stopwatch timer = Stopwatch.createUnstarted();
        int inputSize = this.pageHeader.getCompressed_page_size();
        int outputSize = this.pageHeader.getUncompressed_page_size();
        long start = this.dataReader.getPos();
        DrillBuf inputPageData = null;
        DrillBuf outputPageData = this.allocator.buffer(outputSize);
        try {
            timer.start();
            inputPageData = this.dataReader.getNext(inputSize);
            long timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
            this.updateStats(this.pageHeader, "Page Read", start, timeToRead, inputSize, inputSize);
            timer.reset();
            timer.start();
            start = this.dataReader.getPos();
            CompressionCodecName codecName = this.columnChunkMetaData.getCodec();
            CompressionCodecFactory.BytesInputDecompressor decomp = this.codecFactory.getDecompressor(codecName);
            ByteBuffer input = inputPageData.nioBuffer(0, inputSize);
            ByteBuffer output = outputPageData.nioBuffer(0, outputSize);
            decomp.decompress(input, inputSize, output, outputSize);
            outputPageData.writerIndex(outputSize);
            timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
            if (logger.isTraceEnabled()) {
                logger.trace("Col: {}  readPos: {}  Uncompressed_size: {}  pageData: {}", new Object[]{this.columnChunkMetaData.toString(), this.dataReader.getPos(), outputSize, ByteBufUtil.hexDump(outputPageData)});
            }
            this.updateStats(this.pageHeader, "Decompress", start, timeToRead, inputSize, outputSize);
        }
        finally {
            if (inputPageData != null) {
                inputPageData.release();
            }
        }
        return outputPageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DrillBuf readCompressedPageV2() throws IOException {
        Stopwatch timer = Stopwatch.createUnstarted();
        int inputSize = this.pageHeader.getCompressed_page_size();
        int repLevelSize = this.pageHeader.data_page_header_v2.getRepetition_levels_byte_length();
        int defLevelSize = this.pageHeader.data_page_header_v2.getDefinition_levels_byte_length();
        int compDataOffset = repLevelSize + defLevelSize;
        int outputSize = this.pageHeader.uncompressed_page_size;
        long start = this.dataReader.getPos();
        DrillBuf inputPageData = null;
        DrillBuf outputPageData = this.allocator.buffer(outputSize);
        try {
            timer.start();
            inputPageData = this.dataReader.getNext(inputSize);
            long timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
            this.updateStats(this.pageHeader, "Page Read", start, timeToRead, inputSize, inputSize);
            timer.reset();
            timer.start();
            start = this.dataReader.getPos();
            outputPageData.setBytes(0, inputPageData, compDataOffset);
            CompressionCodecName codecName = this.columnChunkMetaData.getCodec();
            CompressionCodecFactory.BytesInputDecompressor decomp = this.codecFactory.getDecompressor(codecName);
            ByteBuffer input = inputPageData.nioBuffer(compDataOffset, inputSize - compDataOffset);
            ByteBuffer output = outputPageData.nioBuffer(compDataOffset, outputSize - compDataOffset);
            decomp.decompress(input, inputSize - compDataOffset, output, outputSize - compDataOffset);
            outputPageData.writerIndex(outputSize);
            timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
            if (logger.isTraceEnabled()) {
                logger.trace("Col: {}  readPos: {}  Uncompressed_size: {}  pageData: {}", new Object[]{this.columnChunkMetaData.toString(), this.dataReader.getPos(), outputSize, ByteBufUtil.hexDump(outputPageData)});
            }
            this.updateStats(this.pageHeader, "Decompress", start, timeToRead, inputSize, outputSize);
        }
        finally {
            if (inputPageData != null) {
                inputPageData.release();
            }
        }
        return outputPageData;
    }

    protected void readPageHeader() throws IOException {
        long start = this.dataReader.getPos();
        Stopwatch timer = Stopwatch.createStarted();
        this.pageHeader = Util.readPageHeader((InputStream)this.dataReader);
        long timeToRead = timer.elapsed(TimeUnit.NANOSECONDS);
        long pageHeaderBytes = this.dataReader.getPos() - start;
        this.updateStats(this.pageHeader, "Page Header", start, timeToRead, pageHeaderBytes, pageHeaderBytes);
        if (logger.isTraceEnabled()) {
            logger.trace("ParquetTrace,{},{},{},{},{},{},{},{}", new Object[]{"Page Header Read", "", this.parentColumnReader.parentReader.getHadoopPath(), this.columnDescriptor.toString(), start, 0, 0, timeToRead});
        }
    }

    protected void nextInternal() throws IOException {
        this.readPageHeader();
        if (this.pageHeader.uncompressed_page_size == 0) {
            logger.info("skipping a {} of size {} because its uncompressed size is 0 bytes.", (Object)this.pageHeader.getType(), (Object)this.pageHeader.compressed_page_size);
            this.skip(this.pageHeader.compressed_page_size);
            return;
        }
        switch (this.pageHeader.getType()) {
            case DICTIONARY_PAGE: {
                this.loadDictionary();
                break;
            }
            case DATA_PAGE: {
                this.pageData = this.codecName == CompressionCodecName.UNCOMPRESSED ? this.readUncompressedPage() : this.readCompressedPageV1();
                break;
            }
            case DATA_PAGE_V2: {
                this.pageData = this.codecName == CompressionCodecName.UNCOMPRESSED ? this.readUncompressedPage() : this.readCompressedPageV2();
                break;
            }
            default: {
                logger.info("skipping a {} of size {}", (Object)this.pageHeader.getType(), (Object)this.pageHeader.compressed_page_size);
                this.skip(this.pageHeader.compressed_page_size);
            }
        }
    }

    protected int decodeLevels() throws IOException {
        int dataOffset;
        int maxRepLevel = this.columnDescriptor.getMaxRepetitionLevel();
        int maxDefLevel = this.columnDescriptor.getMaxDefinitionLevel();
        switch (this.pageHeader.getType()) {
            case DATA_PAGE: {
                ByteBufferInputStream dataStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{this.pageData.nioBuffer(0, this.byteLength)});
                if (maxRepLevel > 0) {
                    Encoding rlEncoding = METADATA_CONVERTER.getEncoding(this.dataPageInfo.getRepetitionLevelEncoding());
                    ValuesReader rlReader = rlEncoding.getValuesReader(this.columnDescriptor, ValuesType.REPETITION_LEVEL);
                    rlReader.initFromPage(this.pageValueCount, dataStream);
                    this.repetitionLevels = new ValuesReaderIntIterator(rlReader);
                    this.repetitionLevels.nextInt();
                }
                if (maxDefLevel > 0) {
                    Encoding dlEncoding = METADATA_CONVERTER.getEncoding(this.dataPageInfo.getDefinitionLevelEncoding());
                    ValuesReader dlReader = dlEncoding.getValuesReader(this.columnDescriptor, ValuesType.DEFINITION_LEVEL);
                    dlReader.initFromPage(this.pageValueCount, dataStream);
                    this.definitionLevels = new ValuesReaderIntIterator(dlReader);
                }
                dataOffset = (int)dataStream.position();
                break;
            }
            case DATA_PAGE_V2: {
                int repLevelLen = this.pageHeader.data_page_header_v2.repetition_levels_byte_length;
                int defLevelLen = this.pageHeader.data_page_header_v2.definition_levels_byte_length;
                if (maxRepLevel > 0) {
                    this.repetitionLevels = this.newRLEIterator(maxRepLevel, BytesInput.from((ByteBuffer[])new ByteBuffer[]{this.pageData.nioBuffer(0, repLevelLen)}));
                    this.repetitionLevels.nextInt();
                }
                if (maxDefLevel > 0) {
                    this.definitionLevels = this.newRLEIterator(maxDefLevel, BytesInput.from((ByteBuffer[])new ByteBuffer[]{this.pageData.nioBuffer(repLevelLen, defLevelLen)}));
                }
                dataOffset = repLevelLen + defLevelLen;
                break;
            }
            default: {
                throw new DrillRuntimeException(String.format("Did not expect to find a page of type %s now.", this.pageHeader.getType()));
            }
        }
        return dataOffset;
    }

    public boolean next() throws IOException {
        this.pageValueCount = -1;
        this.valuesReadyToRead = 0;
        this.valuesRead = 0;
        this.parentColumnReader.currDefLevel = -1;
        long totalValueCount = this.columnChunkMetaData.getValueCount();
        if ((long)this.parentColumnReader.totalValuesRead >= totalValueCount) {
            return false;
        }
        this.clearDataBufferAndReaders();
        do {
            this.nextInternal();
            if (this.pageHeader != null) continue;
            throw new DrillRuntimeException(String.format("Failed to read another page having read %d of %d values from its column chunk.", this.parentColumnReader.totalValuesRead, totalValueCount));
        } while (this.pageHeader.uncompressed_page_size == 0 || this.pageHeader.getType() != PageType.DATA_PAGE && this.pageHeader.getType() != PageType.DATA_PAGE_V2);
        if (this.pageData == null) {
            throw new DrillRuntimeException(String.format("Failed to read another page having read %d of %d values from its column chunk.", this.parentColumnReader.totalValuesRead, totalValueCount));
        }
        this.dataPageInfo = DataPageHeaderInfoProvider.builder(this.pageHeader);
        this.byteLength = this.pageHeader.uncompressed_page_size;
        this.pageValueCount = this.dataPageInfo.getNumValues();
        Stopwatch timer = Stopwatch.createStarted();
        this.readyToReadPosInBytes = this.readPosInBytes = (long)this.decodeLevels();
        Encoding valueEncoding = METADATA_CONVERTER.getEncoding(this.dataPageInfo.getEncoding());
        this.parentColumnReader.usingDictionary = valueEncoding.usesDictionary();
        long timeDecode = timer.elapsed(TimeUnit.NANOSECONDS);
        this.stats.numDataPagesDecoded.incrementAndGet();
        this.stats.timeDataPageDecode.addAndGet(timeDecode);
        return true;
    }

    public ValuesReader getValueReader() {
        if (this.valueReader == null) {
            Encoding valueEncoding = METADATA_CONVERTER.getEncoding(this.dataPageInfo.getEncoding());
            ByteBuffer dataBuffer = this.pageData.nioBuffer((int)this.readPosInBytes, this.byteLength - (int)this.readPosInBytes);
            this.valueReader = valueEncoding.getValuesReader(this.columnDescriptor, ValuesType.VALUES);
            try {
                this.valueReader.initFromPage(this.pageValueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{dataBuffer}));
            }
            catch (IOException e) {
                throw new DrillRuntimeException("Error initialising a ValuesReader for this page.", e);
            }
        }
        return this.valueReader;
    }

    public ValuesReader getDictionaryLengthDeterminingReader() {
        if (this.dictionaryLengthDeterminingReader == null) {
            ByteBuffer dataBuffer = this.pageData.nioBuffer((int)this.readPosInBytes, this.byteLength - (int)this.readPosInBytes);
            this.dictionaryLengthDeterminingReader = new DictionaryValuesReader(this.dictionary);
            try {
                this.dictionaryLengthDeterminingReader.initFromPage(this.pageValueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{dataBuffer}));
            }
            catch (IOException e) {
                throw new DrillRuntimeException("Error initialising a dictionary length determining ValuesReader for this page.", e);
            }
        }
        return this.dictionaryLengthDeterminingReader;
    }

    public ValuesReader getDictionaryValueReader() {
        if (this.dictionaryValueReader == null) {
            ByteBuffer dataBuffer = this.pageData.nioBuffer((int)this.readPosInBytes, this.byteLength - (int)this.readPosInBytes);
            this.dictionaryValueReader = new DictionaryValuesReader(this.dictionary);
            try {
                this.dictionaryValueReader.initFromPage(this.pageValueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{dataBuffer}));
            }
            catch (IOException e) {
                throw new DrillRuntimeException("Error initialising a dictionary ValuesReader for this page.", e);
            }
        }
        return this.dictionaryValueReader;
    }

    protected boolean hasPage() {
        return this.pageValueCount != -1;
    }

    protected void updateStats(PageHeader pageHeader, String op, long start, long time, long bytesin, long bytesout) {
        if (logger.isTraceEnabled()) {
            logger.trace("ParquetTrace,{},{},{},{},{},{},{},{}", new Object[]{op, pageHeader.type == PageType.DICTIONARY_PAGE ? "Dictionary Page" : "Data Page", this.parentColumnReader.parentReader.getHadoopPath(), this.columnDescriptor.toString(), start, bytesin, bytesout, time});
        }
        if (pageHeader.type == PageType.DICTIONARY_PAGE) {
            if (bytesin == bytesout) {
                this.stats.timeDictPageLoads.addAndGet(time);
                this.stats.numDictPageLoads.incrementAndGet();
                this.stats.totalDictPageReadBytes.addAndGet(bytesin);
            } else {
                this.stats.timeDictPagesDecompressed.addAndGet(time);
                this.stats.numDictPagesDecompressed.incrementAndGet();
                this.stats.totalDictDecompressedBytes.addAndGet(bytesin);
            }
        } else if (bytesin == bytesout) {
            this.stats.timeDataPageLoads.addAndGet(time);
            this.stats.numDataPageLoads.incrementAndGet();
            this.stats.totalDataPageReadBytes.addAndGet(bytesin);
        } else {
            this.stats.timeDataPagesDecompressed.addAndGet(time);
            this.stats.numDataPagesDecompressed.incrementAndGet();
            this.stats.totalDataDecompressedBytes.addAndGet(bytesin);
        }
    }

    protected void clearDataBufferAndReaders() {
        if (this.pageData != null) {
            this.pageData.release();
            this.pageData = null;
        }
        this.valueReader = null;
        this.dictionaryLengthDeterminingReader = null;
        this.dictionaryValueReader = null;
    }

    protected void clearDictionaryBuffer() {
        if (this.dictData != null) {
            this.dictData.release();
            this.dictData = null;
        }
    }

    public void clear() {
        try {
            this.dataReader.close();
        }
        catch (IOException e) {
            logger.warn("encountered an error when it tried to close its input stream: {}", (Throwable)e);
        }
        this.clearDataBufferAndReaders();
        this.clearDictionaryBuffer();
    }

    void resetDefinitionLevelReader(int skipCount) throws IOException {
        Preconditions.checkState(this.columnDescriptor.getMaxDefinitionLevel() == 1);
        Preconditions.checkState(this.pageValueCount > 0);
        this.decodeLevels();
        for (int idx = 0; idx < skipCount; ++idx) {
            this.definitionLevels.nextInt();
        }
    }

    public static BytesInput asBytesInput(DrillBuf buf, int offset, int length) throws IOException {
        return BytesInput.from((ByteBuffer[])new ByteBuffer[]{buf.nioBuffer(offset, length)});
    }

    private IntIterator newRLEIterator(int maxLevel, BytesInput bytes) throws IOException {
        if (maxLevel == 0) {
            return new NullIntIterator();
        }
        return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)bytes.toInputStream()));
    }

    static class ValuesReaderIntIterator
    implements IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            return this.delegate.readInteger();
        }
    }

    static interface IntIterator {
        public int nextInt();
    }

    private static final class NullIntIterator
    implements IntIterator {
        private NullIntIterator() {
        }

        @Override
        public int nextInt() {
            return 0;
        }
    }

    private static class RLEIntIterator
    implements IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        public int nextInt() {
            try {
                return this.delegate.readInt();
            }
            catch (IOException e) {
                throw new ParquetDecodingException((Throwable)e);
            }
        }
    }
}

