/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.store.parquet.ParquetReaderUtility;
import org.apache.drill.exec.store.parquet.columnreaders.FixedByteAlignedReader;
import org.apache.drill.exec.store.parquet.columnreaders.ParquetRecordReader;
import org.apache.drill.exec.vector.BigIntVector;
import org.apache.drill.exec.vector.Float4Vector;
import org.apache.drill.exec.vector.Float8Vector;
import org.apache.drill.exec.vector.IntVector;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.TimeVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.UInt8Vector;
import org.apache.drill.exec.vector.VarBinaryVector;
import org.apache.drill.exec.vector.VarDecimalVector;
import org.apache.drill.shaded.guava.com.google.common.primitives.Ints;
import org.apache.drill.shaded.guava.com.google.common.primitives.Longs;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;

public class ParquetFixedWidthDictionaryReaders {
    private static final double BITS_COUNT_IN_BYTE_DOUBLE_VALUE = 8.0;

    static class DictionaryFloat8Reader
    extends FixedByteAlignedReader<Float8Vector> {
        DictionaryFloat8Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, Float8Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((Float8Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readDouble());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryFloat4Reader
    extends FixedByteAlignedReader<Float4Vector> {
        DictionaryFloat4Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, Float4Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((Float4Vector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readFloat());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryBinaryAsTimeStampReader
    extends FixedByteAlignedReader<TimeStampVector> {
        DictionaryBinaryAsTimeStampReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, TimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    Binary binaryTimeStampValue = valReader.readBytes();
                    ((TimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, ParquetReaderUtility.NanoTimeUtils.getDateTimeValueFromBinary(binaryTimeStampValue, true));
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryTimeStampMicrosReader
    extends FixedByteAlignedReader<TimeStampVector> {
        DictionaryTimeStampMicrosReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, TimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((TimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong() / 1000L);
                    ++i;
                }
            } else {
                int dataTypeLengthInBytes = (int)Math.ceil((double)this.dataTypeLengthInBits / 8.0);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    long value = this.pageReader.pageData.getLong((int)this.readStartInBytes + i * dataTypeLengthInBytes);
                    ((TimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, value / 1000L);
                    ++i;
                }
            }
        }
    }

    static class DictionaryTimeStampReader
    extends FixedByteAlignedReader<TimeStampVector> {
        DictionaryTimeStampReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, TimeStampVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((TimeStampVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryVarDecimalReader
    extends FixedByteAlignedReader<VarDecimalVector> {
        DictionaryVarDecimalReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, VarDecimalVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            int dataTypeLengthInBytes = (int)Math.ceil((double)this.dataTypeLengthInBits / 8.0);
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            switch (this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName()) {
                case INT32: {
                    if (this.recordsRequireDecoding()) {
                        ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            byte[] bytes = Ints.toByteArray(valReader.readInteger());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            byte[] bytes = Ints.toByteArray(this.pageReader.pageData.getInt((int)this.readStartInBytes + i * dataTypeLengthInBytes));
                            ((VarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, bytes, 0, dataTypeLengthInBytes);
                            ++i;
                        }
                    }
                    break;
                }
                case INT64: {
                    if (this.recordsRequireDecoding()) {
                        ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            byte[] bytes = Longs.toByteArray(valReader.readLong());
                            this.setValueBytes(i, bytes);
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            byte[] bytes = Longs.toByteArray(this.pageReader.pageData.getLong((int)this.readStartInBytes + i * dataTypeLengthInBytes));
                            ((VarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, bytes, 0, dataTypeLengthInBytes);
                            ++i;
                        }
                    }
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: {
                    if (this.recordsRequireDecoding()) {
                        ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                        VarDecimalVector.Mutator mutator = ((VarDecimalVector)this.valueVec).getMutator();
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            Binary currDictValToWrite = valReader.readBytes();
                            mutator.setSafe(this.valuesReadInCurrentPass + i, currDictValToWrite.toByteBuffer().slice(), 0, currDictValToWrite.length());
                            ++i;
                        }
                    } else {
                        int i = 0;
                        while ((long)i < this.recordsReadInThisIteration) {
                            int start = (int)this.readStartInBytes + i * dataTypeLengthInBytes;
                            ((VarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, start, start + dataTypeLengthInBytes, this.pageReader.pageData);
                            ++i;
                        }
                    }
                    break;
                }
            }
        }

        private void setValueBytes(int i, byte[] bytes) {
            ((VarDecimalVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, bytes, 0, bytes.length);
        }
    }

    static class DictionaryUInt8Reader
    extends FixedByteAlignedReader<UInt8Vector> {
        DictionaryUInt8Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, UInt8Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                UInt8Vector.Mutator mutator = ((UInt8Vector)this.valueVec).getMutator();
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    mutator.setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryBigIntReader
    extends FixedByteAlignedReader<BigIntVector> {
        DictionaryBigIntReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, BigIntVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                BigIntVector.Mutator mutator = ((BigIntVector)this.valueVec).getMutator();
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    mutator.setSafe(this.valuesReadInCurrentPass + i, valReader.readLong());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryTimeMicrosReader
    extends FixedByteAlignedReader<TimeVector> {
        DictionaryTimeMicrosReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, TimeVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((TimeVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, (int)(valReader.readLong() / 1000L));
                    ++i;
                }
            } else {
                int dataTypeLengthInBytes = (int)Math.ceil((double)this.dataTypeLengthInBits / 8.0);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    long value = this.pageReader.pageData.getLong((int)this.readStartInBytes + i * dataTypeLengthInBytes);
                    ((TimeVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, (int)(value / 1000L));
                    ++i;
                }
            }
        }
    }

    static class DictionaryTimeReader
    extends FixedByteAlignedReader<TimeVector> {
        DictionaryTimeReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, TimeVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((TimeVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryFixedBinaryReader
    extends FixedByteAlignedReader<VarBinaryVector> {
        DictionaryFixedBinaryReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, VarBinaryVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                VarBinaryVector.Mutator mutator = ((VarBinaryVector)this.valueVec).getMutator();
                Binary currDictValToWrite = null;
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    currDictValToWrite = valReader.readBytes();
                    mutator.setSafe(this.valuesReadInCurrentPass + i, currDictValToWrite.toByteBuffer().slice(), 0, currDictValToWrite.length());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
            int byteLength = this.dataTypeLengthInBits / 8;
            int i = 0;
            while ((long)i < recordsToReadInThisPass) {
                ((VarBinaryVector)this.valueVec).getMutator().setValueLengthSafe(this.valuesReadInCurrentPass + i, byteLength);
                ++i;
            }
        }
    }

    static class DictionaryUInt4Reader
    extends FixedByteAlignedReader<UInt4Vector> {
        DictionaryUInt4Reader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, UInt4Vector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                UInt4Vector.Mutator mutator = ((UInt4Vector)this.valueVec).getMutator();
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    mutator.setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }

    static class DictionaryIntReader
    extends FixedByteAlignedReader<IntVector> {
        DictionaryIntReader(ParquetRecordReader parentReader, ColumnDescriptor descriptor, ColumnChunkMetaData columnChunkMetaData, boolean fixedLength, IntVector v, SchemaElement schemaElement) throws ExecutionSetupException {
            super(parentReader, descriptor, columnChunkMetaData, fixedLength, v, schemaElement);
        }

        @Override
        protected void readField(long recordsToReadInThisPass) {
            if (this.recordsRequireDecoding()) {
                ValuesReader valReader = this.usingDictionary ? this.pageReader.getDictionaryValueReader() : this.pageReader.getValueReader();
                this.recordsReadInThisIteration = Math.min((long)(this.pageReader.pageValueCount - this.pageReader.valuesRead), recordsToReadInThisPass - (long)this.valuesReadInCurrentPass);
                int i = 0;
                while ((long)i < this.recordsReadInThisIteration) {
                    ((IntVector)this.valueVec).getMutator().setSafe(this.valuesReadInCurrentPass + i, valReader.readInteger());
                    ++i;
                }
            } else {
                super.readField(recordsToReadInThisPass);
            }
        }
    }
}

