/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.parquet.columnreaders;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkEntry;
import org.apache.drill.exec.store.parquet.columnreaders.VarLenColumnBulkInput;

abstract class VarLenAbstractEntryReader {
    protected final ByteBuffer buffer;
    protected final VarLenColumnBulkEntry entry;
    private final VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback;

    VarLenAbstractEntryReader(ByteBuffer buffer, VarLenColumnBulkEntry entry, VarLenColumnBulkInput.VarLenColumnBulkInputCallback containerCallback) {
        this.buffer = buffer;
        this.entry = entry;
        this.containerCallback = containerCallback;
    }

    abstract VarLenColumnBulkEntry getEntry(int var1);

    protected boolean batchMemoryConstraintsReached(int newBitsMemory, int newOffsetsMemory, int newDataMemory) {
        return this.containerCallback.batchMemoryConstraintsReached(newBitsMemory, newOffsetsMemory, newDataMemory);
    }

    static final int getInt(byte[] buff, int pos) {
        return DrillBuf.getInt(buff, pos);
    }

    static void vlCopy(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        if (length <= 8) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
        } else {
            VarLenAbstractEntryReader.vlCopyGTLongWithPadding(src, srcIndex, dest, destIndex, length);
        }
    }

    static void vlCopyNoPadding(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        if (length <= 8) {
            VarLenAbstractEntryReader.vlCopyLELongNoPadding(src, srcIndex, dest, destIndex, length);
        } else {
            VarLenAbstractEntryReader.vlCopyGTLongNoPadding(src, srcIndex, dest, destIndex, length);
        }
    }

    private static void vlCopyGTLongWithPadding(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        int bulkCopyThreshold = 24;
        if (length < 24) {
            VarLenAbstractEntryReader._vlCopyGTLongWithPadding(src, srcIndex, dest, destIndex, length);
        } else {
            System.arraycopy(src, srcIndex, dest, destIndex, length);
        }
    }

    private static void _vlCopyGTLongWithPadding(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        int numLongEntries = length >> 3;
        assert (numLongEntries < 3);
        int remaining = length & 7;
        int prevCopied = 0;
        if (numLongEntries == 1) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
            prevCopied = 8;
        } else {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
            DrillBuf.putLong(src, srcIndex + 8, dest, destIndex + 8);
            prevCopied = 16;
        }
        if (remaining > 0) {
            int srcPos = srcIndex + prevCopied;
            int destPos = destIndex + prevCopied;
            DrillBuf.putLong(src, srcPos, dest, destPos);
        }
    }

    private static final void vlCopyLELongNoPadding(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        if (length == 1) {
            dest[destIndex] = src[srcIndex];
        } else if (length == 2) {
            DrillBuf.putShort(src, srcIndex, dest, destIndex);
        } else if (length == 3) {
            dest[destIndex] = src[srcIndex];
            DrillBuf.putShort(src, srcIndex + 1, dest, destIndex + 1);
        } else if (length == 4) {
            DrillBuf.putInt(src, srcIndex, dest, destIndex);
        } else if (length == 5) {
            dest[destIndex] = src[srcIndex];
            DrillBuf.putInt(src, srcIndex + 1, dest, destIndex + 1);
        } else if (length == 6) {
            DrillBuf.putShort(src, srcIndex, dest, destIndex);
            DrillBuf.putInt(src, srcIndex + 2, dest, destIndex + 2);
        } else if (length == 7) {
            dest[destIndex] = src[srcIndex];
            DrillBuf.putShort(src, srcIndex + 1, dest, destIndex + 1);
            DrillBuf.putInt(src, srcIndex + 3, dest, destIndex + 3);
        } else {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
        }
    }

    private static final void vlCopyGTLongNoPadding(byte[] src, int srcIndex, byte[] dest, int destIndex, int length) {
        int numLongEntries = length >> 3;
        int remaining = length & 7;
        if (numLongEntries == 1) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
        } else if (numLongEntries == 2) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
            DrillBuf.putLong(src, srcIndex + 8, dest, destIndex + 8);
        } else if (numLongEntries == 3) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
            DrillBuf.putLong(src, srcIndex + 8, dest, destIndex + 8);
            DrillBuf.putLong(src, srcIndex + 16, dest, destIndex + 16);
        } else if (numLongEntries == 4) {
            DrillBuf.putLong(src, srcIndex, dest, destIndex);
            DrillBuf.putLong(src, srcIndex + 8, dest, destIndex + 8);
            DrillBuf.putLong(src, srcIndex + 16, dest, destIndex + 16);
            DrillBuf.putLong(src, srcIndex + 24, dest, destIndex + 24);
        } else {
            for (int idx = 0; idx < numLongEntries; ++idx) {
                DrillBuf.putLong(src, srcIndex + idx * 8, dest, destIndex + idx * 8);
            }
        }
        if (remaining > 0) {
            int srcPos = srcIndex + numLongEntries * 8;
            int destPos = destIndex + numLongEntries * 8;
            if (srcPos + 7 < src.length) {
                DrillBuf.putLong(src, srcPos, dest, destPos);
            } else {
                VarLenAbstractEntryReader.vlCopyLELongNoPadding(src, srcPos, dest, destPos, remaining);
            }
        }
    }
}

